/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractTempRefactoring;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.TextInputWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.TempNameProcessor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.RowLayouter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class ExtractTempWizard
extends RefactoringWizard {
    public ExtractTempWizard(ExtractTempRefactoring ref) {
        super((Refactoring)ref, 36);
        this.setDefaultPageTitle(RefactoringMessages.getString("ExtractTempWizard.defaultPageTitle"));
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new ExtractTempInputPage(this.getExtractTempRefactoring().guessTempNames()));
    }

    private ExtractTempRefactoring getExtractTempRefactoring() {
        return (ExtractTempRefactoring)this.getRefactoring();
    }

    private static class ExtractTempInputPage
    extends TextInputWizardPage {
        private Label fLabel;
        private final boolean fInitialValid;
        private static final String DESCRIPTION = RefactoringMessages.getString("ExtractTempInputPage.enter_name");
        private String[] fTempNameProposals;

        public ExtractTempInputPage(String[] tempNameProposals) {
            super(DESCRIPTION, true, tempNameProposals.length == 0 ? "" : tempNameProposals[0]);
            Assert.isNotNull((Object)tempNameProposals);
            this.fTempNameProposals = tempNameProposals;
            this.fInitialValid = tempNameProposals.length > 0;
        }

        public void createControl(Composite parent) {
            Composite result = new Composite(parent, 0);
            this.setControl((Control)result);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 8;
            result.setLayout((Layout)layout);
            RowLayouter layouter = new RowLayouter(2);
            Label label = new Label(result, 0);
            label.setText(RefactoringMessages.getString("ExtractTempInputPage.variable_name"));
            Text text = this.createTextInputField(result);
            text.selectAll();
            text.setLayoutData((Object)new GridData(768));
            ControlContentAssistHelper.createTextContentAssistant(text, new TempNameProcessor(this.fTempNameProposals));
            layouter.perform((Control)label, (Control)text, 1);
            this.addReplaceAllCheckbox(result, layouter);
            this.addDeclareFinalCheckbox(result, layouter);
            this.addSeparator(result, layouter);
            this.addLabel(result, layouter);
            this.validateTextField(text.getText());
            Dialog.applyDialogFont((Control)result);
            WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.extract_temp_page_context");
        }

        private void addReplaceAllCheckbox(Composite result, RowLayouter layouter) {
            String title = RefactoringMessages.getString("ExtractTempInputPage.replace_all");
            boolean defaultValue = this.getExtractTempRefactoring().replaceAllOccurrences();
            Button checkBox = ExtractTempInputPage.createCheckbox(result, title, defaultValue, layouter);
            this.getExtractTempRefactoring().setReplaceAllOccurrences(checkBox.getSelection());
            checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(this, checkBox){
                private final /* synthetic */ Button val$checkBox;
                private final /* synthetic */ ExtractTempInputPage this$0;
                {
                    this.this$0 = this$0;
                    this.val$checkBox = val$checkBox;
                }

                public void widgetSelected(SelectionEvent e) {
                    ExtractTempInputPage.access$000(this.this$0).setReplaceAllOccurrences(this.val$checkBox.getSelection());
                }
            });
        }

        private void addDeclareFinalCheckbox(Composite result, RowLayouter layouter) {
            String title = RefactoringMessages.getString("ExtractTempInputPage.declare_final");
            boolean defaultValue = this.getExtractTempRefactoring().declareFinal();
            Button checkBox = ExtractTempInputPage.createCheckbox(result, title, defaultValue, layouter);
            this.getExtractTempRefactoring().setDeclareFinal(checkBox.getSelection());
            checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(this, checkBox){
                private final /* synthetic */ Button val$checkBox;
                private final /* synthetic */ ExtractTempInputPage this$0;
                {
                    this.this$0 = this$0;
                    this.val$checkBox = val$checkBox;
                }

                public void widgetSelected(SelectionEvent e) {
                    ExtractTempInputPage.access$000(this.this$0).setDeclareFinal(this.val$checkBox.getSelection());
                }
            });
        }

        private void addLabel(Composite result, RowLayouter layouter) {
            this.fLabel = new Label(result, 64);
            GridData gd = new GridData(1808);
            gd.widthHint = this.convertWidthInCharsToPixels(50);
            this.fLabel.setLayoutData((Object)gd);
            this.updatePreviewLabel();
            layouter.perform((Control)this.fLabel);
        }

        private void addSeparator(Composite result, RowLayouter layouter) {
            Label separator = new Label(result, 258);
            separator.setLayoutData((Object)new GridData(768));
            layouter.perform((Control)separator);
        }

        private void updatePreviewLabel() {
            try {
                if (this.fLabel != null) {
                    this.fLabel.setText(RefactoringMessages.getString("ExtractTempInputPage.signature_preview") + this.getExtractTempRefactoring().getTempSignaturePreview());
                }
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("ExtractTempInputPage.extract_local"), RefactoringMessages.getString("ExtractTempInputPage.exception"));
            }
        }

        protected void textModified(String text) {
            this.getExtractTempRefactoring().setTempName(text);
            this.updatePreviewLabel();
            super.textModified(text);
        }

        protected RefactoringStatus validateTextField(String text) {
            return this.getExtractTempRefactoring().checkTempName(text);
        }

        private ExtractTempRefactoring getExtractTempRefactoring() {
            return (ExtractTempRefactoring)this.getRefactoring();
        }

        private static Button createCheckbox(Composite parent, String title, boolean value, RowLayouter layouter) {
            Button checkBox = new Button(parent, 32);
            checkBox.setText(title);
            checkBox.setSelection(value);
            layouter.perform((Control)checkBox);
            return checkBox;
        }

        protected boolean isInitialInputValid() {
            return this.fInitialValid;
        }

        static /* synthetic */ ExtractTempRefactoring access$000(ExtractTempInputPage x0) {
            return x0.getExtractTempRefactoring();
        }
    }
}

