/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ltk.internal.ui.refactoring.AbstractDescriptor;
import org.eclipse.ltk.internal.ui.refactoring.Assert;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;

public abstract class DescriptorManager {
    private String fExtensionPoint;
    private String fVariableName;
    private AbstractDescriptor[] fExtensions;

    public DescriptorManager(String extensionPoint, String variableName) {
        Assert.isNotNull(extensionPoint);
        Assert.isNotNull(variableName);
        this.fExtensionPoint = extensionPoint;
        this.fVariableName = variableName;
    }

    public AbstractDescriptor getDescriptor(Object element) throws CoreException {
        if (this.fExtensions == null) {
            this.init();
        }
        ArrayList<AbstractDescriptor> candidates = new ArrayList<AbstractDescriptor>(1);
        for (int i = 0; i < this.fExtensions.length; ++i) {
            AbstractDescriptor descriptor = this.fExtensions[i];
            if (descriptor.matches(element, this.fVariableName)) {
                candidates.add(descriptor);
            }
            descriptor.clear();
        }
        if (candidates.size() == 0) {
            return null;
        }
        return (AbstractDescriptor)candidates.get(0);
    }

    protected abstract AbstractDescriptor createDescriptor(IConfigurationElement var1);

    private void init() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor(RefactoringUIPlugin.getPluginId(), this.fExtensionPoint);
        this.fExtensions = new AbstractDescriptor[ces.length];
        for (int i = 0; i < ces.length; ++i) {
            this.fExtensions[i] = this.createDescriptor(ces[i]);
        }
    }
}

