/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

class PortWatcher
implements Runnable {
    private static Vector pool = new Vector();
    Session session;
    int lport;
    int rport;
    String host;
    String boundaddress;
    ServerSocket ss;
    Runnable thread;

    static String[] getPortForwarding(Session session) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < pool.size(); ++i) {
            PortWatcher portWatcher = (PortWatcher)pool.elementAt(i);
            if (portWatcher.session != session) continue;
            vector.addElement(portWatcher.lport + ":" + portWatcher.host + ":" + portWatcher.rport);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    static PortWatcher getPort(Session session, int n) {
        for (int i = 0; i < pool.size(); ++i) {
            PortWatcher portWatcher = (PortWatcher)pool.elementAt(i);
            if (portWatcher.session != session || portWatcher.lport != n) continue;
            return portWatcher;
        }
        return null;
    }

    static PortWatcher addPort(Session session, String string, int n, String string2, int n2) throws JSchException {
        if (PortWatcher.getPort(session, n) != null) {
            throw new JSchException("PortForwardingL: local port " + n + " is already registered.");
        }
        PortWatcher portWatcher = new PortWatcher(session, string, n, string2, n2);
        pool.addElement(portWatcher);
        return portWatcher;
    }

    static void delPort(Session session, int n) throws JSchException {
        PortWatcher portWatcher = PortWatcher.getPort(session, n);
        if (portWatcher == null) {
            throw new JSchException("PortForwardingL: local port " + n + " is not registered.");
        }
        portWatcher.delete();
        pool.removeElement(portWatcher);
    }

    static void delPort(Session session) {
        for (int i = 0; i < pool.size(); ++i) {
            PortWatcher portWatcher = (PortWatcher)pool.elementAt(i);
            if (portWatcher.session != session) continue;
            portWatcher.delete();
            pool.removeElement(portWatcher);
            --i;
        }
    }

    PortWatcher(Session session, String string, int n, String string2, int n2) throws JSchException {
        this.session = session;
        this.boundaddress = string;
        this.lport = n;
        this.host = string2;
        this.rport = n2;
        try {
            this.ss = new ServerSocket(n, 0, InetAddress.getByName(this.boundaddress));
        }
        catch (Exception exception) {
            System.out.println(exception);
            throw new JSchException("PortForwardingL: local port " + n + " cannot be bound.");
        }
    }

    public void run() {
        Buffer buffer = new Buffer(300);
        Packet packet = new Packet(buffer);
        this.thread = this;
        try {
            while (this.thread != null) {
                Socket socket = this.ss.accept();
                socket.setTcpNoDelay(true);
                InputStream inputStream = socket.getInputStream();
                OutputStream outputStream = socket.getOutputStream();
                ChannelDirectTCPIP channelDirectTCPIP = new ChannelDirectTCPIP();
                channelDirectTCPIP.init();
                channelDirectTCPIP.setInputStream(inputStream);
                channelDirectTCPIP.setOutputStream(outputStream);
                this.session.addChannel(channelDirectTCPIP);
                channelDirectTCPIP.setHost(this.host);
                channelDirectTCPIP.setPort(this.rport);
                channelDirectTCPIP.setOrgIPAddress(socket.getInetAddress().getHostAddress());
                channelDirectTCPIP.setOrgPort(socket.getPort());
                channelDirectTCPIP.connect();
                if (channelDirectTCPIP.exitstatus == -1) continue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void delete() {
        this.thread = null;
        try {
            this.ss.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

