/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTSyntaxErrorPropagator;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DefaultCommentMapper;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.DocCommentParser;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.IntLiteralMinValue;
import org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocArgumentExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.LongLiteralMinValue;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.OR_OR_Expression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.parser.Scanner;

class ASTConverter {
    private AST ast;
    char[] compilationUnitSource;
    Scanner scanner;
    private boolean resolveBindings;
    private Set pendingThisExpressionScopeResolution;
    private Set pendingNameScopeResolution;
    private IProgressMonitor monitor;
    private boolean insideComments;
    private DocCommentParser docParser;
    private Comment[] commentsTable;
    private DefaultCommentMapper commentMapper;

    public ASTConverter(Map options, boolean resolveBindings, IProgressMonitor monitor) {
        this.resolveBindings = resolveBindings;
        this.scanner = new Scanner(true, false, false, "1.4".equals(options.get("org.eclipse.jdt.core.compiler.source")) ? 0x300000L : 0x2F0000L, null, null, true);
        this.monitor = monitor;
        this.insideComments = "enabled".equals(options.get("org.eclipse.jdt.core.compiler.doc.comment.support"));
    }

    public void setAST(AST ast) {
        this.ast = ast;
        this.docParser = new DocCommentParser(this.ast, this.scanner, this.insideComments);
    }

    public TypeDeclaration convert(org.eclipse.jdt.internal.compiler.ast.ASTNode[] nodes) {
        TypeDeclaration typeDecl = this.ast.newTypeDeclaration();
        int nodesLength = nodes.length;
        for (int i = 0; i < nodesLength; ++i) {
            org.eclipse.jdt.internal.compiler.ast.ASTNode node = nodes[i];
            if (node instanceof org.eclipse.jdt.internal.compiler.ast.Initializer) {
                org.eclipse.jdt.internal.compiler.ast.Initializer oldInitializer = (org.eclipse.jdt.internal.compiler.ast.Initializer)node;
                Initializer initializer = this.ast.newInitializer();
                initializer.setBody(this.convert(oldInitializer.block));
                initializer.setModifiers(oldInitializer.modifiers);
                initializer.setSourceRange(oldInitializer.declarationSourceStart, oldInitializer.sourceEnd - oldInitializer.declarationSourceStart + 1);
                this.convert(oldInitializer.javadoc, initializer);
                typeDecl.bodyDeclarations().add(initializer);
                continue;
            }
            if (node instanceof org.eclipse.jdt.internal.compiler.ast.FieldDeclaration) {
                org.eclipse.jdt.internal.compiler.ast.FieldDeclaration fieldDeclaration = (org.eclipse.jdt.internal.compiler.ast.FieldDeclaration)node;
                if (i > 0 && nodes[i - 1] instanceof org.eclipse.jdt.internal.compiler.ast.FieldDeclaration && ((org.eclipse.jdt.internal.compiler.ast.FieldDeclaration)nodes[i - 1]).declarationSourceStart == fieldDeclaration.declarationSourceStart) {
                    FieldDeclaration currentFieldDeclaration = (FieldDeclaration)typeDecl.bodyDeclarations().get(typeDecl.bodyDeclarations().size() - 1);
                    currentFieldDeclaration.fragments().add(this.convertToVariableDeclarationFragment(fieldDeclaration));
                    continue;
                }
                typeDecl.bodyDeclarations().add(this.convertToFieldDeclaration(fieldDeclaration));
                continue;
            }
            if (node instanceof AbstractMethodDeclaration) {
                AbstractMethodDeclaration nextMethodDeclaration = (AbstractMethodDeclaration)node;
                if (nextMethodDeclaration.isDefaultConstructor() || nextMethodDeclaration.isClinit()) continue;
                typeDecl.bodyDeclarations().add(this.convert(nextMethodDeclaration));
                continue;
            }
            if (!(node instanceof org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)) continue;
            org.eclipse.jdt.internal.compiler.ast.TypeDeclaration nextMemberDeclaration = (org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)node;
            typeDecl.bodyDeclarations().add(this.convert(nextMemberDeclaration));
        }
        return typeDecl;
    }

    public CompilationUnit convert(CompilationUnitDeclaration unit, char[] source) {
        org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[] types;
        int[][] comments;
        ImportReference[] imports;
        this.compilationUnitSource = source;
        this.scanner.setSource(source);
        this.scanner.lineEnds = unit.compilationResult().lineSeparatorPositions;
        CompilationUnit compilationUnit = this.ast.newCompilationUnit();
        if (this.resolveBindings) {
            this.recordNodes(compilationUnit, unit);
        }
        if (unit.currentPackage != null) {
            PackageDeclaration packageDeclaration = this.convertPackage(unit);
            compilationUnit.setPackage(packageDeclaration);
        }
        if ((imports = unit.imports) != null) {
            int importLength = imports.length;
            for (int i = 0; i < importLength; ++i) {
                compilationUnit.imports().add(this.convertImport(imports[i]));
            }
        }
        if ((comments = unit.comments) != null) {
            this.buildCommentsTable(compilationUnit, comments);
        }
        if ((types = unit.types) != null) {
            int typesLength = types.length;
            for (int i = 0; i < typesLength; ++i) {
                compilationUnit.types().add(this.convert(types[i]));
            }
        }
        compilationUnit.setSourceRange(unit.sourceStart, unit.sourceEnd - unit.sourceStart + 1);
        int problemLength = unit.compilationResult.problemCount;
        if (problemLength != 0) {
            IProblem[] resizedProblems = null;
            IProblem[] problems = unit.compilationResult.problems;
            if (problems.length == problemLength) {
                resizedProblems = problems;
            } else {
                resizedProblems = new IProblem[problemLength];
                System.arraycopy(problems, 0, resizedProblems, 0, problemLength);
            }
            this.propagateErrors(compilationUnit, resizedProblems);
            compilationUnit.setProblems(resizedProblems);
        }
        if (this.resolveBindings) {
            this.lookupForScopes();
        }
        compilationUnit.initCommentMapper(this.scanner);
        return compilationUnit;
    }

    void buildCommentsTable(CompilationUnit compilationUnit, int[][] comments) {
        this.commentsTable = new Comment[comments.length];
        int nbr = 0;
        for (int i = 0; i < comments.length; ++i) {
            Comment comment = this.createComment(comments[i]);
            if (comment == null) continue;
            comment.setAlternateRoot(compilationUnit);
            this.commentsTable[nbr++] = comment;
        }
        if (nbr < comments.length) {
            Comment[] newCommentsTable = new Comment[nbr];
            System.arraycopy(this.commentsTable, 0, newCommentsTable, 0, nbr);
            this.commentsTable = newCommentsTable;
        }
        compilationUnit.setCommentTable(this.commentsTable);
    }

    public PackageDeclaration convertPackage(CompilationUnitDeclaration compilationUnitDeclaration) {
        ImportReference importReference = compilationUnitDeclaration.currentPackage;
        PackageDeclaration packageDeclaration = this.ast.newPackageDeclaration();
        char[][] tokens = importReference.tokens;
        int length = importReference.tokens.length;
        long[] positions = importReference.sourcePositions;
        int start = (int)(positions[0] >>> 32);
        int end = (int)(positions[length - 1] & 0xFFFFFFFFFFFFFFFFL);
        Name name = null;
        if (length > 1) {
            name = this.setQualifiedNameNameAndSourceRanges(tokens, positions, importReference);
        } else {
            name = this.ast.newSimpleName(new String(tokens[0]));
            name.setSourceRange(start, end - start + 1);
        }
        packageDeclaration.setSourceRange(importReference.declarationSourceStart, importReference.declarationEnd - importReference.declarationSourceStart + 1);
        packageDeclaration.setName(name);
        if (this.resolveBindings) {
            this.recordNodes(packageDeclaration, importReference);
            this.recordNodes(name, compilationUnitDeclaration);
        }
        return packageDeclaration;
    }

    public ImportDeclaration convertImport(ImportReference importReference) {
        ImportDeclaration importDeclaration = this.ast.newImportDeclaration();
        boolean onDemand = importReference.onDemand;
        char[][] tokens = importReference.tokens;
        int length = importReference.tokens.length;
        long[] positions = importReference.sourcePositions;
        Name name = null;
        if (length > 1) {
            name = this.setQualifiedNameNameAndSourceRanges(tokens, positions, importReference);
        } else {
            name = this.ast.newSimpleName(new String(tokens[0]));
            int start = (int)(positions[0] >>> 32);
            int end = (int)(positions[0] & 0xFFFFFFFFFFFFFFFFL);
            name.setSourceRange(start, end - start + 1);
        }
        importDeclaration.setSourceRange(importReference.declarationSourceStart, importReference.declarationEnd - importReference.declarationSourceStart + 1);
        importDeclaration.setName(name);
        importDeclaration.setOnDemand(onDemand);
        if (this.resolveBindings) {
            this.recordNodes(importDeclaration, importReference);
        }
        return importDeclaration;
    }

    public TypeDeclaration convert(org.eclipse.jdt.internal.compiler.ast.TypeDeclaration typeDeclaration) {
        TypeReference[] superInterfaces;
        this.checkCanceled();
        TypeDeclaration typeDecl = this.ast.newTypeDeclaration();
        int modifiers = typeDeclaration.modifiers;
        modifiers &= 0xFFFFFDFF;
        typeDecl.setModifiers(modifiers &= 0xFFFF);
        typeDecl.setInterface(typeDeclaration.isInterface());
        SimpleName typeName = this.ast.newSimpleName(new String(typeDeclaration.name));
        typeName.setSourceRange(typeDeclaration.sourceStart, typeDeclaration.sourceEnd - typeDeclaration.sourceStart + 1);
        typeDecl.setName(typeName);
        typeDecl.setSourceRange(typeDeclaration.declarationSourceStart, typeDeclaration.bodyEnd - typeDeclaration.declarationSourceStart + 1);
        if (typeDeclaration.superclass != null) {
            typeDecl.setSuperclass(this.convert(typeDeclaration.superclass));
        }
        if ((superInterfaces = typeDeclaration.superInterfaces) != null) {
            int length = superInterfaces.length;
            for (int index = 0; index < length; ++index) {
                typeDecl.superInterfaces().add(this.convert(superInterfaces[index]));
            }
        }
        this.buildBodyDeclarations(typeDeclaration, typeDecl);
        if (this.resolveBindings) {
            this.recordNodes(typeDecl, typeDeclaration);
            this.recordNodes(typeName, typeDeclaration);
            typeDecl.resolveBinding();
        }
        return typeDecl;
    }

    private void buildBodyDeclarations(org.eclipse.jdt.internal.compiler.ast.TypeDeclaration typeDeclaration, TypeDeclaration typeDecl) {
        org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[] members = typeDeclaration.memberTypes;
        org.eclipse.jdt.internal.compiler.ast.FieldDeclaration[] fields = typeDeclaration.fields;
        AbstractMethodDeclaration[] methods = typeDeclaration.methods;
        int fieldsLength = fields == null ? 0 : fields.length;
        int methodsLength = methods == null ? 0 : methods.length;
        int membersLength = members == null ? 0 : members.length;
        int fieldsIndex = 0;
        int methodsIndex = 0;
        int membersIndex = 0;
        while (fieldsIndex < fieldsLength || membersIndex < membersLength || methodsIndex < methodsLength) {
            org.eclipse.jdt.internal.compiler.ast.FieldDeclaration nextFieldDeclaration = null;
            AbstractMethodDeclaration nextMethodDeclaration = null;
            org.eclipse.jdt.internal.compiler.ast.TypeDeclaration nextMemberDeclaration = null;
            int position = Integer.MAX_VALUE;
            int nextDeclarationType = -1;
            if (fieldsIndex < fieldsLength) {
                nextFieldDeclaration = fields[fieldsIndex];
                if (nextFieldDeclaration.declarationSourceStart < position) {
                    position = nextFieldDeclaration.declarationSourceStart;
                    nextDeclarationType = 0;
                }
            }
            if (methodsIndex < methodsLength) {
                nextMethodDeclaration = methods[methodsIndex];
                if (nextMethodDeclaration.declarationSourceStart < position) {
                    position = nextMethodDeclaration.declarationSourceStart;
                    nextDeclarationType = 1;
                }
            }
            if (membersIndex < membersLength) {
                nextMemberDeclaration = members[membersIndex];
                if (nextMemberDeclaration.declarationSourceStart < position) {
                    position = nextMemberDeclaration.declarationSourceStart;
                    nextDeclarationType = 2;
                }
            }
            switch (nextDeclarationType) {
                case 0: {
                    this.checkAndAddMultipleFieldDeclaration(fields, fieldsIndex, typeDecl.bodyDeclarations());
                    ++fieldsIndex;
                    break;
                }
                case 1: {
                    ++methodsIndex;
                    if (nextMethodDeclaration.isDefaultConstructor() || nextMethodDeclaration.isClinit()) break;
                    typeDecl.bodyDeclarations().add(this.convert(nextMethodDeclaration));
                    break;
                }
                case 2: {
                    ++membersIndex;
                    typeDecl.bodyDeclarations().add(this.convert(nextMemberDeclaration));
                }
            }
        }
        this.convert(typeDeclaration.javadoc, typeDecl);
    }

    private void checkAndAddMultipleFieldDeclaration(org.eclipse.jdt.internal.compiler.ast.FieldDeclaration[] fields, int index, List bodyDeclarations) {
        if (fields[index] instanceof org.eclipse.jdt.internal.compiler.ast.Initializer) {
            org.eclipse.jdt.internal.compiler.ast.Initializer oldInitializer = (org.eclipse.jdt.internal.compiler.ast.Initializer)fields[index];
            Initializer initializer = this.ast.newInitializer();
            initializer.setBody(this.convert(oldInitializer.block));
            initializer.setModifiers(oldInitializer.modifiers);
            initializer.setSourceRange(oldInitializer.declarationSourceStart, oldInitializer.sourceEnd - oldInitializer.declarationSourceStart + 1);
            this.convert(oldInitializer.javadoc, initializer);
            bodyDeclarations.add(initializer);
            return;
        }
        if (index > 0 && fields[index - 1].declarationSourceStart == fields[index].declarationSourceStart) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclarations.get(bodyDeclarations.size() - 1);
            fieldDeclaration.fragments().add(this.convertToVariableDeclarationFragment(fields[index]));
        } else {
            bodyDeclarations.add(this.convertToFieldDeclaration(fields[index]));
        }
    }

    private void checkAndAddMultipleLocalDeclaration(org.eclipse.jdt.internal.compiler.ast.Statement[] stmts, int index, List blockStatements) {
        if (index > 0 && stmts[index - 1] instanceof LocalDeclaration) {
            LocalDeclaration local1 = (LocalDeclaration)stmts[index - 1];
            LocalDeclaration local2 = (LocalDeclaration)stmts[index];
            if (local1.declarationSourceStart == local2.declarationSourceStart) {
                VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)blockStatements.get(blockStatements.size() - 1);
                variableDeclarationStatement.fragments().add(this.convertToVariableDeclarationFragment((LocalDeclaration)stmts[index]));
            } else {
                blockStatements.add(this.convertToVariableDeclarationStatement((LocalDeclaration)stmts[index]));
            }
        } else {
            blockStatements.add(this.convertToVariableDeclarationStatement((LocalDeclaration)stmts[index]));
        }
    }

    private void checkCanceled() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public Name convert(TypeReference typeReference) {
        char[][] typeName = typeReference.getTypeName();
        int length = typeName.length;
        Name name = null;
        if (length > 1) {
            QualifiedTypeReference qualifiedTypeReference = (QualifiedTypeReference)typeReference;
            long[] positions = qualifiedTypeReference.sourcePositions;
            name = this.setQualifiedNameNameAndSourceRanges(typeName, positions, typeReference);
        } else {
            name = this.ast.newSimpleName(new String(typeName[0]));
            name.setSourceRange(typeReference.sourceStart, typeReference.sourceEnd - typeReference.sourceStart + 1);
        }
        if (this.resolveBindings) {
            this.recordNodes(name, typeReference);
        }
        return name;
    }

    public SimpleName convert(SingleNameReference nameReference) {
        SimpleName name = this.ast.newSimpleName(new String(nameReference.token));
        if (this.resolveBindings) {
            this.recordNodes(name, nameReference);
        }
        name.setSourceRange(nameReference.sourceStart, nameReference.sourceEnd - nameReference.sourceStart + 1);
        return name;
    }

    public Name convert(QualifiedNameReference nameReference) {
        return this.setQualifiedNameNameAndSourceRanges(nameReference.tokens, nameReference.sourcePositions, nameReference);
    }

    private QualifiedName setQualifiedNameNameAndSourceRanges(char[][] typeName, long[] positions, org.eclipse.jdt.internal.compiler.ast.ASTNode node) {
        int start0;
        int length = typeName.length;
        SimpleName firstToken = this.ast.newSimpleName(new String(typeName[0]));
        firstToken.index = length - 1;
        int start = start0 = (int)(positions[0] >>> 32);
        int end = (int)(positions[0] & 0xFFFFFFFFFFFFFFFFL);
        firstToken.setSourceRange(start, end - start + 1);
        SimpleName secondToken = this.ast.newSimpleName(new String(typeName[1]));
        secondToken.index = length - 2;
        start = (int)(positions[1] >>> 32);
        end = (int)(positions[1] & 0xFFFFFFFFFFFFFFFFL);
        secondToken.setSourceRange(start, end - start + 1);
        QualifiedName qualifiedName = this.ast.newQualifiedName(firstToken, secondToken);
        if (this.resolveBindings) {
            this.recordNodes(qualifiedName, node);
            this.recordPendingNameScopeResolution(qualifiedName);
            this.recordNodes(firstToken, node);
            this.recordNodes(secondToken, node);
            this.recordPendingNameScopeResolution(firstToken);
            this.recordPendingNameScopeResolution(secondToken);
        }
        qualifiedName.index = length - 2;
        qualifiedName.setSourceRange(start0, end - start0 + 1);
        SimpleName newPart = null;
        for (int i = 2; i < length; ++i) {
            newPart = this.ast.newSimpleName(new String(typeName[i]));
            newPart.index = length - i - 1;
            start = (int)(positions[i] >>> 32);
            end = (int)(positions[i] & 0xFFFFFFFFFFFFFFFFL);
            newPart.setSourceRange(start, end - start + 1);
            qualifiedName = this.ast.newQualifiedName(qualifiedName, newPart);
            qualifiedName.index = newPart.index;
            qualifiedName.setSourceRange(start0, end - start0 + 1);
            if (!this.resolveBindings) continue;
            this.recordNodes(qualifiedName, node);
            this.recordNodes(newPart, node);
            this.recordPendingNameScopeResolution(qualifiedName);
            this.recordPendingNameScopeResolution(newPart);
        }
        QualifiedName name = qualifiedName;
        if (this.resolveBindings) {
            this.recordNodes(name, node);
            this.recordPendingNameScopeResolution(name);
        }
        return name;
    }

    public Expression convert(ThisReference reference) {
        if (reference.isImplicitThis()) {
            return null;
        }
        if (reference instanceof QualifiedSuperReference) {
            return this.convert((QualifiedSuperReference)reference);
        }
        if (reference instanceof QualifiedThisReference) {
            return this.convert((QualifiedThisReference)reference);
        }
        ThisExpression thisExpression = this.ast.newThisExpression();
        thisExpression.setSourceRange(reference.sourceStart, reference.sourceEnd - reference.sourceStart + 1);
        if (this.resolveBindings) {
            this.recordNodes(thisExpression, reference);
            this.recordPendingThisExpressionScopeResolution(thisExpression);
        }
        return thisExpression;
    }

    public ThisExpression convert(QualifiedThisReference reference) {
        ThisExpression thisExpression = this.ast.newThisExpression();
        thisExpression.setSourceRange(reference.sourceStart, reference.sourceEnd - reference.sourceStart + 1);
        thisExpression.setQualifier(this.convert(reference.qualification));
        if (this.resolveBindings) {
            this.recordNodes(thisExpression, reference);
            this.recordPendingThisExpressionScopeResolution(thisExpression);
        }
        return thisExpression;
    }

    public Name convert(QualifiedSuperReference reference) {
        return this.convert(reference.qualification);
    }

    public ArrayAccess convert(ArrayReference reference) {
        ArrayAccess arrayAccess = this.ast.newArrayAccess();
        if (this.resolveBindings) {
            this.recordNodes(arrayAccess, reference);
        }
        arrayAccess.setSourceRange(reference.sourceStart, reference.sourceEnd - reference.sourceStart + 1);
        arrayAccess.setArray(this.convert(reference.receiver));
        arrayAccess.setIndex(this.convert(reference.position));
        return arrayAccess;
    }

    public Expression convert(FieldReference reference) {
        if (reference.receiver.isSuper()) {
            SuperFieldAccess superFieldAccess = this.ast.newSuperFieldAccess();
            if (this.resolveBindings) {
                this.recordNodes(superFieldAccess, reference);
            }
            if (reference.receiver instanceof QualifiedSuperReference) {
                Name qualifier = this.convert((QualifiedSuperReference)reference.receiver);
                superFieldAccess.setQualifier(qualifier);
                if (this.resolveBindings) {
                    this.recordNodes(qualifier, reference.receiver);
                }
            }
            SimpleName simpleName = this.ast.newSimpleName(new String(reference.token));
            int sourceStart = (int)(reference.nameSourcePosition >>> 32);
            int length = (int)(reference.nameSourcePosition & 0xFFFFFFFFFFFFFFFFL) - sourceStart + 1;
            simpleName.setSourceRange(sourceStart, length);
            superFieldAccess.setName(simpleName);
            if (this.resolveBindings) {
                this.recordNodes(simpleName, reference);
            }
            superFieldAccess.setSourceRange(reference.receiver.sourceStart, reference.sourceEnd - reference.receiver.sourceStart + 1);
            return superFieldAccess;
        }
        FieldAccess fieldAccess = this.ast.newFieldAccess();
        if (this.resolveBindings) {
            this.recordNodes(fieldAccess, reference);
        }
        Expression receiver = this.convert(reference.receiver);
        fieldAccess.setExpression(receiver);
        SimpleName simpleName = this.ast.newSimpleName(new String(reference.token));
        int sourceStart = (int)(reference.nameSourcePosition >>> 32);
        int length = (int)(reference.nameSourcePosition & 0xFFFFFFFFFFFFFFFFL) - sourceStart + 1;
        simpleName.setSourceRange(sourceStart, length);
        fieldAccess.setName(simpleName);
        if (this.resolveBindings) {
            this.recordNodes(simpleName, reference);
        }
        fieldAccess.setSourceRange(receiver.getStartPosition(), reference.sourceEnd - receiver.getStartPosition() + 1);
        return fieldAccess;
    }

    public Expression convert(Reference reference) {
        if (reference instanceof NameReference) {
            return this.convert((NameReference)reference);
        }
        if (reference instanceof ThisReference) {
            return this.convert((ThisReference)reference);
        }
        if (reference instanceof ArrayReference) {
            return this.convert((ArrayReference)reference);
        }
        if (reference instanceof FieldReference) {
            return this.convert((FieldReference)reference);
        }
        throw new IllegalArgumentException("Not yet implemented: convert(" + reference.getClass() + ")");
    }

    public Name convert(NameReference reference) {
        if (reference instanceof QualifiedNameReference) {
            return this.convert((QualifiedNameReference)reference);
        }
        if (reference instanceof SingleNameReference) {
            return this.convert((SingleNameReference)reference);
        }
        throw new IllegalArgumentException("Not yet implemented: convert(" + reference.getClass() + ")");
    }

    private void completeRecord(ArrayType arrayType, org.eclipse.jdt.internal.compiler.ast.ASTNode astNode) {
        ArrayType array = arrayType;
        int dimensions = array.getDimensions();
        for (int i = 0; i < dimensions; ++i) {
            Type componentType = array.getComponentType();
            this.recordNodes(componentType, astNode);
            if (!componentType.isArrayType()) continue;
            array = (ArrayType)componentType;
        }
    }

    public Type convertType(TypeReference typeReference) {
        Type type = null;
        int sourceStart = -1;
        int length = 0;
        int dimensions = typeReference.dimensions();
        if (typeReference instanceof SingleTypeReference) {
            char[] name = ((SingleTypeReference)typeReference).getTypeName()[0];
            sourceStart = typeReference.sourceStart;
            length = typeReference.sourceEnd - typeReference.sourceStart + 1;
            if (dimensions != 0) {
                if (this.isPrimitiveType(name)) {
                    int end = this.retrieveEndOfElementTypeNamePosition(sourceStart, sourceStart + length);
                    if (end == -1) {
                        end = sourceStart + length - 1;
                    }
                    PrimitiveType primitiveType = this.ast.newPrimitiveType(this.getPrimitiveTypeCode(name));
                    primitiveType.setSourceRange(sourceStart, end - sourceStart + 1);
                    type = this.ast.newArrayType(primitiveType, dimensions);
                    if (this.resolveBindings) {
                        this.completeRecord((ArrayType)type, typeReference);
                    }
                    type.setSourceRange(sourceStart, length);
                } else {
                    SimpleName simpleName = this.ast.newSimpleName(new String(name));
                    int end = this.retrieveEndOfElementTypeNamePosition(sourceStart, sourceStart + length);
                    if (end == -1) {
                        end = sourceStart + length - 1;
                    }
                    simpleName.setSourceRange(sourceStart, end - sourceStart + 1);
                    SimpleType simpleType = this.ast.newSimpleType(simpleName);
                    simpleType.setSourceRange(sourceStart, end - sourceStart + 1);
                    type = this.ast.newArrayType(simpleType, dimensions);
                    type.setSourceRange(sourceStart, length);
                    if (this.resolveBindings) {
                        this.completeRecord((ArrayType)type, typeReference);
                        this.recordNodes(simpleName, typeReference);
                    }
                }
            } else if (this.isPrimitiveType(name)) {
                type = this.ast.newPrimitiveType(this.getPrimitiveTypeCode(name));
                type.setSourceRange(sourceStart, length);
            } else {
                SimpleName simpleName = this.ast.newSimpleName(new String(name));
                simpleName.setSourceRange(sourceStart, length);
                type = this.ast.newSimpleType(simpleName);
                type.setSourceRange(sourceStart, length);
                if (this.resolveBindings) {
                    this.recordNodes(simpleName, typeReference);
                }
            }
        } else {
            char[][] name = ((QualifiedTypeReference)typeReference).getTypeName();
            int nameLength = name.length;
            long[] positions = ((QualifiedTypeReference)typeReference).sourcePositions;
            sourceStart = (int)(positions[0] >>> 32);
            length = (int)(positions[nameLength - 1] & 0xFFFFFFFFFFFFFFFFL) - sourceStart + 1;
            QualifiedName qualifiedName = this.setQualifiedNameNameAndSourceRanges(name, positions, typeReference);
            if (dimensions != 0) {
                int end;
                SimpleType simpleType = this.ast.newSimpleType(qualifiedName);
                simpleType.setSourceRange(sourceStart, length);
                type = this.ast.newArrayType(simpleType, dimensions);
                if (this.resolveBindings) {
                    this.completeRecord((ArrayType)type, typeReference);
                }
                if ((end = this.retrieveEndOfDimensionsPosition(sourceStart + length, this.compilationUnitSource.length)) != -1) {
                    type.setSourceRange(sourceStart, end - sourceStart + 1);
                } else {
                    type.setSourceRange(sourceStart, length);
                }
            } else {
                type = this.ast.newSimpleType(qualifiedName);
                type.setSourceRange(sourceStart, length);
            }
        }
        if (this.resolveBindings) {
            this.recordNodes(type, typeReference);
        }
        return type;
    }

    public MethodDeclaration convert(AbstractMethodDeclaration methodDeclaration) {
        Argument[] parameters;
        this.checkCanceled();
        MethodDeclaration methodDecl = this.ast.newMethodDeclaration();
        methodDecl.setModifiers(methodDeclaration.modifiers & 0xFFFF);
        boolean isConstructor = methodDeclaration.isConstructor();
        methodDecl.setConstructor(isConstructor);
        SimpleName methodName = this.ast.newSimpleName(new String(methodDeclaration.selector));
        int start = methodDeclaration.sourceStart;
        int end = this.retrieveIdentifierEndPosition(start, methodDeclaration.sourceEnd);
        methodName.setSourceRange(start, end - start + 1);
        methodDecl.setName(methodName);
        TypeReference[] thrownExceptions = methodDeclaration.thrownExceptions;
        if (thrownExceptions != null) {
            int thrownExceptionsLength = thrownExceptions.length;
            for (int i = 0; i < thrownExceptionsLength; ++i) {
                methodDecl.thrownExceptions().add(this.convert(thrownExceptions[i]));
            }
        }
        if ((parameters = methodDeclaration.arguments) != null) {
            int parametersLength = parameters.length;
            for (int i = 0; i < parametersLength; ++i) {
                methodDecl.parameters().add(this.convert(parameters[i]));
            }
        }
        ExplicitConstructorCall explicitConstructorCall = null;
        if (isConstructor) {
            PrimitiveType returnType = this.ast.newPrimitiveType(PrimitiveType.VOID);
            returnType.setSourceRange(methodDeclaration.sourceStart, 0);
            methodDecl.setReturnType(returnType);
            ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)methodDeclaration;
            explicitConstructorCall = constructorDeclaration.constructorCall;
        } else {
            org.eclipse.jdt.internal.compiler.ast.MethodDeclaration method = (org.eclipse.jdt.internal.compiler.ast.MethodDeclaration)methodDeclaration;
            TypeReference typeReference = method.returnType;
            if (typeReference != null) {
                Type returnType = this.convertType(typeReference);
                int rightParenthesisPosition = this.retrieveEndOfRightParenthesisPosition(end, method.bodyEnd);
                int extraDimensions = this.retrieveExtraDimension(rightParenthesisPosition, method.bodyEnd);
                methodDecl.setExtraDimensions(extraDimensions);
                this.setTypeForMethodDeclaration(methodDecl, returnType, extraDimensions);
            }
        }
        int declarationSourceStart = methodDeclaration.declarationSourceStart;
        int declarationSourceEnd = methodDeclaration.bodyEnd;
        methodDecl.setSourceRange(declarationSourceStart, declarationSourceEnd - declarationSourceStart + 1);
        int closingPosition = this.retrieveRightBraceOrSemiColonPosition(methodDecl, methodDeclaration);
        if (closingPosition != -1) {
            int startPosition = methodDecl.getStartPosition();
            methodDecl.setSourceRange(startPosition, closingPosition - startPosition);
            org.eclipse.jdt.internal.compiler.ast.Statement[] statements = methodDeclaration.statements;
            start = this.retrieveStartBlockPosition(methodDeclaration.sourceStart, declarationSourceEnd);
            end = this.retrieveEndBlockPosition(methodDeclaration.sourceStart, methodDeclaration.declarationSourceEnd);
            Block block = null;
            if (start != -1 && end != -1) {
                block = this.ast.newBlock();
                block.setSourceRange(start, end - start + 1);
                methodDecl.setBody(block);
            }
            if (block != null && (statements != null || explicitConstructorCall != null)) {
                if (explicitConstructorCall != null && explicitConstructorCall.accessMode != 1) {
                    block.statements().add(this.convert(explicitConstructorCall));
                }
                int statementsLength = statements == null ? 0 : statements.length;
                for (int i = 0; i < statementsLength; ++i) {
                    if (statements[i] instanceof LocalDeclaration) {
                        this.checkAndAddMultipleLocalDeclaration(statements, i, block.statements());
                        continue;
                    }
                    block.statements().add(this.convert(statements[i]));
                }
            }
            if (block != null && (Modifier.isAbstract(methodDecl.getModifiers()) || Modifier.isNative(methodDecl.getModifiers()))) {
                methodDecl.setFlags(methodDecl.getFlags() | 1);
            }
        } else if (!methodDeclaration.isNative() && !methodDeclaration.isAbstract()) {
            start = this.retrieveStartBlockPosition(methodDeclaration.sourceStart, declarationSourceEnd);
            end = methodDeclaration.bodyEnd;
            IProblem[] problems = methodDeclaration.compilationResult().problems;
            if (problems != null) {
                int max = methodDeclaration.compilationResult().problemCount;
                for (int i = 0; i < max; ++i) {
                    IProblem currentProblem = problems[i];
                    if (currentProblem.getSourceStart() != start || currentProblem.getID() != 0x600000F0) continue;
                    end = currentProblem.getSourceEnd();
                    break;
                }
            }
            int startPosition = methodDecl.getStartPosition();
            methodDecl.setSourceRange(startPosition, end - startPosition + 1);
            if (start != -1 && end != -1) {
                Block block = this.ast.newBlock();
                block.setSourceRange(start, end - start + 1);
                methodDecl.setBody(block);
            }
        }
        this.convert(methodDeclaration.javadoc, methodDecl);
        if (this.resolveBindings) {
            this.recordNodes(methodDecl, methodDeclaration);
            this.recordNodes(methodName, methodDeclaration);
            methodDecl.resolveBinding();
        }
        return methodDecl;
    }

    public Expression convert(org.eclipse.jdt.internal.compiler.ast.Expression expression) {
        if ((expression.bits & 0x1FE00000) != 0) {
            return this.convertToParenthesizedExpression(expression);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.CastExpression) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.CastExpression)expression);
        }
        if (expression instanceof ArrayAllocationExpression) {
            return this.convert((ArrayAllocationExpression)expression);
        }
        if (expression instanceof QualifiedAllocationExpression) {
            return this.convert((QualifiedAllocationExpression)expression);
        }
        if (expression instanceof AllocationExpression) {
            return this.convert((AllocationExpression)expression);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.ArrayInitializer) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.ArrayInitializer)expression);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.PrefixExpression) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.PrefixExpression)expression);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.PostfixExpression) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.PostfixExpression)expression);
        }
        if (expression instanceof CompoundAssignment) {
            return this.convert((CompoundAssignment)expression);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.Assignment) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.Assignment)expression);
        }
        if (expression instanceof ClassLiteralAccess) {
            return this.convert((ClassLiteralAccess)expression);
        }
        if (expression instanceof FalseLiteral) {
            return this.convert((FalseLiteral)expression);
        }
        if (expression instanceof TrueLiteral) {
            return this.convert((TrueLiteral)expression);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.NullLiteral) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.NullLiteral)expression);
        }
        if (expression instanceof CharLiteral) {
            return this.convert((CharLiteral)expression);
        }
        if (expression instanceof DoubleLiteral) {
            return this.convert((DoubleLiteral)expression);
        }
        if (expression instanceof FloatLiteral) {
            return this.convert((FloatLiteral)expression);
        }
        if (expression instanceof IntLiteralMinValue) {
            return this.convert((IntLiteralMinValue)expression);
        }
        if (expression instanceof IntLiteral) {
            return this.convert((IntLiteral)expression);
        }
        if (expression instanceof LongLiteralMinValue) {
            return this.convert((LongLiteralMinValue)expression);
        }
        if (expression instanceof LongLiteral) {
            return this.convert((LongLiteral)expression);
        }
        if (expression instanceof StringLiteralConcatenation) {
            return this.convert((StringLiteralConcatenation)expression);
        }
        if (expression instanceof ExtendedStringLiteral) {
            return this.convert((ExtendedStringLiteral)expression);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.StringLiteral) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.StringLiteral)expression);
        }
        if (expression instanceof AND_AND_Expression) {
            return this.convert((AND_AND_Expression)expression);
        }
        if (expression instanceof OR_OR_Expression) {
            return this.convert((OR_OR_Expression)expression);
        }
        if (expression instanceof EqualExpression) {
            return this.convert((EqualExpression)expression);
        }
        if (expression instanceof BinaryExpression) {
            return this.convert((BinaryExpression)expression);
        }
        if (expression instanceof InstanceOfExpression) {
            return this.convert((InstanceOfExpression)expression);
        }
        if (expression instanceof UnaryExpression) {
            return this.convert((UnaryExpression)expression);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.ConditionalExpression) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.ConditionalExpression)expression);
        }
        if (expression instanceof MessageSend) {
            return this.convert((MessageSend)expression);
        }
        if (expression instanceof Reference) {
            return this.convert((Reference)expression);
        }
        if (expression instanceof TypeReference) {
            return this.convert((TypeReference)expression);
        }
        throw new IllegalArgumentException("Not yet implemented: convert(" + expression.getClass() + ")");
    }

    public ParenthesizedExpression convertToParenthesizedExpression(org.eclipse.jdt.internal.compiler.ast.Expression expression) {
        ParenthesizedExpression parenthesizedExpression = this.ast.newParenthesizedExpression();
        if (this.resolveBindings) {
            this.recordNodes(parenthesizedExpression, expression);
        }
        parenthesizedExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        this.adjustSourcePositionsForParent(expression);
        this.trimWhiteSpacesAndComments(expression);
        int numberOfParenthesis = (expression.bits & 0x1FE00000) >> 21;
        expression.bits &= 0xE01FFFFF;
        expression.bits |= numberOfParenthesis - 1 << 21;
        parenthesizedExpression.setExpression(this.convert(expression));
        return parenthesizedExpression;
    }

    public ClassInstanceCreation convert(AllocationExpression expression) {
        ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
        if (this.resolveBindings) {
            this.recordNodes(classInstanceCreation, expression);
        }
        classInstanceCreation.setName(this.convert(expression.type));
        classInstanceCreation.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.eclipse.jdt.internal.compiler.ast.Expression[] arguments = expression.arguments;
        if (arguments != null) {
            int length = arguments.length;
            for (int i = 0; i < length; ++i) {
                classInstanceCreation.arguments().add(this.convert(arguments[i]));
            }
        }
        this.removeTrailingCommentFromExpressionEndingWithAParen(classInstanceCreation);
        return classInstanceCreation;
    }

    private void buildBodyDeclarations(org.eclipse.jdt.internal.compiler.ast.TypeDeclaration expression, AnonymousClassDeclaration anonymousClassDeclaration) {
        org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[] members = expression.memberTypes;
        org.eclipse.jdt.internal.compiler.ast.FieldDeclaration[] fields = expression.fields;
        AbstractMethodDeclaration[] methods = expression.methods;
        int fieldsLength = fields == null ? 0 : fields.length;
        int methodsLength = methods == null ? 0 : methods.length;
        int membersLength = members == null ? 0 : members.length;
        int fieldsIndex = 0;
        int methodsIndex = 0;
        int membersIndex = 0;
        while (fieldsIndex < fieldsLength || membersIndex < membersLength || methodsIndex < methodsLength) {
            org.eclipse.jdt.internal.compiler.ast.FieldDeclaration nextFieldDeclaration = null;
            AbstractMethodDeclaration nextMethodDeclaration = null;
            org.eclipse.jdt.internal.compiler.ast.TypeDeclaration nextMemberDeclaration = null;
            int position = Integer.MAX_VALUE;
            int nextDeclarationType = -1;
            if (fieldsIndex < fieldsLength) {
                nextFieldDeclaration = fields[fieldsIndex];
                if (nextFieldDeclaration.declarationSourceStart < position) {
                    position = nextFieldDeclaration.declarationSourceStart;
                    nextDeclarationType = 0;
                }
            }
            if (methodsIndex < methodsLength) {
                nextMethodDeclaration = methods[methodsIndex];
                if (nextMethodDeclaration.declarationSourceStart < position) {
                    position = nextMethodDeclaration.declarationSourceStart;
                    nextDeclarationType = 1;
                }
            }
            if (membersIndex < membersLength) {
                nextMemberDeclaration = members[membersIndex];
                if (nextMemberDeclaration.declarationSourceStart < position) {
                    position = nextMemberDeclaration.declarationSourceStart;
                    nextDeclarationType = 2;
                }
            }
            switch (nextDeclarationType) {
                case 0: {
                    this.checkAndAddMultipleFieldDeclaration(fields, fieldsIndex, anonymousClassDeclaration.bodyDeclarations());
                    ++fieldsIndex;
                    break;
                }
                case 1: {
                    ++methodsIndex;
                    if (nextMethodDeclaration.isDefaultConstructor() || nextMethodDeclaration.isClinit()) break;
                    anonymousClassDeclaration.bodyDeclarations().add(this.convert(nextMethodDeclaration));
                    break;
                }
                case 2: {
                    ++membersIndex;
                    anonymousClassDeclaration.bodyDeclarations().add(this.convert(nextMemberDeclaration));
                }
            }
        }
    }

    public ArrayCreation convert(ArrayAllocationExpression expression) {
        ArrayCreation arrayCreation = this.ast.newArrayCreation();
        if (this.resolveBindings) {
            this.recordNodes(arrayCreation, expression);
        }
        arrayCreation.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.eclipse.jdt.internal.compiler.ast.Expression[] dimensions = expression.dimensions;
        int dimensionsLength = dimensions.length;
        for (int i = 0; i < dimensionsLength; ++i) {
            if (dimensions[i] == null) continue;
            Expression dimension = this.convert(dimensions[i]);
            if (this.resolveBindings) {
                this.recordNodes(dimension, dimensions[i]);
            }
            arrayCreation.dimensions().add(dimension);
        }
        Type type = this.convertType(expression.type);
        if (this.resolveBindings) {
            this.recordNodes(type, expression.type);
        }
        ArrayType arrayType = null;
        if (type.isArrayType()) {
            arrayType = (ArrayType)type;
        } else {
            int end;
            arrayType = this.ast.newArrayType(type, dimensionsLength);
            if (this.resolveBindings) {
                this.completeRecord(arrayType, expression);
            }
            int start = type.getStartPosition();
            int previousSearchStart = end = type.getStartPosition() + type.getLength();
            ArrayType componentType = (ArrayType)type.getParent();
            for (int i = 0; i < dimensionsLength; ++i) {
                previousSearchStart = this.retrieveRightBracketPosition(previousSearchStart + 1, this.compilationUnitSource.length);
                componentType.setSourceRange(start, previousSearchStart - start + 1);
                componentType = (ArrayType)componentType.getParent();
            }
        }
        arrayCreation.setType(arrayType);
        if (this.resolveBindings) {
            this.recordNodes(arrayType, expression);
        }
        if (expression.initializer != null) {
            arrayCreation.setInitializer(this.convert(expression.initializer));
        }
        return arrayCreation;
    }

    public SingleVariableDeclaration convert(Argument argument) {
        SingleVariableDeclaration variableDecl = this.ast.newSingleVariableDeclaration();
        variableDecl.setModifiers(argument.modifiers);
        SimpleName name = this.ast.newSimpleName(new String(argument.name));
        int start = argument.sourceStart;
        int nameEnd = argument.sourceEnd;
        name.setSourceRange(start, nameEnd - start + 1);
        variableDecl.setName(name);
        int extraDimensions = this.retrieveExtraDimension(nameEnd + 1, argument.type.sourceEnd);
        variableDecl.setExtraDimensions(extraDimensions);
        Type type = this.convertType(argument.type);
        int typeEnd = type.getStartPosition() + type.getLength() - 1;
        int rightEnd = Math.max(typeEnd, argument.declarationSourceEnd);
        this.setTypeForSingleVariableDeclaration(variableDecl, type, extraDimensions);
        variableDecl.setSourceRange(argument.declarationSourceStart, rightEnd - argument.declarationSourceStart + 1);
        if (this.resolveBindings) {
            this.recordNodes(name, argument);
            this.recordNodes(variableDecl, argument);
            variableDecl.resolveBinding();
        }
        return variableDecl;
    }

    public ArrayInitializer convert(org.eclipse.jdt.internal.compiler.ast.ArrayInitializer expression) {
        ArrayInitializer arrayInitializer = this.ast.newArrayInitializer();
        if (this.resolveBindings) {
            this.recordNodes(arrayInitializer, expression);
        }
        arrayInitializer.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.eclipse.jdt.internal.compiler.ast.Expression[] expressions = expression.expressions;
        if (expressions != null) {
            int length = expressions.length;
            for (int i = 0; i < length; ++i) {
                Expression expr = this.convert(expressions[i]);
                if (this.resolveBindings) {
                    this.recordNodes(expr, expressions[i]);
                }
                arrayInitializer.expressions().add(expr);
            }
        }
        return arrayInitializer;
    }

    public Expression convert(QualifiedAllocationExpression allocation) {
        if (allocation.anonymousType != null) {
            ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
            classInstanceCreation.setName(this.convert(allocation.type));
            if (allocation.enclosingInstance != null) {
                classInstanceCreation.setExpression(this.convert(allocation.enclosingInstance));
            }
            int declarationSourceStart = allocation.sourceStart;
            classInstanceCreation.setSourceRange(declarationSourceStart, allocation.anonymousType.bodyEnd - declarationSourceStart + 1);
            org.eclipse.jdt.internal.compiler.ast.Expression[] arguments = allocation.arguments;
            if (arguments != null) {
                int length = arguments.length;
                for (int i = 0; i < length; ++i) {
                    classInstanceCreation.arguments().add(this.convert(arguments[i]));
                }
            }
            AnonymousClassDeclaration anonymousClassDeclaration = this.ast.newAnonymousClassDeclaration();
            int start = this.retrieveStartBlockPosition(allocation.anonymousType.sourceEnd, allocation.anonymousType.bodyEnd);
            anonymousClassDeclaration.setSourceRange(start, allocation.anonymousType.bodyEnd - start + 1);
            classInstanceCreation.setAnonymousClassDeclaration(anonymousClassDeclaration);
            this.buildBodyDeclarations(allocation.anonymousType, anonymousClassDeclaration);
            if (this.resolveBindings) {
                this.recordNodes(classInstanceCreation, allocation.anonymousType);
                this.recordNodes(anonymousClassDeclaration, allocation.anonymousType);
                anonymousClassDeclaration.resolveBinding();
            }
            return classInstanceCreation;
        }
        ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
        classInstanceCreation.setExpression(this.convert(allocation.enclosingInstance));
        classInstanceCreation.setName(this.convert(allocation.type));
        classInstanceCreation.setSourceRange(allocation.sourceStart, allocation.sourceEnd - allocation.sourceStart + 1);
        org.eclipse.jdt.internal.compiler.ast.Expression[] arguments = allocation.arguments;
        if (arguments != null) {
            int length = arguments.length;
            for (int i = 0; i < length; ++i) {
                Expression argument = this.convert(arguments[i]);
                if (this.resolveBindings) {
                    this.recordNodes(argument, arguments[i]);
                }
                classInstanceCreation.arguments().add(argument);
            }
        }
        if (this.resolveBindings) {
            this.recordNodes(classInstanceCreation, allocation);
        }
        this.removeTrailingCommentFromExpressionEndingWithAParen(classInstanceCreation);
        return classInstanceCreation;
    }

    public Assignment convert(org.eclipse.jdt.internal.compiler.ast.Assignment expression) {
        Assignment assignment = this.ast.newAssignment();
        if (this.resolveBindings) {
            this.recordNodes(assignment, expression);
        }
        Expression lhs = this.convert(expression.lhs);
        assignment.setLeftHandSide(lhs);
        assignment.setOperator(Assignment.Operator.ASSIGN);
        assignment.setRightHandSide(this.convert(expression.expression));
        int start = lhs.getStartPosition();
        assignment.setSourceRange(start, expression.sourceEnd - start + 1);
        return assignment;
    }

    public Assignment convert(CompoundAssignment expression) {
        Assignment assignment = this.ast.newAssignment();
        Expression lhs = this.convert(expression.lhs);
        assignment.setLeftHandSide(lhs);
        int start = lhs.getStartPosition();
        assignment.setSourceRange(start, expression.sourceEnd - start + 1);
        switch (expression.operator) {
            case 14: {
                assignment.setOperator(Assignment.Operator.PLUS_ASSIGN);
                break;
            }
            case 13: {
                assignment.setOperator(Assignment.Operator.MINUS_ASSIGN);
                break;
            }
            case 15: {
                assignment.setOperator(Assignment.Operator.TIMES_ASSIGN);
                break;
            }
            case 9: {
                assignment.setOperator(Assignment.Operator.DIVIDE_ASSIGN);
                break;
            }
            case 2: {
                assignment.setOperator(Assignment.Operator.BIT_AND_ASSIGN);
                break;
            }
            case 3: {
                assignment.setOperator(Assignment.Operator.BIT_OR_ASSIGN);
                break;
            }
            case 8: {
                assignment.setOperator(Assignment.Operator.BIT_XOR_ASSIGN);
                break;
            }
            case 16: {
                assignment.setOperator(Assignment.Operator.REMAINDER_ASSIGN);
                break;
            }
            case 10: {
                assignment.setOperator(Assignment.Operator.LEFT_SHIFT_ASSIGN);
                break;
            }
            case 17: {
                assignment.setOperator(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN);
                break;
            }
            case 19: {
                assignment.setOperator(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN);
            }
        }
        assignment.setRightHandSide(this.convert(expression.expression));
        return assignment;
    }

    public PrefixExpression convert(org.eclipse.jdt.internal.compiler.ast.PrefixExpression expression) {
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        if (this.resolveBindings) {
            this.recordNodes(prefixExpression, expression);
        }
        prefixExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        prefixExpression.setOperand(this.convert(expression.lhs));
        switch (expression.operator) {
            case 14: {
                prefixExpression.setOperator(PrefixExpression.Operator.INCREMENT);
                break;
            }
            case 13: {
                prefixExpression.setOperator(PrefixExpression.Operator.DECREMENT);
            }
        }
        return prefixExpression;
    }

    public PostfixExpression convert(org.eclipse.jdt.internal.compiler.ast.PostfixExpression expression) {
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        if (this.resolveBindings) {
            this.recordNodes(postfixExpression, expression);
        }
        postfixExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        postfixExpression.setOperand(this.convert(expression.lhs));
        switch (expression.operator) {
            case 14: {
                postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
                break;
            }
            case 13: {
                postfixExpression.setOperator(PostfixExpression.Operator.DECREMENT);
            }
        }
        return postfixExpression;
    }

    public CastExpression convert(org.eclipse.jdt.internal.compiler.ast.CastExpression expression) {
        CastExpression castExpression = this.ast.newCastExpression();
        castExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.eclipse.jdt.internal.compiler.ast.Expression type = expression.type;
        this.trimWhiteSpacesAndComments(type);
        if (type instanceof TypeReference) {
            castExpression.setType(this.convertType((TypeReference)type));
        } else if (type instanceof NameReference) {
            castExpression.setType(this.convertToType((NameReference)type));
        }
        castExpression.setExpression(this.convert(expression.expression));
        if (this.resolveBindings) {
            this.recordNodes(castExpression, expression);
        }
        return castExpression;
    }

    public Type convertToType(NameReference reference) {
        Name name = this.convert(reference);
        SimpleType type = this.ast.newSimpleType(name);
        type.setSourceRange(name.getStartPosition(), name.getLength());
        if (this.resolveBindings) {
            this.recordNodes(type, reference);
        }
        return type;
    }

    public Expression convert(ClassLiteralAccess expression) {
        TypeLiteral typeLiteral = this.ast.newTypeLiteral();
        if (this.resolveBindings) {
            this.recordNodes(typeLiteral, expression);
        }
        typeLiteral.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        typeLiteral.setType(this.convertType(expression.type));
        return typeLiteral;
    }

    public BooleanLiteral convert(FalseLiteral expression) {
        BooleanLiteral literal = this.ast.newBooleanLiteral(false);
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public BooleanLiteral convert(TrueLiteral expression) {
        BooleanLiteral literal = this.ast.newBooleanLiteral(true);
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public InfixExpression convert(StringLiteralConcatenation expression) {
        expression.computeConstant();
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        org.eclipse.jdt.internal.compiler.ast.StringLiteral[] stringLiterals = expression.literals;
        infixExpression.setLeftOperand(this.convert(stringLiterals[0]));
        infixExpression.setRightOperand(this.convert(stringLiterals[1]));
        for (int i = 2; i < expression.counter; ++i) {
            infixExpression.extendedOperands().add(this.convert(stringLiterals[i]));
        }
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        infixExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return infixExpression;
    }

    public NullLiteral convert(org.eclipse.jdt.internal.compiler.ast.NullLiteral expression) {
        NullLiteral literal = this.ast.newNullLiteral();
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public CharacterLiteral convert(CharLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        CharacterLiteral literal = this.ast.newCharacterLiteral();
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setEscapedValue(new String(tokens));
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public NumberLiteral convert(DoubleLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public NumberLiteral convert(FloatLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public NumberLiteral convert(IntLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public NumberLiteral convert(IntLiteralMinValue expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public NumberLiteral convert(LongLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public NumberLiteral convert(LongLiteralMinValue expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public StringLiteral convert(org.eclipse.jdt.internal.compiler.ast.StringLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        StringLiteral literal = this.ast.newStringLiteral();
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setEscapedValue(new String(tokens));
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public StringLiteral convert(ExtendedStringLiteral expression) {
        expression.computeConstant();
        StringLiteral literal = this.ast.newStringLiteral();
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setLiteralValue(expression.constant.stringValue());
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public Expression convert(BinaryExpression expression) {
        InfixExpression infixExpression = this.ast.newInfixExpression();
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        int expressionOperatorID = (expression.bits & 0xFC0) >> 6;
        switch (expressionOperatorID) {
            case 18: {
                infixExpression.setOperator(InfixExpression.Operator.EQUALS);
                break;
            }
            case 5: {
                infixExpression.setOperator(InfixExpression.Operator.LESS_EQUALS);
                break;
            }
            case 7: {
                infixExpression.setOperator(InfixExpression.Operator.GREATER_EQUALS);
                break;
            }
            case 29: {
                infixExpression.setOperator(InfixExpression.Operator.NOT_EQUALS);
                break;
            }
            case 10: {
                infixExpression.setOperator(InfixExpression.Operator.LEFT_SHIFT);
                break;
            }
            case 17: {
                infixExpression.setOperator(InfixExpression.Operator.RIGHT_SHIFT_SIGNED);
                break;
            }
            case 19: {
                infixExpression.setOperator(InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED);
                break;
            }
            case 1: {
                infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_OR);
                break;
            }
            case 0: {
                infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_AND);
                break;
            }
            case 14: {
                infixExpression.setOperator(InfixExpression.Operator.PLUS);
                break;
            }
            case 13: {
                infixExpression.setOperator(InfixExpression.Operator.MINUS);
                break;
            }
            case 16: {
                infixExpression.setOperator(InfixExpression.Operator.REMAINDER);
                break;
            }
            case 8: {
                infixExpression.setOperator(InfixExpression.Operator.XOR);
                break;
            }
            case 2: {
                infixExpression.setOperator(InfixExpression.Operator.AND);
                break;
            }
            case 15: {
                infixExpression.setOperator(InfixExpression.Operator.TIMES);
                break;
            }
            case 3: {
                infixExpression.setOperator(InfixExpression.Operator.OR);
                break;
            }
            case 9: {
                infixExpression.setOperator(InfixExpression.Operator.DIVIDE);
                break;
            }
            case 6: {
                infixExpression.setOperator(InfixExpression.Operator.GREATER);
                break;
            }
            case 4: {
                infixExpression.setOperator(InfixExpression.Operator.LESS);
            }
        }
        if (expression.left instanceof BinaryExpression && (expression.left.bits & 0x1FE00000) == 0) {
            infixExpression.extendedOperands().add(this.convert(expression.right));
            org.eclipse.jdt.internal.compiler.ast.Expression leftOperand = expression.left;
            org.eclipse.jdt.internal.compiler.ast.Expression rightOperand = null;
            do {
                rightOperand = ((BinaryExpression)leftOperand).right;
                if ((leftOperand.bits & 0xFC0) >> 6 != expressionOperatorID && (leftOperand.bits & 0x1FE00000) == 0 || rightOperand instanceof BinaryExpression && (rightOperand.bits & 0xFC0) >> 6 != expressionOperatorID && (rightOperand.bits & 0x1FE00000) == 0) {
                    int i;
                    List extendedOperands = infixExpression.extendedOperands();
                    InfixExpression temp = this.ast.newInfixExpression();
                    if (this.resolveBindings) {
                        this.recordNodes(temp, expression);
                    }
                    temp.setOperator(this.getOperatorFor(expressionOperatorID));
                    Expression leftSide = this.convert(leftOperand);
                    temp.setLeftOperand(leftSide);
                    temp.setSourceRange(leftSide.getStartPosition(), leftSide.getLength());
                    int size = extendedOperands.size();
                    for (i = 0; i < size - 1; ++i) {
                        InfixExpression expr = temp;
                        temp = this.ast.newInfixExpression();
                        if (this.resolveBindings) {
                            this.recordNodes(temp, expression);
                        }
                        temp.setLeftOperand(expr);
                        temp.setOperator(this.getOperatorFor(expressionOperatorID));
                        temp.setSourceRange(expr.getStartPosition(), expr.getLength());
                    }
                    infixExpression = temp;
                    for (i = 0; i < size; ++i) {
                        Expression extendedOperand = (Expression)extendedOperands.remove(size - 1 - i);
                        temp.setRightOperand(extendedOperand);
                        int startPosition = temp.getLeftOperand().getStartPosition();
                        temp.setSourceRange(startPosition, extendedOperand.getStartPosition() + extendedOperand.getLength() - startPosition);
                        if (temp.getLeftOperand().getNodeType() != 27) continue;
                        temp = (InfixExpression)temp.getLeftOperand();
                    }
                    int startPosition = infixExpression.getLeftOperand().getStartPosition();
                    infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
                    if (this.resolveBindings) {
                        this.recordNodes(infixExpression, expression);
                    }
                    return infixExpression;
                }
                infixExpression.extendedOperands().add(0, this.convert(rightOperand));
            } while ((leftOperand = ((BinaryExpression)leftOperand).left) instanceof BinaryExpression && (leftOperand.bits & 0x1FE00000) == 0);
            Expression leftExpression = this.convert(leftOperand);
            infixExpression.setLeftOperand(leftExpression);
            infixExpression.setRightOperand((Expression)infixExpression.extendedOperands().remove(0));
            int startPosition = leftExpression.getStartPosition();
            infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
            return infixExpression;
        }
        if (expression.left instanceof StringLiteralConcatenation && (expression.left.bits & 0x1FE00000) == 0) {
            StringLiteralConcatenation literal = (StringLiteralConcatenation)expression.left;
            org.eclipse.jdt.internal.compiler.ast.StringLiteral[] stringLiterals = literal.literals;
            infixExpression.setLeftOperand(this.convert(stringLiterals[0]));
            infixExpression.setRightOperand(this.convert(stringLiterals[1]));
            for (int i = 2; i < literal.counter; ++i) {
                infixExpression.extendedOperands().add(this.convert(stringLiterals[i]));
            }
            infixExpression.extendedOperands().add(this.convert(expression.right));
            int startPosition = literal.sourceStart;
            infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
            return infixExpression;
        }
        Expression leftExpression = this.convert(expression.left);
        infixExpression.setLeftOperand(leftExpression);
        infixExpression.setRightOperand(this.convert(expression.right));
        int startPosition = leftExpression.getStartPosition();
        infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
        return infixExpression;
    }

    public PrefixExpression convert(UnaryExpression expression) {
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        if (this.resolveBindings) {
            this.recordNodes(prefixExpression, expression);
        }
        prefixExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        prefixExpression.setOperand(this.convert(expression.expression));
        switch ((expression.bits & 0xFC0) >> 6) {
            case 14: {
                prefixExpression.setOperator(PrefixExpression.Operator.PLUS);
                break;
            }
            case 13: {
                prefixExpression.setOperator(PrefixExpression.Operator.MINUS);
                break;
            }
            case 11: {
                prefixExpression.setOperator(PrefixExpression.Operator.NOT);
                break;
            }
            case 12: {
                prefixExpression.setOperator(PrefixExpression.Operator.COMPLEMENT);
            }
        }
        return prefixExpression;
    }

    public InstanceofExpression convert(InstanceOfExpression expression) {
        InstanceofExpression instanceOfExpression = this.ast.newInstanceofExpression();
        if (this.resolveBindings) {
            this.recordNodes(instanceOfExpression, expression);
        }
        Expression leftExpression = this.convert(expression.expression);
        instanceOfExpression.setLeftOperand(leftExpression);
        instanceOfExpression.setRightOperand(this.convertType(expression.type));
        int startPosition = leftExpression.getStartPosition();
        instanceOfExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
        return instanceOfExpression;
    }

    public ConditionalExpression convert(org.eclipse.jdt.internal.compiler.ast.ConditionalExpression expression) {
        ConditionalExpression conditionalExpression = this.ast.newConditionalExpression();
        if (this.resolveBindings) {
            this.recordNodes(conditionalExpression, expression);
        }
        conditionalExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        conditionalExpression.setExpression(this.convert(expression.condition));
        conditionalExpression.setThenExpression(this.convert(expression.valueIfTrue));
        conditionalExpression.setElseExpression(this.convert(expression.valueIfFalse));
        return conditionalExpression;
    }

    public Expression convert(MessageSend expression) {
        Expression expr;
        int sourceStart = expression.sourceStart;
        if (expression.isSuperAccess()) {
            org.eclipse.jdt.internal.compiler.ast.Expression[] arguments;
            SuperMethodInvocation superMethodInvocation = this.ast.newSuperMethodInvocation();
            if (this.resolveBindings) {
                this.recordNodes(superMethodInvocation, expression);
            }
            SimpleName name = this.ast.newSimpleName(new String(expression.selector));
            int nameSourceStart = (int)(expression.nameSourcePosition >>> 32);
            int nameSourceLength = (int)(expression.nameSourcePosition & 0xFFFFFFFFFFFFFFFFL) - nameSourceStart + 1;
            name.setSourceRange(nameSourceStart, nameSourceLength);
            if (this.resolveBindings) {
                this.recordNodes(name, expression);
            }
            superMethodInvocation.setName(name);
            if (expression.receiver instanceof QualifiedSuperReference) {
                Name qualifier = this.convert((QualifiedSuperReference)expression.receiver);
                superMethodInvocation.setQualifier(qualifier);
                if (this.resolveBindings) {
                    this.recordNodes(qualifier, expression.receiver);
                }
                if (qualifier != null) {
                    sourceStart = qualifier.getStartPosition();
                }
            }
            if ((arguments = expression.arguments) != null) {
                int argumentsLength = arguments.length;
                for (int i = 0; i < argumentsLength; ++i) {
                    Expression expri = this.convert(arguments[i]);
                    if (this.resolveBindings) {
                        this.recordNodes(expri, arguments[i]);
                    }
                    superMethodInvocation.arguments().add(expri);
                }
            }
            expr = superMethodInvocation;
        } else {
            org.eclipse.jdt.internal.compiler.ast.Expression[] arguments;
            MethodInvocation methodInvocation = this.ast.newMethodInvocation();
            if (this.resolveBindings) {
                this.recordNodes(methodInvocation, expression);
            }
            SimpleName name = this.ast.newSimpleName(new String(expression.selector));
            int nameSourceStart = (int)(expression.nameSourcePosition >>> 32);
            int nameSourceLength = (int)(expression.nameSourcePosition & 0xFFFFFFFFFFFFFFFFL) - nameSourceStart + 1;
            name.setSourceRange(nameSourceStart, nameSourceLength);
            methodInvocation.setName(name);
            if (this.resolveBindings) {
                this.recordNodes(name, expression);
            }
            if ((arguments = expression.arguments) != null) {
                int argumentsLength = arguments.length;
                for (int i = 0; i < argumentsLength; ++i) {
                    Expression expri = this.convert(arguments[i]);
                    if (this.resolveBindings) {
                        this.recordNodes(expri, arguments[i]);
                    }
                    methodInvocation.arguments().add(expri);
                }
            }
            Expression qualifier = null;
            org.eclipse.jdt.internal.compiler.ast.Expression receiver = expression.receiver;
            qualifier = receiver instanceof MessageSend ? ((receiver.bits & 0x1FE00000) != 0 ? this.convertToParenthesizedExpression(receiver) : this.convert((MessageSend)receiver)) : this.convert(receiver);
            if (qualifier instanceof Name && this.resolveBindings) {
                this.recordNodes(qualifier, receiver);
            }
            methodInvocation.setExpression(qualifier);
            if (qualifier != null) {
                sourceStart = qualifier.getStartPosition();
            }
            expr = methodInvocation;
        }
        expr.setSourceRange(sourceStart, expression.sourceEnd - sourceStart + 1);
        this.removeTrailingCommentFromExpressionEndingWithAParen(expr);
        return expr;
    }

    public Expression convert(AND_AND_Expression expression) {
        InfixExpression infixExpression = this.ast.newInfixExpression();
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        Expression leftExpression = this.convert(expression.left);
        infixExpression.setLeftOperand(leftExpression);
        infixExpression.setRightOperand(this.convert(expression.right));
        infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_AND);
        int startPosition = leftExpression.getStartPosition();
        infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
        return infixExpression;
    }

    public Expression convert(EqualExpression expression) {
        InfixExpression infixExpression = this.ast.newInfixExpression();
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        Expression leftExpression = this.convert(expression.left);
        infixExpression.setLeftOperand(leftExpression);
        infixExpression.setRightOperand(this.convert(expression.right));
        int startPosition = leftExpression.getStartPosition();
        infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
        switch ((expression.bits & 0xFC0) >> 6) {
            case 18: {
                infixExpression.setOperator(InfixExpression.Operator.EQUALS);
                break;
            }
            case 29: {
                infixExpression.setOperator(InfixExpression.Operator.NOT_EQUALS);
            }
        }
        return infixExpression;
    }

    public Expression convert(OR_OR_Expression expression) {
        InfixExpression infixExpression = this.ast.newInfixExpression();
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        Expression leftExpression = this.convert(expression.left);
        infixExpression.setLeftOperand(leftExpression);
        infixExpression.setRightOperand(this.convert(expression.right));
        infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_OR);
        int sourceStart = leftExpression.getStartPosition();
        infixExpression.setSourceRange(sourceStart, expression.sourceEnd - sourceStart + 1);
        return infixExpression;
    }

    public Statement convert(org.eclipse.jdt.internal.compiler.ast.Statement statement) {
        if (statement instanceof LocalDeclaration) {
            return this.convertToVariableDeclarationStatement((LocalDeclaration)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.AssertStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.AssertStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.Block) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.Block)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.BreakStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.BreakStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.ContinueStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.ContinueStatement)statement);
        }
        if (statement instanceof CaseStatement) {
            return this.convert((CaseStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.DoStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.DoStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.EmptyStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.EmptyStatement)statement);
        }
        if (statement instanceof ExplicitConstructorCall) {
            return this.convert((ExplicitConstructorCall)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.ForStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.ForStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.IfStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.IfStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.LabeledStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.LabeledStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.ReturnStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.ReturnStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.SwitchStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.SwitchStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.ThrowStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.ThrowStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.TryStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.TryStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.TypeDeclaration && (statement.bits & 0x100) != 0) {
            TypeDeclarationStatement typeDeclarationStatement = this.ast.newTypeDeclarationStatement(this.convert((org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)statement));
            TypeDeclaration typeDecl = typeDeclarationStatement.getTypeDeclaration();
            typeDeclarationStatement.setSourceRange(typeDecl.getStartPosition(), typeDecl.getLength());
            return typeDeclarationStatement;
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.TypeDeclaration) {
            TypeDeclarationStatement typeDeclarationStatement = this.ast.newTypeDeclarationStatement(this.convert((org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)statement));
            TypeDeclaration typeDecl = typeDeclarationStatement.getTypeDeclaration();
            typeDeclarationStatement.setSourceRange(typeDecl.getStartPosition(), typeDecl.getLength());
            return typeDeclarationStatement;
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.WhileStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.WhileStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.Expression) {
            Expression expr = this.convert((org.eclipse.jdt.internal.compiler.ast.Expression)statement);
            ExpressionStatement stmt = this.ast.newExpressionStatement(expr);
            stmt.setSourceRange(expr.getStartPosition(), expr.getLength());
            this.retrieveSemiColonPosition(stmt);
            return stmt;
        }
        throw new IllegalArgumentException("Not yet implemented: convert(" + statement.getClass() + ")");
    }

    public AssertStatement convert(org.eclipse.jdt.internal.compiler.ast.AssertStatement statement) {
        AssertStatement assertStatement = this.ast.newAssertStatement();
        int end = statement.assertExpression.sourceEnd + 1;
        assertStatement.setExpression(this.convert(statement.assertExpression));
        org.eclipse.jdt.internal.compiler.ast.Expression exceptionArgument = statement.exceptionArgument;
        if (exceptionArgument != null) {
            assertStatement.setMessage(this.convert(exceptionArgument));
            end = exceptionArgument.sourceEnd + 1;
        }
        int start = statement.sourceStart;
        int sourceEnd = this.retrieveEndingSemiColonPosition(end, this.compilationUnitSource.length);
        assertStatement.setSourceRange(start, sourceEnd - start + 1);
        return assertStatement;
    }

    public Block convert(org.eclipse.jdt.internal.compiler.ast.Block statement) {
        org.eclipse.jdt.internal.compiler.ast.Statement[] statements;
        Block block = this.ast.newBlock();
        if (statement.sourceEnd > 0) {
            block.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        }
        if ((statements = statement.statements) != null) {
            int statementsLength = statements.length;
            for (int i = 0; i < statementsLength; ++i) {
                if (statements[i] instanceof LocalDeclaration) {
                    this.checkAndAddMultipleLocalDeclaration(statements, i, block.statements());
                    continue;
                }
                block.statements().add(this.convert(statements[i]));
            }
        }
        return block;
    }

    public BreakStatement convert(org.eclipse.jdt.internal.compiler.ast.BreakStatement statement) {
        BreakStatement breakStatement = this.ast.newBreakStatement();
        breakStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        if (statement.label != null) {
            SimpleName name = this.ast.newSimpleName(new String(statement.label));
            this.retrieveIdentifierAndSetPositions(statement.sourceStart, statement.sourceEnd, name);
            breakStatement.setLabel(name);
        }
        this.retrieveSemiColonPosition(breakStatement);
        return breakStatement;
    }

    public ContinueStatement convert(org.eclipse.jdt.internal.compiler.ast.ContinueStatement statement) {
        ContinueStatement continueStatement = this.ast.newContinueStatement();
        continueStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        if (statement.label != null) {
            SimpleName name = this.ast.newSimpleName(new String(statement.label));
            this.retrieveIdentifierAndSetPositions(statement.sourceStart, statement.sourceEnd, name);
            continueStatement.setLabel(name);
        }
        this.retrieveSemiColonPosition(continueStatement);
        return continueStatement;
    }

    public SwitchCase convert(CaseStatement statement) {
        SwitchCase switchCase = this.ast.newSwitchCase();
        org.eclipse.jdt.internal.compiler.ast.Expression constantExpression = statement.constantExpression;
        if (constantExpression == null) {
            switchCase.setExpression(null);
        } else {
            switchCase.setExpression(this.convert(constantExpression));
        }
        switchCase.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        this.retrieveColonPosition(switchCase);
        return switchCase;
    }

    public DoStatement convert(org.eclipse.jdt.internal.compiler.ast.DoStatement statement) {
        DoStatement doStatement = this.ast.newDoStatement();
        doStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        doStatement.setExpression(this.convert(statement.condition));
        doStatement.setBody(this.convert(statement.action));
        this.retrieveSemiColonPosition(doStatement);
        return doStatement;
    }

    public EmptyStatement convert(org.eclipse.jdt.internal.compiler.ast.EmptyStatement statement) {
        EmptyStatement emptyStatement = this.ast.newEmptyStatement();
        emptyStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        return emptyStatement;
    }

    public Statement convert(ExplicitConstructorCall statement) {
        Statement newStatement;
        if (statement.isSuperAccess() || statement.isSuper()) {
            org.eclipse.jdt.internal.compiler.ast.Expression[] arguments;
            SuperConstructorInvocation superConstructorInvocation = this.ast.newSuperConstructorInvocation();
            if (statement.qualification != null) {
                superConstructorInvocation.setExpression(this.convert(statement.qualification));
            }
            if ((arguments = statement.arguments) != null) {
                int length = arguments.length;
                for (int i = 0; i < length; ++i) {
                    superConstructorInvocation.arguments().add(this.convert(arguments[i]));
                }
            }
            newStatement = superConstructorInvocation;
        } else {
            ConstructorInvocation constructorInvocation = this.ast.newConstructorInvocation();
            org.eclipse.jdt.internal.compiler.ast.Expression[] arguments = statement.arguments;
            if (arguments != null) {
                int length = arguments.length;
                for (int i = 0; i < length; ++i) {
                    constructorInvocation.arguments().add(this.convert(arguments[i]));
                }
            }
            newStatement = constructorInvocation;
        }
        newStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        this.retrieveSemiColonPosition(newStatement);
        if (this.resolveBindings) {
            this.recordNodes(newStatement, statement);
        }
        return newStatement;
    }

    public ForStatement convert(org.eclipse.jdt.internal.compiler.ast.ForStatement statement) {
        org.eclipse.jdt.internal.compiler.ast.Statement[] increments;
        int i;
        ForStatement forStatement = this.ast.newForStatement();
        forStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        org.eclipse.jdt.internal.compiler.ast.Statement[] initializations = statement.initializations;
        if (initializations != null) {
            if (initializations[0] instanceof LocalDeclaration) {
                VariableDeclarationExpression variableDeclarationExpression = this.convertToVariableDeclarationExpression((LocalDeclaration)initializations[0]);
                int initializationsLength = initializations.length;
                for (i = 1; i < initializationsLength; ++i) {
                    variableDeclarationExpression.fragments().add(this.convertToVariableDeclarationFragment((LocalDeclaration)initializations[i]));
                }
                if (initializationsLength != 1) {
                    int start = variableDeclarationExpression.getStartPosition();
                    int end = ((LocalDeclaration)initializations[initializationsLength - 1]).declarationSourceEnd;
                    variableDeclarationExpression.setSourceRange(start, end - start + 1);
                }
                forStatement.initializers().add(variableDeclarationExpression);
            } else {
                int initializationsLength = initializations.length;
                for (int i2 = 0; i2 < initializationsLength; ++i2) {
                    forStatement.initializers().add(this.convertToExpression(initializations[i2]));
                }
            }
        }
        if (statement.condition != null) {
            forStatement.setExpression(this.convert(statement.condition));
        }
        if ((increments = statement.increments) != null) {
            int incrementsLength = increments.length;
            for (i = 0; i < incrementsLength; ++i) {
                forStatement.updaters().add(this.convertToExpression(increments[i]));
            }
        }
        forStatement.setBody(this.convert(statement.action));
        return forStatement;
    }

    public Expression convertToExpression(org.eclipse.jdt.internal.compiler.ast.Statement statement) {
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.Expression) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.Expression)statement);
        }
        throw new IllegalArgumentException("Not yet implemented: convert(" + statement.getClass() + ")");
    }

    public IfStatement convert(org.eclipse.jdt.internal.compiler.ast.IfStatement statement) {
        IfStatement ifStatement = this.ast.newIfStatement();
        ifStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        ifStatement.setExpression(this.convert(statement.condition));
        ifStatement.setThenStatement(this.convert(statement.thenStatement));
        if (statement.elseStatement != null) {
            ifStatement.setElseStatement(this.convert(statement.elseStatement));
        }
        return ifStatement;
    }

    public LabeledStatement convert(org.eclipse.jdt.internal.compiler.ast.LabeledStatement statement) {
        LabeledStatement labeledStatement = this.ast.newLabeledStatement();
        labeledStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        org.eclipse.jdt.internal.compiler.ast.Statement body = statement.statement;
        labeledStatement.setBody(this.convert(body));
        SimpleName name = this.ast.newSimpleName(new String(statement.label));
        this.retrieveIdentifierAndSetPositions(statement.sourceStart, statement.sourceEnd, name);
        labeledStatement.setLabel(name);
        return labeledStatement;
    }

    public ReturnStatement convert(org.eclipse.jdt.internal.compiler.ast.ReturnStatement statement) {
        ReturnStatement returnStatement = this.ast.newReturnStatement();
        returnStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        if (statement.expression != null) {
            returnStatement.setExpression(this.convert(statement.expression));
        }
        this.retrieveSemiColonPosition(returnStatement);
        return returnStatement;
    }

    public SwitchStatement convert(org.eclipse.jdt.internal.compiler.ast.SwitchStatement statement) {
        SwitchStatement switchStatement = this.ast.newSwitchStatement();
        switchStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        switchStatement.setExpression(this.convert(statement.expression));
        org.eclipse.jdt.internal.compiler.ast.Statement[] statements = statement.statements;
        if (statements != null) {
            int statementsLength = statements.length;
            for (int i = 0; i < statementsLength; ++i) {
                switchStatement.statements().add(this.convert(statements[i]));
            }
        }
        return switchStatement;
    }

    public SynchronizedStatement convert(org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement statement) {
        SynchronizedStatement synchronizedStatement = this.ast.newSynchronizedStatement();
        synchronizedStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        synchronizedStatement.setBody(this.convert(statement.block));
        synchronizedStatement.setExpression(this.convert(statement.expression));
        return synchronizedStatement;
    }

    public ThrowStatement convert(org.eclipse.jdt.internal.compiler.ast.ThrowStatement statement) {
        ThrowStatement throwStatement = this.ast.newThrowStatement();
        throwStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        throwStatement.setExpression(this.convert(statement.exception));
        this.retrieveSemiColonPosition(throwStatement);
        return throwStatement;
    }

    public TryStatement convert(org.eclipse.jdt.internal.compiler.ast.TryStatement statement) {
        TryStatement tryStatement = this.ast.newTryStatement();
        tryStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        tryStatement.setBody(this.convert(statement.tryBlock));
        Argument[] catchArguments = statement.catchArguments;
        if (catchArguments != null) {
            int catchArgumentsLength = catchArguments.length;
            org.eclipse.jdt.internal.compiler.ast.Block[] catchBlocks = statement.catchBlocks;
            int start = statement.tryBlock.sourceEnd;
            for (int i = 0; i < catchArgumentsLength; ++i) {
                CatchClause catchClause = this.ast.newCatchClause();
                int catchClauseSourceStart = this.retrieveStartingCatchPosition(start, catchArguments[i].sourceStart);
                catchClause.setSourceRange(catchClauseSourceStart, catchBlocks[i].sourceEnd - catchClauseSourceStart + 1);
                catchClause.setBody(this.convert(catchBlocks[i]));
                catchClause.setException(this.convert(catchArguments[i]));
                tryStatement.catchClauses().add(catchClause);
                start = catchBlocks[i].sourceEnd;
            }
        }
        if (statement.finallyBlock != null) {
            tryStatement.setFinally(this.convert(statement.finallyBlock));
        }
        return tryStatement;
    }

    public WhileStatement convert(org.eclipse.jdt.internal.compiler.ast.WhileStatement statement) {
        WhileStatement whileStatement = this.ast.newWhileStatement();
        whileStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        whileStatement.setExpression(this.convert(statement.condition));
        org.eclipse.jdt.internal.compiler.ast.Statement action = statement.action;
        whileStatement.setBody(this.convert(action));
        return whileStatement;
    }

    private boolean isPrimitiveType(char[] name) {
        switch (name[0]) {
            case 'i': {
                return name.length == 3 && name[1] == 'n' && name[2] == 't';
            }
            case 'l': {
                return name.length == 4 && name[1] == 'o' && name[2] == 'n' && name[3] == 'g';
            }
            case 'd': {
                return name.length == 6 && name[1] == 'o' && name[2] == 'u' && name[3] == 'b' && name[4] == 'l' && name[5] == 'e';
            }
            case 'f': {
                return name.length == 5 && name[1] == 'l' && name[2] == 'o' && name[3] == 'a' && name[4] == 't';
            }
            case 'b': {
                if (name.length == 4 && name[1] == 'y' && name[2] == 't' && name[3] == 'e') {
                    return true;
                }
                return name.length == 7 && name[1] == 'o' && name[2] == 'o' && name[3] == 'l' && name[4] == 'e' && name[5] == 'a' && name[6] == 'n';
            }
            case 'c': {
                return name.length == 4 && name[1] == 'h' && name[2] == 'a' && name[3] == 'r';
            }
            case 's': {
                return name.length == 5 && name[1] == 'h' && name[2] == 'o' && name[3] == 'r' && name[4] == 't';
            }
            case 'v': {
                return name.length == 4 && name[1] == 'o' && name[2] == 'i' && name[3] == 'd';
            }
        }
        return false;
    }

    private PrimitiveType.Code getPrimitiveTypeCode(char[] name) {
        switch (name[0]) {
            case 'i': {
                if (name.length != 3 || name[1] != 'n' || name[2] != 't') break;
                return PrimitiveType.INT;
            }
            case 'l': {
                if (name.length != 4 || name[1] != 'o' || name[2] != 'n' || name[3] != 'g') break;
                return PrimitiveType.LONG;
            }
            case 'd': {
                if (name.length != 6 || name[1] != 'o' || name[2] != 'u' || name[3] != 'b' || name[4] != 'l' || name[5] != 'e') break;
                return PrimitiveType.DOUBLE;
            }
            case 'f': {
                if (name.length != 5 || name[1] != 'l' || name[2] != 'o' || name[3] != 'a' || name[4] != 't') break;
                return PrimitiveType.FLOAT;
            }
            case 'b': {
                if (name.length == 4 && name[1] == 'y' && name[2] == 't' && name[3] == 'e') {
                    return PrimitiveType.BYTE;
                }
                if (name.length != 7 || name[1] != 'o' || name[2] != 'o' || name[3] != 'l' || name[4] != 'e' || name[5] != 'a' || name[6] != 'n') break;
                return PrimitiveType.BOOLEAN;
            }
            case 'c': {
                if (name.length != 4 || name[1] != 'h' || name[2] != 'a' || name[3] != 'r') break;
                return PrimitiveType.CHAR;
            }
            case 's': {
                if (name.length != 5 || name[1] != 'h' || name[2] != 'o' || name[3] != 'r' || name[4] != 't') break;
                return PrimitiveType.SHORT;
            }
            case 'v': {
                if (name.length != 4 || name[1] != 'o' || name[2] != 'i' || name[3] != 'd') break;
                return PrimitiveType.VOID;
            }
        }
        throw new IllegalArgumentException("Not a primitive type");
    }

    private void retrieveSemiColonPosition(ASTNode node) {
        int start = node.getStartPosition();
        int length = node.getLength();
        int end = start + length;
        int count = 0;
        this.scanner.resetTo(end, this.compilationUnitSource.length);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 23: {
                        if (count != 0) break;
                        node.setSourceRange(start, this.scanner.currentPosition - start);
                        return;
                    }
                    case 59: {
                        ++count;
                        break;
                    }
                    case 40: {
                        --count;
                        break;
                    }
                    case 27: {
                        ++count;
                        break;
                    }
                    case 29: {
                        --count;
                        break;
                    }
                    case 12: {
                        ++count;
                        break;
                    }
                    case 69: {
                        --count;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
    }

    private void retrieveColonPosition(ASTNode node) {
        int start = node.getStartPosition();
        int length = node.getLength();
        int end = start + length;
        this.scanner.resetTo(end, this.compilationUnitSource.length);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 53: {
                        node.setSourceRange(start, this.scanner.currentPosition - start);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
    }

    private int retrieveEndingSemiColonPosition(int start, int end) {
        int count = 0;
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 23: {
                        if (count != 0) break;
                        return this.scanner.currentPosition - 1;
                    }
                    case 59: {
                        ++count;
                        break;
                    }
                    case 40: {
                        --count;
                        break;
                    }
                    case 27: {
                        ++count;
                        break;
                    }
                    case 29: {
                        --count;
                        break;
                    }
                    case 12: {
                        ++count;
                        break;
                    }
                    case 69: {
                        --count;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveExtraDimension(int start, int end) {
        this.scanner.resetTo(start, end);
        int dimensions = 0;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 69: {
                        ++dimensions;
                        break;
                    }
                    case 23: 
                    case 29: 
                    case 30: 
                    case 59: 
                    case 90: {
                        return dimensions;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
        return dimensions;
    }

    private int retrieveEndOfDimensionsPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        int foundPosition = -1;
        try {
            int token;
            block6: while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 12: 
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        continue block6;
                    }
                    case 69: {
                        foundPosition = this.scanner.currentPosition - 1;
                        continue block6;
                    }
                }
                return foundPosition;
            }
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
        return foundPosition;
    }

    private int retrieveStartingCatchPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 86: {
                        return this.scanner.startPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveEndOfElementTypeNamePosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 28: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: {
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveRightBracketPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 69: {
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveEndOfRightParenthesisPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 29: {
                        return this.scanner.currentPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveProperRightBracketPosition(int bracketNumber, int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            int count = 0;
            while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 69: {
                        if (++count != bracketNumber) break;
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveStartBlockPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 59: {
                        return this.scanner.startPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveIdentifierEndPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 28: {
                        return this.scanner.getCurrentTokenEndPosition();
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveEndBlockPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        int count = 0;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 59: {
                        ++count;
                        break;
                    }
                    case 40: {
                        if (--count != 0) break;
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveRightBraceOrSemiColonPosition(MethodDeclaration node, AbstractMethodDeclaration methodDeclaration) {
        int start = node.getStartPosition();
        this.scanner.resetTo(start, methodDeclaration.declarationSourceEnd);
        try {
            int token;
            int braceCounter = 0;
            while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 59: {
                        ++braceCounter;
                        break;
                    }
                    case 40: {
                        if (--braceCounter != 0) break;
                        return this.scanner.currentPosition;
                    }
                    case 23: {
                        if (braceCounter != 0) break;
                        return this.scanner.currentPosition;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
        return -1;
    }

    private int retrievePositionBeforeNextCommaOrSemiColon(int start, int end) {
        this.scanner.resetTo(start, end);
        int braceCounter = 0;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 59: {
                        ++braceCounter;
                        break;
                    }
                    case 40: {
                        --braceCounter;
                        break;
                    }
                    case 27: {
                        ++braceCounter;
                        break;
                    }
                    case 29: {
                        --braceCounter;
                        break;
                    }
                    case 12: {
                        ++braceCounter;
                        break;
                    }
                    case 69: {
                        --braceCounter;
                        break;
                    }
                    case 23: 
                    case 30: {
                        if (braceCounter != 0) break;
                        return this.scanner.startPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
        return -1;
    }

    private VariableDeclarationFragment convertToVariableDeclarationFragment(org.eclipse.jdt.internal.compiler.ast.FieldDeclaration fieldDeclaration) {
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        SimpleName name = this.ast.newSimpleName(new String(fieldDeclaration.name));
        name.setSourceRange(fieldDeclaration.sourceStart, fieldDeclaration.sourceEnd - fieldDeclaration.sourceStart + 1);
        variableDeclarationFragment.setName(name);
        int end = this.retrievePositionBeforeNextCommaOrSemiColon(fieldDeclaration.sourceEnd, fieldDeclaration.declarationSourceEnd);
        if (end == -1) {
            variableDeclarationFragment.setSourceRange(fieldDeclaration.sourceStart, fieldDeclaration.declarationSourceEnd - fieldDeclaration.sourceStart + 1);
            variableDeclarationFragment.setFlags(variableDeclarationFragment.getFlags() | 1);
        } else {
            variableDeclarationFragment.setSourceRange(fieldDeclaration.sourceStart, end - fieldDeclaration.sourceStart + 1);
        }
        if (fieldDeclaration.initialization != null) {
            variableDeclarationFragment.setInitializer(this.convert(fieldDeclaration.initialization));
        }
        variableDeclarationFragment.setExtraDimensions(this.retrieveExtraDimension(fieldDeclaration.sourceEnd + 1, fieldDeclaration.declarationSourceEnd));
        if (this.resolveBindings) {
            this.recordNodes(name, fieldDeclaration);
            this.recordNodes(variableDeclarationFragment, fieldDeclaration);
            variableDeclarationFragment.resolveBinding();
        }
        return variableDeclarationFragment;
    }

    private VariableDeclarationFragment convertToVariableDeclarationFragment(LocalDeclaration localDeclaration) {
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        SimpleName name = this.ast.newSimpleName(new String(localDeclaration.name));
        name.setSourceRange(localDeclaration.sourceStart, localDeclaration.sourceEnd - localDeclaration.sourceStart + 1);
        variableDeclarationFragment.setName(name);
        int end = this.retrievePositionBeforeNextCommaOrSemiColon(localDeclaration.sourceEnd, this.compilationUnitSource.length);
        if (end == -1) {
            if (localDeclaration.initialization != null) {
                variableDeclarationFragment.setSourceRange(localDeclaration.sourceStart, localDeclaration.initialization.sourceEnd - localDeclaration.sourceStart + 1);
            } else {
                variableDeclarationFragment.setSourceRange(localDeclaration.sourceStart, localDeclaration.sourceEnd - localDeclaration.sourceStart + 1);
            }
        } else {
            variableDeclarationFragment.setSourceRange(localDeclaration.sourceStart, end - localDeclaration.sourceStart + 1);
        }
        if (localDeclaration.initialization != null) {
            variableDeclarationFragment.setInitializer(this.convert(localDeclaration.initialization));
        }
        variableDeclarationFragment.setExtraDimensions(this.retrieveExtraDimension(localDeclaration.sourceEnd + 1, this.compilationUnitSource.length));
        if (this.resolveBindings) {
            this.recordNodes(variableDeclarationFragment, localDeclaration);
            this.recordNodes(name, localDeclaration);
            variableDeclarationFragment.resolveBinding();
        }
        return variableDeclarationFragment;
    }

    private FieldDeclaration convertToFieldDeclaration(org.eclipse.jdt.internal.compiler.ast.FieldDeclaration fieldDecl) {
        VariableDeclarationFragment variableDeclarationFragment = this.convertToVariableDeclarationFragment(fieldDecl);
        FieldDeclaration fieldDeclaration = this.ast.newFieldDeclaration(variableDeclarationFragment);
        if (this.resolveBindings) {
            this.recordNodes(variableDeclarationFragment, fieldDecl);
            variableDeclarationFragment.resolveBinding();
        }
        fieldDeclaration.setSourceRange(fieldDecl.declarationSourceStart, fieldDecl.declarationEnd - fieldDecl.declarationSourceStart + 1);
        Type type = this.convertType(fieldDecl.type);
        this.setTypeForField(fieldDeclaration, type, variableDeclarationFragment.getExtraDimensions());
        fieldDeclaration.setModifiers(fieldDecl.modifiers & 0xFFFF);
        this.convert(fieldDecl.javadoc, fieldDeclaration);
        return fieldDeclaration;
    }

    private VariableDeclarationStatement convertToVariableDeclarationStatement(LocalDeclaration localDeclaration) {
        VariableDeclarationFragment variableDeclarationFragment = this.convertToVariableDeclarationFragment(localDeclaration);
        VariableDeclarationStatement variableDeclarationStatement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        if (this.resolveBindings) {
            this.recordNodes(variableDeclarationFragment, localDeclaration);
        }
        variableDeclarationStatement.setSourceRange(localDeclaration.declarationSourceStart, localDeclaration.declarationSourceEnd - localDeclaration.declarationSourceStart + 1);
        Type type = this.convertType(localDeclaration.type);
        this.setTypeForVariableDeclarationStatement(variableDeclarationStatement, type, variableDeclarationFragment.getExtraDimensions());
        variableDeclarationStatement.setModifiers(localDeclaration.modifiers & 0xFBFFFFFF);
        return variableDeclarationStatement;
    }

    private VariableDeclarationExpression convertToVariableDeclarationExpression(LocalDeclaration localDeclaration) {
        VariableDeclarationFragment variableDeclarationFragment = this.convertToVariableDeclarationFragment(localDeclaration);
        VariableDeclarationExpression variableDeclarationExpression = this.ast.newVariableDeclarationExpression(variableDeclarationFragment);
        if (this.resolveBindings) {
            this.recordNodes(variableDeclarationFragment, localDeclaration);
        }
        variableDeclarationExpression.setSourceRange(localDeclaration.declarationSourceStart, localDeclaration.declarationSourceEnd - localDeclaration.declarationSourceStart + 1);
        Type type = this.convertType(localDeclaration.type);
        this.setTypeForVariableDeclarationExpression(variableDeclarationExpression, type, variableDeclarationFragment.getExtraDimensions());
        variableDeclarationExpression.setModifiers(localDeclaration.modifiers & 0xFBFFFFFF);
        return variableDeclarationExpression;
    }

    private void setTypeForField(FieldDeclaration fieldDeclaration, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null, null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    fieldDeclaration.setType(elementType);
                } else {
                    int start = type.getStartPosition();
                    int length = type.getLength();
                    ArrayType subarrayType = arrayType;
                    for (int index = extraDimension; index > 0; --index) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start, start + length);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null, null);
                    fieldDeclaration.setType(subarrayType);
                    this.updateInnerPositions(subarrayType, remainingDimensions);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                fieldDeclaration.setType(type);
            }
        } else {
            if (type.isArrayType()) {
                int dimensions = ((ArrayType)type).getDimensions();
                this.updateInnerPositions(type, dimensions);
            }
            fieldDeclaration.setType(type);
        }
    }

    private void updateInnerPositions(Type type, int dimensions) {
        if (dimensions > 1) {
            int start = type.getStartPosition();
            int length = type.getLength();
            Type currentComponentType = ((ArrayType)type).getComponentType();
            int searchedDimension = dimensions - 1;
            int rightBracketEndPosition = start;
            while (currentComponentType.isArrayType()) {
                rightBracketEndPosition = this.retrieveProperRightBracketPosition(searchedDimension, start, start + length);
                currentComponentType.setSourceRange(start, rightBracketEndPosition - start + 1);
                currentComponentType = ((ArrayType)currentComponentType).getComponentType();
                --searchedDimension;
            }
        }
    }

    private void setTypeForSingleVariableDeclaration(SingleVariableDeclaration singleVariableDeclaration, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null, null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    singleVariableDeclaration.setType(elementType);
                } else {
                    int start = type.getStartPosition();
                    int length = type.getLength();
                    ArrayType subarrayType = arrayType;
                    for (int index = extraDimension; index > 0; --index) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start, start + length);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null, null);
                    this.updateInnerPositions(subarrayType, remainingDimensions);
                    singleVariableDeclaration.setType(subarrayType);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                singleVariableDeclaration.setType(type);
            }
        } else {
            singleVariableDeclaration.setType(type);
        }
    }

    private void setTypeForMethodDeclaration(MethodDeclaration methodDeclaration, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null, null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    methodDeclaration.setReturnType(elementType);
                } else {
                    int start = type.getStartPosition();
                    int length = type.getLength();
                    ArrayType subarrayType = arrayType;
                    for (int index = extraDimension; index > 0; --index) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start, start + length);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null, null);
                    this.updateInnerPositions(subarrayType, remainingDimensions);
                    methodDeclaration.setReturnType(subarrayType);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                methodDeclaration.setReturnType(type);
            }
        } else {
            methodDeclaration.setReturnType(type);
        }
    }

    private void setTypeForVariableDeclarationStatement(VariableDeclarationStatement variableDeclarationStatement, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null, null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    variableDeclarationStatement.setType(elementType);
                } else {
                    int start = type.getStartPosition();
                    int length = type.getLength();
                    ArrayType subarrayType = arrayType;
                    for (int index = extraDimension; index > 0; --index) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start, start + length);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null, null);
                    this.updateInnerPositions(subarrayType, remainingDimensions);
                    variableDeclarationStatement.setType(subarrayType);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                variableDeclarationStatement.setType(type);
            }
        } else {
            variableDeclarationStatement.setType(type);
        }
    }

    private void setTypeForVariableDeclarationExpression(VariableDeclarationExpression variableDeclarationExpression, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null, null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    variableDeclarationExpression.setType(elementType);
                } else {
                    int start = type.getStartPosition();
                    int length = type.getLength();
                    ArrayType subarrayType = arrayType;
                    for (int index = extraDimension; index > 0; --index) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start, start + length);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null, null);
                    this.updateInnerPositions(subarrayType, remainingDimensions);
                    variableDeclarationExpression.setType(subarrayType);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                variableDeclarationExpression.setType(type);
            }
        } else {
            variableDeclarationExpression.setType(type);
        }
    }

    public void convert(org.eclipse.jdt.internal.compiler.ast.Javadoc javadoc, BodyDeclaration bodyDeclaration) {
        if (bodyDeclaration.getJavadoc() == null && javadoc != null) {
            Comment comment;
            if (this.commentMapper == null || !this.commentMapper.hasSameTable(this.commentsTable)) {
                this.commentMapper = new DefaultCommentMapper(this.commentsTable);
            }
            if ((comment = this.commentMapper.getComment(javadoc.sourceStart)) != null && comment.isDocComment() && comment.getParent() == null) {
                Javadoc docComment = (Javadoc)comment;
                if (this.resolveBindings) {
                    this.recordNodes(docComment, javadoc);
                    ListIterator tags = docComment.tags().listIterator();
                    while (tags.hasNext()) {
                        this.recordNodes(javadoc, (TagElement)tags.next());
                    }
                }
                bodyDeclaration.setJavadoc(docComment);
            }
        }
    }

    private void recordNodes(org.eclipse.jdt.internal.compiler.ast.Javadoc javadoc, TagElement tagElement) {
        MemberRef memberRef;
        ListIterator fragments = tagElement.fragments().listIterator();
        int size = tagElement.fragments().size();
        int[] replaceIndex = new int[size];
        int idx = 0;
        while (fragments.hasNext()) {
            org.eclipse.jdt.internal.compiler.ast.Expression expression;
            TypeReference typeRef;
            org.eclipse.jdt.internal.compiler.ast.ASTNode compilerNode;
            int start;
            SimpleName name;
            ASTNode node = (ASTNode)fragments.next();
            replaceIndex[idx] = 0;
            if (node.getNodeType() == 67) {
                memberRef = (MemberRef)node;
                name = memberRef.getName();
                start = name.getStartPosition();
                compilerNode = javadoc.getNodeStartingAt(start);
                if (compilerNode instanceof JavadocMessageSend) {
                    replaceIndex[idx] = 1;
                }
                if (compilerNode != null) {
                    this.recordNodes(name, compilerNode);
                    this.recordNodes(node, compilerNode);
                }
                if (memberRef.getQualifier() == null) continue;
                typeRef = null;
                if (compilerNode instanceof JavadocFieldReference) {
                    expression = ((JavadocFieldReference)compilerNode).receiver;
                    if (expression instanceof TypeReference) {
                        typeRef = (TypeReference)expression;
                    }
                } else if (compilerNode instanceof JavadocMessageSend && (expression = ((JavadocMessageSend)compilerNode).receiver) instanceof TypeReference) {
                    typeRef = (TypeReference)expression;
                }
                if (typeRef == null) continue;
                this.recordName(memberRef.getQualifier(), typeRef);
                continue;
            }
            if (node.getNodeType() == 68) {
                MethodRef methodRef = (MethodRef)node;
                name = methodRef.getName();
                start = name.getStartPosition();
                compilerNode = javadoc.getNodeStartingAt(start);
                if (compilerNode != null) {
                    this.recordNodes(methodRef, compilerNode);
                    typeRef = null;
                    if (compilerNode instanceof JavadocAllocationExpression) {
                        typeRef = ((JavadocAllocationExpression)compilerNode).type;
                        if (typeRef != null) {
                            this.recordNodes(name, typeRef);
                        }
                    } else if (compilerNode instanceof JavadocMessageSend) {
                        expression = ((JavadocMessageSend)compilerNode).receiver;
                        if (expression instanceof TypeReference) {
                            typeRef = (TypeReference)expression;
                        }
                        this.recordNodes(name, compilerNode);
                    }
                    if (typeRef != null && methodRef.getQualifier() != null) {
                        this.recordName(methodRef.getQualifier(), typeRef);
                    }
                }
                ListIterator parameters = methodRef.parameters().listIterator();
                while (parameters.hasNext()) {
                    Type type;
                    MethodRefParameter param = (MethodRefParameter)parameters.next();
                    org.eclipse.jdt.internal.compiler.ast.Expression expression2 = (org.eclipse.jdt.internal.compiler.ast.Expression)javadoc.getNodeStartingAt(param.getStartPosition());
                    if (expression2 == null) continue;
                    this.recordNodes(param, expression2);
                    if (!(expression2 instanceof JavadocArgumentExpression)) continue;
                    JavadocArgumentExpression argExpr = (JavadocArgumentExpression)expression2;
                    TypeReference typeRef2 = argExpr.argument.type;
                    this.recordNodes(param.getType(), typeRef2);
                    if (param.getType().isSimpleType()) {
                        type = (SimpleType)param.getType();
                        this.recordName(((SimpleType)type).getName(), typeRef2);
                        continue;
                    }
                    if (!param.getType().isArrayType() || !(type = ((ArrayType)param.getType()).getElementType()).isSimpleType()) continue;
                    this.recordName(((SimpleType)type).getName(), typeRef2);
                }
                continue;
            }
            if (node.getNodeType() == 42 || node.getNodeType() == 40) {
                org.eclipse.jdt.internal.compiler.ast.ASTNode compilerNode2 = javadoc.getNodeStartingAt(node.getStartPosition());
                this.recordName((Name)node, compilerNode2);
                continue;
            }
            if (node.getNodeType() != 65) continue;
            this.recordNodes(javadoc, (TagElement)node);
        }
        for (int i = 0; i < size; ++i) {
            if (replaceIndex[i] != 1) continue;
            memberRef = (MemberRef)tagElement.fragments().remove(i);
            MethodRef methodRef = this.ast.newMethodRef();
            methodRef.setName((SimpleName)memberRef.getName().clone(this.ast));
            if (memberRef.getQualifier() != null) {
                methodRef.setQualifier((Name)memberRef.getQualifier().clone(this.ast));
            }
            methodRef.setSourceRange(memberRef.getStartPosition(), memberRef.getLength());
            tagElement.fragments().add(i, methodRef);
        }
    }

    private void recordName(Name name, org.eclipse.jdt.internal.compiler.ast.ASTNode compilerNode) {
        if (compilerNode != null) {
            this.recordNodes(name, compilerNode);
            if (compilerNode instanceof TypeReference) {
                TypeReference typeRef = (TypeReference)compilerNode;
                if (name.isQualifiedName()) {
                    int count = 0;
                    SimpleName simpleName = null;
                    while (name.isQualifiedName()) {
                        simpleName = ((QualifiedName)name).getName();
                        this.recordNodes(simpleName, typeRef);
                        simpleName.index = count++;
                        name = ((QualifiedName)name).getQualifier();
                        name.index = count;
                        this.recordNodes(name, typeRef);
                    }
                }
            }
        }
    }

    private Comment createComment(int[] positions) {
        Comment comment = null;
        int start = positions[0];
        int end = positions[1];
        if (positions[1] > 0) {
            this.ast.newJavadoc();
            Javadoc docComment = this.docParser.parse(positions);
            if (docComment == null) {
                return null;
            }
            comment = docComment;
        } else {
            end = -end;
            if (positions[0] > 0) {
                comment = this.ast.newBlockComment();
            } else {
                start = -start;
                comment = this.ast.newLineComment();
            }
            comment.setSourceRange(start, end - start);
        }
        return comment;
    }

    void propagateErrors(ASTNode astNode, IProblem[] problems) {
        ASTSyntaxErrorPropagator syntaxErrorPropagator = new ASTSyntaxErrorPropagator(problems);
        astNode.accept(syntaxErrorPropagator);
    }

    private void recordNodes(ASTNode node, org.eclipse.jdt.internal.compiler.ast.ASTNode oldASTNode) {
        this.ast.getBindingResolver().store(node, oldASTNode);
    }

    private void trimWhiteSpacesAndComments(org.eclipse.jdt.internal.compiler.ast.Expression expression) {
        int start = expression.sourceStart;
        int end = expression.sourceEnd;
        int trimLeftPosition = expression.sourceStart;
        int trimRightPosition = expression.sourceEnd;
        boolean first = true;
        Scanner removeBlankScanner = this.ast.scanner;
        try {
            removeBlankScanner.setSource(this.compilationUnitSource);
            removeBlankScanner.resetTo(start, end);
            block7: while (true) {
                int token = removeBlankScanner.getNextToken();
                switch (token) {
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        if (!first) continue block7;
                        trimLeftPosition = removeBlankScanner.currentPosition;
                        continue block7;
                    }
                    case 1000: {
                        if (!first) continue block7;
                        trimLeftPosition = removeBlankScanner.currentPosition;
                        continue block7;
                    }
                    case 54: {
                        expression.sourceStart = trimLeftPosition;
                        expression.sourceEnd = trimRightPosition;
                        return;
                    }
                }
                trimRightPosition = removeBlankScanner.currentPosition - 1;
                first = false;
            }
        }
        catch (InvalidInputException e) {
            return;
        }
    }

    private void adjustSourcePositionsForParent(org.eclipse.jdt.internal.compiler.ast.Expression expression) {
        int start = expression.sourceStart;
        int end = expression.sourceEnd;
        int leftParentCount = 1;
        int rightParentCount = 0;
        this.scanner.resetTo(start, end);
        try {
            int token = this.scanner.getNextToken();
            expression.sourceStart = this.scanner.currentPosition;
            boolean stop = false;
            while (!stop && (token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 27: {
                        ++leftParentCount;
                        break;
                    }
                    case 29: {
                        if (++rightParentCount != leftParentCount) break;
                        stop = true;
                    }
                }
            }
            expression.sourceEnd = this.scanner.startPosition - 1;
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
    }

    private void retrieveIdentifierAndSetPositions(int start, int end, Name name) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 54) {
                if (token != 28) continue;
                int startName = this.scanner.startPosition;
                int endName = this.scanner.currentPosition - 1;
                name.setSourceRange(startName, endName - startName + 1);
                return;
            }
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
    }

    private void removeTrailingCommentFromExpressionEndingWithAParen(ASTNode node) {
        int start = node.getStartPosition();
        this.scanner.resetTo(start, start + node.getLength());
        int parenCounter = 0;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 27: {
                        ++parenCounter;
                        break;
                    }
                    case 29: {
                        if (--parenCounter != 0) break;
                        int end = this.scanner.currentPosition - 1;
                        node.setSourceRange(start, end - start + 1);
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
    }

    private void removeLeadingAndTrailingCommentsFromLiteral(ASTNode node) {
        int start = node.getStartPosition();
        this.scanner.resetTo(start, start + node.getLength());
        int startPosition = -1;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 54) {
                switch (token) {
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        if (startPosition == -1) {
                            startPosition = this.scanner.startPosition;
                        }
                        int end = this.scanner.currentPosition;
                        node.setSourceRange(startPosition, end - startPosition);
                        return;
                    }
                    case 2: {
                        startPosition = this.scanner.startPosition;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
    }

    private void recordPendingThisExpressionScopeResolution(ThisExpression thisExpression) {
        if (this.pendingThisExpressionScopeResolution == null) {
            this.pendingThisExpressionScopeResolution = new HashSet();
        }
        this.pendingThisExpressionScopeResolution.add(thisExpression);
    }

    private void recordPendingNameScopeResolution(Name name) {
        if (this.pendingNameScopeResolution == null) {
            this.pendingNameScopeResolution = new HashSet();
        }
        this.pendingNameScopeResolution.add(name);
    }

    private void lookupForScopes() {
        Iterator iterator;
        if (this.pendingNameScopeResolution != null) {
            iterator = this.pendingNameScopeResolution.iterator();
            while (iterator.hasNext()) {
                Name name = (Name)iterator.next();
                this.ast.getBindingResolver().recordScope(name, this.lookupScope(name));
            }
        }
        if (this.pendingThisExpressionScopeResolution != null) {
            iterator = this.pendingThisExpressionScopeResolution.iterator();
            while (iterator.hasNext()) {
                ThisExpression thisExpression = (ThisExpression)iterator.next();
                this.ast.getBindingResolver().recordScope(thisExpression, this.lookupScope(thisExpression));
            }
        }
    }

    private BlockScope lookupScope(ASTNode node) {
        ASTNode currentNode;
        for (currentNode = node; !(currentNode == null || currentNode instanceof MethodDeclaration || currentNode instanceof Initializer || currentNode instanceof FieldDeclaration); currentNode = currentNode.getParent()) {
        }
        if (currentNode == null) {
            return null;
        }
        if (currentNode instanceof Initializer) {
            Initializer initializer = (Initializer)currentNode;
            while (!(currentNode instanceof TypeDeclaration)) {
                currentNode = currentNode.getParent();
            }
            org.eclipse.jdt.internal.compiler.ast.TypeDeclaration typeDecl = (org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)this.ast.getBindingResolver().getCorrespondingNode(currentNode);
            if ((initializer.getModifiers() & 8) != 0) {
                return typeDecl.staticInitializerScope;
            }
            return typeDecl.initializerScope;
        }
        if (currentNode instanceof FieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)currentNode;
            while (!(currentNode instanceof TypeDeclaration)) {
                currentNode = currentNode.getParent();
            }
            org.eclipse.jdt.internal.compiler.ast.TypeDeclaration typeDecl = (org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)this.ast.getBindingResolver().getCorrespondingNode(currentNode);
            if ((fieldDeclaration.getModifiers() & 8) != 0) {
                return typeDecl.staticInitializerScope;
            }
            return typeDecl.initializerScope;
        }
        AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)this.ast.getBindingResolver().getCorrespondingNode(currentNode);
        return abstractMethodDeclaration.scope;
    }

    private InfixExpression.Operator getOperatorFor(int operatorID) {
        switch (operatorID) {
            case 18: {
                return InfixExpression.Operator.EQUALS;
            }
            case 5: {
                return InfixExpression.Operator.LESS_EQUALS;
            }
            case 7: {
                return InfixExpression.Operator.GREATER_EQUALS;
            }
            case 29: {
                return InfixExpression.Operator.NOT_EQUALS;
            }
            case 10: {
                return InfixExpression.Operator.LEFT_SHIFT;
            }
            case 17: {
                return InfixExpression.Operator.RIGHT_SHIFT_SIGNED;
            }
            case 19: {
                return InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED;
            }
            case 1: {
                return InfixExpression.Operator.CONDITIONAL_OR;
            }
            case 0: {
                return InfixExpression.Operator.CONDITIONAL_AND;
            }
            case 14: {
                return InfixExpression.Operator.PLUS;
            }
            case 13: {
                return InfixExpression.Operator.MINUS;
            }
            case 16: {
                return InfixExpression.Operator.REMAINDER;
            }
            case 8: {
                return InfixExpression.Operator.XOR;
            }
            case 2: {
                return InfixExpression.Operator.AND;
            }
            case 15: {
                return InfixExpression.Operator.TIMES;
            }
            case 3: {
                return InfixExpression.Operator.OR;
            }
            case 9: {
                return InfixExpression.Operator.DIVIDE;
            }
            case 6: {
                return InfixExpression.Operator.GREATER;
            }
            case 4: {
                return InfixExpression.Operator.LESS;
            }
        }
        return null;
    }
}

