/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.SyncInfoCache;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;

class SynchronizerSyncInfoCache
extends SyncInfoCache {
    Map pendingCacheWrites = new HashMap();
    private static final Object BYTES_REMOVED = new byte[0];

    public SynchronizerSyncInfoCache() {
        this.getWorkspaceSynchronizer().add(FOLDER_SYNC_KEY);
        this.getWorkspaceSynchronizer().add(RESOURCE_SYNC_KEY);
    }

    private ISynchronizer getWorkspaceSynchronizer() {
        return ResourcesPlugin.getWorkspace().getSynchronizer();
    }

    void flush(IProject project) throws CVSException {
        this.purgeCache((IContainer)project, true);
    }

    void flush(IFolder folder) throws CVSException {
        this.purgeCache((IContainer)folder, false);
    }

    FolderSyncInfo getCachedFolderSync(IContainer container) throws CVSException {
        byte[] bytes = this.internalGetCachedSyncBytes(container);
        if (bytes == null) {
            return null;
        }
        return FolderSyncInfo.getFolderSyncInfo(bytes);
    }

    boolean hasCachedFolderSync(IContainer container) throws CVSException {
        return this.internalGetCachedSyncBytes(container) != null;
    }

    private byte[] internalGetCachedSyncBytes(IContainer container) throws CVSException {
        try {
            return this.getWorkspaceSynchronizer().getSyncInfo(FOLDER_SYNC_KEY, (IResource)container);
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    void setCachedFolderSync(IContainer container, FolderSyncInfo info, boolean canModifyWorkspace) throws CVSException {
        try {
            if (info == null) {
                if (container.exists() || container.isPhantom()) {
                    this.getWorkspaceSynchronizer().flushSyncInfo(FOLDER_SYNC_KEY, (IResource)container, 0);
                }
            } else {
                this.getWorkspaceSynchronizer().setSyncInfo(FOLDER_SYNC_KEY, (IResource)container, info.getBytes());
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    byte[] getCachedSyncBytes(IResource resource) throws CVSException {
        try {
            byte[] bytes;
            if (this.pendingCacheWrites.containsKey(resource)) {
                bytes = (byte[])this.pendingCacheWrites.get(resource);
                if (bytes == BYTES_REMOVED) {
                    bytes = null;
                }
            } else {
                bytes = this.getWorkspaceSynchronizer().getSyncInfo(RESOURCE_SYNC_KEY, resource);
            }
            if (bytes != null && resource.getType() == 1) {
                if (ResourceSyncInfo.isAddition(bytes)) {
                    bytes = null;
                } else if (!ResourceSyncInfo.isDeletion(bytes)) {
                    bytes = ResourceSyncInfo.convertToDeletion(bytes);
                }
            }
            return bytes;
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    void setCachedSyncBytes(IResource resource, byte[] syncBytes, boolean canModifyWorkspace) throws CVSException {
        byte[] oldBytes = this.getCachedSyncBytes(resource);
        try {
            if (syncBytes == null) {
                if (oldBytes != null) {
                    if (canModifyWorkspace) {
                        if (resource.exists() || resource.isPhantom()) {
                            this.getWorkspaceSynchronizer().flushSyncInfo(RESOURCE_SYNC_KEY, resource, 0);
                        }
                        this.pendingCacheWrites.remove(resource);
                    } else if (resource.exists() || resource.isPhantom()) {
                        this.pendingCacheWrites.put(resource, BYTES_REMOVED);
                    }
                }
            } else if (oldBytes == null || !this.equals(syncBytes, oldBytes)) {
                if (canModifyWorkspace) {
                    this.getWorkspaceSynchronizer().setSyncInfo(RESOURCE_SYNC_KEY, resource, syncBytes);
                    this.pendingCacheWrites.remove(resource);
                } else {
                    this.pendingCacheWrites.put(resource, syncBytes);
                }
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    private boolean equals(byte[] syncBytes, byte[] oldBytes) throws CVSException {
        if (!ResourceSyncInfo.isFolder(syncBytes)) {
            syncBytes = ResourceSyncInfo.convertToDeletion(syncBytes);
        }
        if (!ResourceSyncInfo.isFolder(oldBytes)) {
            try {
                oldBytes = ResourceSyncInfo.convertToDeletion(oldBytes);
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
                return false;
            }
        }
        return Util.equals(syncBytes, oldBytes);
    }

    String getDirtyIndicator(IResource resource) throws CVSException {
        if (resource.getType() == 1) {
            return this.getCachedSyncBytes(resource) != null ? "d" : "c";
        }
        return this.calculateDirtyCountForPhantomFolder((IContainer)resource);
    }

    void setDirtyIndicator(IResource resource, String indicator) throws CVSException {
    }

    public boolean cachesDirtyState() {
        return false;
    }

    void flushDirtyCache(IResource container) throws CVSException {
    }

    boolean isSyncInfoLoaded(IContainer parent) throws CVSException {
        return true;
    }

    boolean isResourceSyncInfoCached(IContainer container) throws CVSException {
        return true;
    }

    void setResourceSyncInfoCached(IContainer container) throws CVSException {
    }

    boolean isFolderSyncInfoCached(IContainer container) throws CVSException {
        return true;
    }

    boolean isDirtyCacheFlushed(IContainer resource) throws CVSException {
        return false;
    }

    private String calculateDirtyCountForPhantomFolder(IContainer parent) throws CVSException {
        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor(parent);
        if (this.getCachedFolderSync(parent) == null) {
            return "c";
        }
        String indicator = "c";
        ICVSResource[] children = cvsFolder.members(80);
        for (int i = 0; i < children.length; ++i) {
            ICVSResource resource = children[i];
            if (!resource.isFolder()) {
                indicator = "d";
                break;
            }
            indicator = this.calculateDirtyCountForPhantomFolder((IContainer)resource.getIResource());
        }
        return indicator;
    }

    public void purgeCache(IContainer root, boolean deep) throws CVSException {
        int depth = deep ? 2 : 0;
        try {
            if (root.exists() || root.isPhantom()) {
                this.getWorkspaceSynchronizer().flushSyncInfo(RESOURCE_SYNC_KEY, (IResource)root, depth);
            }
            if (root.exists() || root.isPhantom()) {
                this.getWorkspaceSynchronizer().flushSyncInfo(FOLDER_SYNC_KEY, (IResource)root, depth);
            }
            if (deep) {
                IPath fullPath = root.getFullPath();
                Iterator iter = this.pendingCacheWrites.keySet().iterator();
                while (iter.hasNext()) {
                    IResource resource = (IResource)iter.next();
                    if (!fullPath.isPrefixOf(resource.getFullPath())) continue;
                    iter.remove();
                }
            } else {
                this.pendingCacheWrites.remove(root);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 368) {
                return;
            }
            throw CVSException.wrapException(e);
        }
    }

    public boolean isPhantom(IResource resource) {
        return resource.isPhantom() || this.pendingCacheWrites.containsKey(resource);
    }
}

