/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class PrepareForReplaceVisitor
implements ICVSResourceVisitor {
    private IProgressMonitor monitor;
    private int depth;

    public void visitFile(ICVSFile file) throws CVSException {
        byte[] syncBytes = file.getSyncBytes();
        if (syncBytes == null) {
            if (CVSProviderPlugin.getPlugin().isReplaceUnmanaged()) {
                file.delete();
            }
        } else if (ResourceSyncInfo.isAddition(syncBytes)) {
            file.delete();
            file.unmanage(null);
        } else if (ResourceSyncInfo.isDeletion(syncBytes)) {
            file.unmanage(null);
        } else if (file.isModified(null)) {
            file.unmanage(null);
            file.delete();
        }
        this.monitor.worked(1);
    }

    public void visitFolder(ICVSFolder folder) throws CVSException {
        if (!folder.isCVSFolder() && CVSProviderPlugin.getPlugin().isReplaceUnmanaged()) {
            folder.delete();
        } else {
            int i;
            if (this.depth == 2) {
                folder.acceptChildren(this);
            } else if (this.depth == 1) {
                ICVSResource[] files = folder.members(1);
                for (i = 0; i < files.length; ++i) {
                    files[i].accept(this);
                }
            }
            ICVSResource[] ignoredFiles = folder.members(5);
            for (i = 0; i < ignoredFiles.length; ++i) {
                ICVSResource cvsResource = ignoredFiles[i];
                if (!cvsResource.getName().startsWith(".#")) continue;
                cvsResource.delete();
            }
        }
        this.monitor.worked(1);
    }

    public void visitResources(IProject project, final ICVSResource[] resources, final String key, int depth, IProgressMonitor pm) throws CVSException {
        this.depth = depth;
        CVSWorkspaceRoot.getCVSFolderFor((IContainer)project).run(new ICVSRunnable(){

            public void run(IProgressMonitor pm) throws CVSException {
                PrepareForReplaceVisitor.this.monitor = Policy.infiniteSubMonitorFor(pm, 100);
                PrepareForReplaceVisitor.this.monitor.beginTask(null, 512);
                for (int i = 0; i < resources.length; ++i) {
                    if (key != null) {
                        PrepareForReplaceVisitor.this.monitor.subTask(Policy.bind(key, resources[i].getIResource().getFullPath().toString()));
                    }
                    resources[i].accept(PrepareForReplaceVisitor.this);
                }
                PrepareForReplaceVisitor.this.monitor.done();
            }
        }, pm);
    }
}

