/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import morfologik.stemming.Dictionary;
import morfologik.stemming.WordData;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.tagging.CombiningTagger;
import org.languagetool.tagging.ManualTagger;
import org.languagetool.tagging.MorfologikTagger;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.WordTagger;
import org.languagetool.tools.StringTools;

public abstract class BaseTagger
implements Tagger {
    protected final WordTagger wordTagger;
    protected final Locale conversionLocale;
    private final boolean tagLowercaseWithUppercase;
    private final String dictionaryPath;
    private final Dictionary dictionary;

    @Nullable
    public abstract String getManualAdditionsFileName();

    @Nullable
    public String getManualRemovalsFileName() {
        return null;
    }

    public BaseTagger(String filename) {
        this(filename, Locale.getDefault(), true);
    }

    public BaseTagger(String filename, Locale conversionLocale) {
        this(filename, conversionLocale, true);
    }

    public BaseTagger(String filename, Locale locale, boolean tagLowercaseWithUppercase) {
        this.dictionaryPath = filename;
        this.conversionLocale = locale;
        this.tagLowercaseWithUppercase = tagLowercaseWithUppercase;
        try {
            URL url = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(filename);
            this.dictionary = Dictionary.read((URL)url);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load dictionary from " + filename, e);
        }
        this.wordTagger = this.initWordTagger();
    }

    public String getDictionaryPath() {
        return this.dictionaryPath;
    }

    public boolean overwriteWithManualTagger() {
        return false;
    }

    protected WordTagger getWordTagger() {
        return this.wordTagger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WordTagger initWordTagger() {
        MorfologikTagger morfologikTagger = new MorfologikTagger(this.dictionary);
        try {
            String manualAdditionFileName;
            String manualRemovalFileName = this.getManualRemovalsFileName();
            ManualTagger removalTagger = null;
            if (manualRemovalFileName != null) {
                try (InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(manualRemovalFileName);){
                    removalTagger = new ManualTagger(stream);
                }
            }
            if ((manualAdditionFileName = this.getManualAdditionsFileName()) == null) return morfologikTagger;
            try (InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(manualAdditionFileName);){
                ManualTagger manualTagger = new ManualTagger(stream);
                CombiningTagger combiningTagger = new CombiningTagger(morfologikTagger, manualTagger, removalTagger, this.overwriteWithManualTagger());
                return combiningTagger;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load manual tagger data from " + this.getManualAdditionsFileName(), e);
        }
    }

    protected Dictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        for (String word : sentenceTokens) {
            List<AnalyzedToken> l = this.getAnalyzedTokens(word);
            tokenReadings.add(new AnalyzedTokenReadings(l, pos));
            pos += word.length();
        }
        return tokenReadings;
    }

    protected List<AnalyzedToken> getAnalyzedTokens(String word) {
        List<AnalyzedToken> upperTaggerTokens;
        ArrayList<AnalyzedToken> result = new ArrayList<AnalyzedToken>();
        String lowerWord = word.toLowerCase(this.conversionLocale);
        boolean isLowercase = word.equals(lowerWord);
        boolean isMixedCase = StringTools.isMixedCase(word);
        List<AnalyzedToken> taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(word));
        List<AnalyzedToken> lowerTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(lowerWord));
        this.addTokens(taggerTokens, result);
        if (!isLowercase && !isMixedCase) {
            this.addTokens(lowerTaggerTokens, result);
        }
        if (this.tagLowercaseWithUppercase && lowerTaggerTokens.isEmpty() && taggerTokens.isEmpty() && isLowercase && !(upperTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(StringTools.uppercaseFirstChar(word)))).isEmpty()) {
            this.addTokens(upperTaggerTokens, result);
        }
        if (result.isEmpty()) {
            List<AnalyzedToken> additionalTaggedTokens = this.additionalTags(word, this.getWordTagger());
            this.addTokens(additionalTaggedTokens, result);
        }
        if (result.isEmpty()) {
            result.add(new AnalyzedToken(word, null, null));
        }
        return result;
    }

    protected List<AnalyzedToken> asAnalyzedTokenList(String word, List<WordData> wdList) {
        ArrayList<AnalyzedToken> aTokenList = new ArrayList<AnalyzedToken>();
        for (WordData wd : wdList) {
            aTokenList.add(this.asAnalyzedToken(word, wd));
        }
        return aTokenList;
    }

    protected List<AnalyzedToken> asAnalyzedTokenListForTaggedWords(String word, List<TaggedWord> taggedWords) {
        ArrayList<AnalyzedToken> aTokenList = new ArrayList<AnalyzedToken>();
        for (TaggedWord taggedWord : taggedWords) {
            aTokenList.add(this.asAnalyzedToken(word, taggedWord));
        }
        return aTokenList;
    }

    protected AnalyzedToken asAnalyzedToken(String word, WordData wd) {
        String tag = StringTools.asString(wd.getTag());
        if (this.dictionary.metadata.isFrequencyIncluded() && tag.length() > 1) {
            tag = tag.substring(0, tag.length() - 1);
        }
        return new AnalyzedToken(word, tag, StringTools.asString(wd.getStem()));
    }

    private AnalyzedToken asAnalyzedToken(String word, TaggedWord taggedWord) {
        return new AnalyzedToken(word, taggedWord.getPosTag(), taggedWord.getLemma());
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            for (AnalyzedToken at : taggedTokens) {
                l.add(at);
            }
        }
    }

    @Override
    public final AnalyzedTokenReadings createNullToken(String token, int startPos) {
        return new AnalyzedTokenReadings(new AnalyzedToken(token, null, null), startPos);
    }

    @Override
    public AnalyzedToken createToken(String token, String posTag) {
        return new AnalyzedToken(token, posTag, null);
    }

    @Nullable
    protected List<AnalyzedToken> additionalTags(String word, WordTagger wordTagger) {
        return null;
    }
}

