/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.StreamMessage;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.models.stream.ClaimedMessages;
import io.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClaimedMessagesOutput<K, V>
extends CommandOutput<K, V, ClaimedMessages<K, V>> {
    private final boolean justId;
    private final K stream;
    private String startId;
    private String id;
    private boolean hasId;
    private K key;
    private boolean hasKey;
    private Map<K, V> body;
    private boolean bodyReceived;
    private final List<StreamMessage<K, V>> messages;

    public ClaimedMessagesOutput(RedisCodec<K, V> codec, K stream, boolean justId) {
        super(codec, null);
        this.stream = stream;
        this.messages = new ArrayList<StreamMessage<K, V>>();
        this.justId = justId;
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.startId == null) {
            this.startId = this.decodeString(bytes);
            return;
        }
        if (this.id == null) {
            this.id = this.decodeString(bytes);
            return;
        }
        if (this.justId) {
            return;
        }
        if (!this.hasKey) {
            this.bodyReceived = true;
            this.hasKey = true;
            if (bytes == null) {
                return;
            }
            this.key = this.codec.decodeKey(bytes);
            return;
        }
        if (this.body == null) {
            this.body = new LinkedHashMap();
        }
        this.body.put(this.key, bytes == null ? null : (Object)this.codec.decodeValue(bytes));
        this.key = null;
        this.hasKey = false;
    }

    @Override
    public void complete(int depth) {
        if (depth == 3 && this.bodyReceived) {
            this.messages.add(new StreamMessage(this.stream, this.id, this.body == null ? Collections.emptyMap() : this.body));
            this.bodyReceived = false;
            this.key = null;
            this.hasKey = false;
            this.body = null;
            this.id = null;
            this.hasId = false;
        }
        if (depth == 2 && this.justId) {
            this.messages.add(new StreamMessage(this.stream, this.id, null));
            this.key = null;
            this.hasKey = false;
            this.body = null;
            this.id = null;
            this.hasId = false;
        }
        if (depth == 0) {
            this.output = new ClaimedMessages<K, V>(this.startId, Collections.unmodifiableList(this.messages));
        }
    }
}

