/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.validation.testing.constraints;

import com.google.gwt.validation.client.constraints.SizeValidatorForMap;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.validation.constraints.Size;

/**
 * Tests for {@link SizeValidatorForMap}.
 */
public class SizeValidatorForMapTest extends
    ConstraintValidatorTestCase<Size, Map<?, ?>> {

  @SuppressWarnings("unused")
  @Size(min = 2, max = 5)
  private Date defaultField;

  @Override
  protected SizeValidatorForMap createValidator() {
    return new SizeValidatorForMap();
  }

  public void testAssertIsValid_short() {
    assertConstraintValidator(createMap(1), false);
  }

  public void testAssertIsValid_min() {
    assertConstraintValidator(createMap(2), true);
  }

  public void testAssertIsValid_max() {
    assertConstraintValidator(createMap(5), true);
  }

  public void testAssertIsValid_long() {
    assertConstraintValidator(createMap(6), false);
  }

  private Map<Integer, String> createMap(int size) {
    Map<Integer, String> map = new HashMap<Integer, String>(size);
    for (int i = 1; i <= size; i++) {
      Integer key = Integer.valueOf(i);
      map.put(key, key.toString());
    }
    return map;
  }

  @Override
  protected Class<Size> getAnnotationClass() {
    return Size.class;
  }
}
