/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.aries.jax.rs.rest.management.RestManagementConstants;
import org.apache.aries.jax.rs.rest.management.internal.BaseResource;
import org.apache.aries.jax.rs.rest.management.schema.BundleExceptionSchema;
import org.apache.aries.jax.rs.rest.management.schema.BundleSchema;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class FrameworkBundleResource
extends BaseResource {
    public FrameworkBundleResource(BundleContext bundleContext) {
        super(bundleContext);
    }

    @GET
    @Produces(value={"application/org.osgi.bundle+json", "application/org.osgi.bundle+xml"})
    @Path(value="framework/bundle/{bundleid}{ext:(\\.json|\\.xml)*}")
    @Operation(operationId="GET/bundle", summary="Retrieves a Bundle Representation from the REST management service", responses={@ApiResponse(responseCode="200", description="The request has been served successfully", content={@Content(schema=@Schema(implementation=BundleSchema.class))}), @ApiResponse(responseCode="404", description="There is no bundle with the given bundle id"), @ApiResponse(responseCode="406", description="The REST management service does not support any of the requested representations")})
    public Response bundle(@PathParam(value="bundleid") long bundleid, @Parameter(allowEmptyValue=true, description="File extension", schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext) {
        Bundle bundle = this.bundleContext.getBundle(bundleid);
        if (bundle == null) {
            throw new WebApplicationException("There is no bundle with the given bundle id", 404);
        }
        Response.ResponseBuilder builder = Response.ok((Object)((Object)this.bundleSchema(bundle)));
        return Optional.ofNullable(ext).map(String::trim).map(e -> ".json".equals(e) ? "application/org.osgi.bundle+json" : "application/org.osgi.bundle+xml").map(type -> builder.type(type)).orElse(builder).build();
    }

    @PUT
    @Consumes(value={"text/plain"})
    @Produces(value={"application/org.osgi.bundle+json", "application/org.osgi.bundle+xml"})
    @Path(value="framework/bundle/{bundleid}{ext:(\\.json|\\.xml)*}")
    @Operation(operationId="PUT/bundle", summary="Updates the bundle with a new version", requestBody=@RequestBody(description="One of the following contents is allowed; a location string with content-type type 'text/plain' OR a bundle jar with content-type 'application/vnd.osgi.bundle'", required=true, content={@Content(mediaType="text/plain", schema=@Schema(description="a location string", type="string")), @Content(mediaType="application/vnd.osgi.bundle", schema=@Schema(description="a bundle jar", type="string", format="binary"))}), responses={@ApiResponse(responseCode="200", description="The request was received and valid and the framework has issued the update", content={@Content(schema=@Schema(implementation=BundleSchema.class))}), @ApiResponse(responseCode="400", description="the REST management service received a BundleException when trying to update", content={@Content(mediaType="application/org.osgi.bundleexception+json", schema=@Schema(implementation=BundleExceptionSchema.class)), @Content(mediaType="application/org.osgi.bundleexception+xml", schema=@Schema(implementation=BundleExceptionSchema.class))}), @ApiResponse(responseCode="404", description="The REST management service does not support any of the requested representations")})
    public Response bundle(String location, @PathParam(value="bundleid") long bundleid, @Parameter(allowEmptyValue=true, description="File extension", schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext, @HeaderParam(value="Content-Type") MediaType contentType) {
        try {
            Bundle bundle = this.bundleContext.getBundle(bundleid);
            if (bundle == null) {
                throw new WebApplicationException(String.valueOf(bundleid), 404);
            }
            if (location != null && !location.isEmpty()) {
                bundle.update(new URL(location).openStream());
            } else {
                bundle.update();
            }
            Response.ResponseBuilder builder = Response.ok((Object)((Object)this.bundleSchema(bundle)));
            return Optional.ofNullable(ext).map(String::trim).map(e -> ".json".equals(e) ? "application/org.osgi.bundle+json" : "application/org.osgi.bundle+xml").map(type -> builder.type(type)).orElse(builder).build();
        }
        catch (BundleException exception) {
            return Response.status((int)400).type(contentType.equals((Object)RestManagementConstants.APPLICATION_BUNDLE_JSON_TYPE) ? RestManagementConstants.APPLICATION_BUNDLEEXCEPTION_JSON_TYPE : RestManagementConstants.APPLICATION_BUNDLEEXCEPTION_XML_TYPE).entity((Object)BundleExceptionSchema.build(exception.getType(), exception.getMessage())).build();
        }
        catch (Exception e2) {
            throw new WebApplicationException((Throwable)e2, 400);
        }
    }

    @PUT
    @Consumes(value={"application/vnd.osgi.bundle"})
    @Produces(value={"application/org.osgi.bundle+json", "application/org.osgi.bundle+xml"})
    @Path(value="framework/bundle/{bundleid}{ext:(\\.json|\\.xml)*}")
    @Operation(hidden=true)
    public Response putBundle(InputStream inputStream, @PathParam(value="bundleid") long bundleid, @Parameter(allowEmptyValue=true, description="File extension", schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext, @HeaderParam(value="Content-Type") MediaType contentType) {
        try {
            Bundle bundle = this.bundleContext.getBundle(bundleid);
            if (bundle == null) {
                throw new WebApplicationException(String.valueOf(bundleid), 404);
            }
            bundle.update(inputStream);
            Response.ResponseBuilder builder = Response.ok((Object)((Object)this.bundleSchema(bundle)));
            return Optional.ofNullable(ext).map(String::trim).map(e -> ".json".equals(e) ? "application/org.osgi.bundle+json" : "application/org.osgi.bundle+xml").map(type -> builder.type(type)).orElse(builder).build();
        }
        catch (BundleException exception) {
            return Response.status((int)400).type(contentType.equals((Object)RestManagementConstants.APPLICATION_BUNDLE_JSON_TYPE) ? RestManagementConstants.APPLICATION_BUNDLEEXCEPTION_JSON_TYPE : RestManagementConstants.APPLICATION_BUNDLEEXCEPTION_XML_TYPE).entity((Object)BundleExceptionSchema.build(exception.getType(), exception.getMessage())).build();
        }
    }

    @DELETE
    @Produces(value={"application/org.osgi.bundle+json", "application/org.osgi.bundle+xml"})
    @Path(value="framework/bundle/{bundleid}{ext:(\\.json|\\.xml)*}")
    @Operation(operationId="DELETE/bundle", summary="Uninstalls the bundle from the framework", responses={@ApiResponse(responseCode="204", description="The request was received and valid and the framework has uninstalled the bundle", content={@Content(schema=@Schema(implementation=BundleSchema.class))}), @ApiResponse(responseCode="400", description="The REST management service received a BundleException when trying to uninstall", content={@Content(mediaType="application/org.osgi.bundleexception+json", schema=@Schema(implementation=BundleExceptionSchema.class)), @Content(mediaType="application/org.osgi.bundleexception+xml", schema=@Schema(implementation=BundleExceptionSchema.class))}), @ApiResponse(responseCode="404", description="There is no bundle with the given bundle id")})
    public Response deleteBundle(@PathParam(value="bundleid") long bundleid, @Parameter(allowEmptyValue=true, description="File extension", schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext, @HeaderParam(value="Content-Type") MediaType contentType) {
        try {
            Bundle bundle = this.bundleContext.getBundle(bundleid);
            if (bundle == null) {
                throw new WebApplicationException(String.valueOf(bundleid), 404);
            }
            bundle.uninstall();
            Response.ResponseBuilder builder = Response.ok((Object)((Object)this.bundleSchema(bundle)));
            return Optional.ofNullable(ext).map(String::trim).map(e -> ".json".equals(e) ? "application/org.osgi.bundle+json" : "application/org.osgi.bundle+xml").map(type -> builder.type(type)).orElse(builder).build();
        }
        catch (BundleException exception) {
            return Response.status((int)400).type(contentType.equals((Object)RestManagementConstants.APPLICATION_BUNDLE_JSON_TYPE) ? RestManagementConstants.APPLICATION_BUNDLEEXCEPTION_JSON_TYPE : RestManagementConstants.APPLICATION_BUNDLEEXCEPTION_XML_TYPE).entity((Object)BundleExceptionSchema.build(exception.getType(), exception.getMessage())).build();
        }
        catch (Exception exception) {
            throw new WebApplicationException((Throwable)exception, 400);
        }
    }
}

