/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.osgi.resource.Resource;

public class ResourceReferences {
    private final Map<Resource, Set<BasicSubsystem>> resourceToSubsystems = new HashMap<Resource, Set<BasicSubsystem>>();
    private final Map<BasicSubsystem, Set<Resource>> subsystemToResources = new HashMap<BasicSubsystem, Set<Resource>>();

    public synchronized void addReference(BasicSubsystem subsystem, Resource resource) {
        this.addSubsystemToResource(subsystem, resource);
        this.addResourceToSubsystem(subsystem, resource);
    }

    public synchronized Collection<Resource> getResources(BasicSubsystem subsystem) {
        List result = (List)((Object)this.subsystemToResources.get(subsystem));
        if (result == null) {
            result = Collections.emptyList();
        }
        return Collections.unmodifiableCollection(new ArrayList(result));
    }

    public synchronized Collection<BasicSubsystem> getSubsystems(Resource resource) {
        List result = (List)((Object)this.resourceToSubsystems.get(resource));
        if (result == null) {
            result = Collections.emptyList();
        }
        return Collections.unmodifiableCollection(new ArrayList(result));
    }

    public synchronized void removeReference(BasicSubsystem subsystem, Resource resource) {
        this.removeResourceToSubsystem(subsystem, resource);
        this.removeSubsystemToResource(subsystem, resource);
    }

    private void addResourceToSubsystem(BasicSubsystem subsystem, Resource resource) {
        Set<BasicSubsystem> subsystems = this.resourceToSubsystems.get(resource);
        if (subsystems == null) {
            subsystems = new HashSet<BasicSubsystem>();
            this.resourceToSubsystems.put(resource, subsystems);
        }
        subsystems.add(subsystem);
    }

    private void addSubsystemToResource(BasicSubsystem subsystem, Resource resource) {
        Set<Resource> resources = this.subsystemToResources.get(subsystem);
        if (resources == null) {
            resources = new HashSet<Resource>();
            this.subsystemToResources.put(subsystem, resources);
        }
        resources.add(resource);
    }

    private void removeResourceToSubsystem(BasicSubsystem subsystem, Resource resource) {
        Set<BasicSubsystem> subsystems = this.resourceToSubsystems.get(resource);
        if (subsystems == null) {
            return;
        }
        subsystems.remove(subsystem);
        if (subsystems.isEmpty()) {
            this.resourceToSubsystems.remove(resource);
        }
    }

    private void removeSubsystemToResource(BasicSubsystem subsystem, Resource resource) {
        Set<Resource> resources = this.subsystemToResources.get(subsystem);
        if (resources == null) {
            return;
        }
        resources.remove(resource);
        if (resources.isEmpty()) {
            this.subsystemToResources.remove(subsystem);
        }
    }
}

