/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jdbc.internal;

import java.util.Hashtable;
import javax.sql.CommonDataSource;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.transaction.AriesTransactionManager;
import org.apache.aries.transaction.jdbc.internal.ManagedDataSourceFactory;
import org.apache.aries.util.tracker.SingleServiceTracker;
import org.apache.xbean.blueprint.context.impl.XBeanNamespaceHandler;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer<CommonDataSource, ManagedDataSourceFactory>,
SingleServiceTracker.SingleServiceListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private ServiceTracker<CommonDataSource, ManagedDataSourceFactory> t;
    private SingleServiceTracker<AriesTransactionManager> tm;
    private BundleContext context;
    private ServiceRegistration[] nshReg;

    public void start(BundleContext ctx) {
        Filter filter;
        this.context = ctx;
        try {
            this.nshReg = JdbcNamespaceHandler.register(ctx);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn("Unable to register JDBC blueprint namespace handler (xbean-blueprint not available).");
        }
        catch (Exception e) {
            LOGGER.error("Unable to register JDBC blueprint namespace handler", (Throwable)e);
        }
        String flt = "(&(|(objectClass=javax.sql.XADataSource)(objectClass=javax.sql.DataSource))(!(aries.managed=true)))";
        try {
            filter = this.context.createFilter(flt);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
        this.t = new ServiceTracker(ctx, filter, (ServiceTrackerCustomizer)this);
        this.tm = new SingleServiceTracker(ctx, AriesTransactionManager.class, (SingleServiceTracker.SingleServiceListener)this);
        this.tm.open();
    }

    public void stop(BundleContext ctx) {
        this.tm.close();
        this.t.close();
        if (this.nshReg != null) {
            for (ServiceRegistration reg : this.nshReg) {
                Activator.safeUnregisterService(reg);
            }
        }
    }

    public ManagedDataSourceFactory addingService(ServiceReference<CommonDataSource> ref) {
        try {
            LOGGER.info("Wrapping DataSource " + ref);
            ManagedDataSourceFactory mdsf = new ManagedDataSourceFactory(ref, (AriesTransactionManager)this.tm.getService());
            mdsf.register();
            return mdsf;
        }
        catch (Exception e) {
            LOGGER.warn("Error wrapping DataSource " + ref, (Throwable)e);
            return null;
        }
    }

    public void modifiedService(ServiceReference<CommonDataSource> ref, ManagedDataSourceFactory service) {
        try {
            service.unregister();
        }
        catch (Exception e) {
            LOGGER.warn("Error closing DataSource " + ref, (Throwable)e);
        }
        try {
            service.register();
        }
        catch (Exception e) {
            LOGGER.warn("Error wrapping DataSource " + ref, (Throwable)e);
        }
    }

    public void removedService(ServiceReference<CommonDataSource> ref, ManagedDataSourceFactory service) {
        try {
            service.unregister();
        }
        catch (Exception e) {
            LOGGER.warn("Error closing DataSource " + ref, (Throwable)e);
        }
    }

    static void safeUnregisterService(ServiceRegistration reg) {
        if (reg != null) {
            try {
                reg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void serviceFound() {
        this.t.open();
    }

    public void serviceLost() {
        this.t.close();
    }

    public void serviceReplaced() {
        this.t.close();
        this.t.open();
    }

    static class JdbcNamespaceHandler {
        JdbcNamespaceHandler() {
        }

        public static ServiceRegistration[] register(BundleContext context) throws Exception {
            XBeanNamespaceHandler nsh20 = new XBeanNamespaceHandler("http://aries.apache.org/xmlns/transaction-jdbc/2.0", "org.apache.aries.transaction.jdbc-2.0.xsd", context.getBundle(), "META-INF/services/org/apache/xbean/spring/http/aries.apache.org/xmlns/transaction-jdbc/2.0");
            Hashtable<String, String> props20 = new Hashtable<String, String>();
            props20.put("osgi.service.blueprint.namespace", "http://aries.apache.org/xmlns/transaction-jdbc/2.0");
            ServiceRegistration reg20 = context.registerService(NamespaceHandler.class.getName(), (Object)nsh20, props20);
            XBeanNamespaceHandler nsh21 = new XBeanNamespaceHandler("http://aries.apache.org/xmlns/transaction-jdbc/2.1", "org.apache.aries.transaction.jdbc.xsd", context.getBundle(), "META-INF/services/org/apache/xbean/spring/http/aries.apache.org/xmlns/transaction-jdbc/2.1");
            Hashtable<String, String> props21 = new Hashtable<String, String>();
            props21.put("osgi.service.blueprint.namespace", "http://aries.apache.org/xmlns/transaction-jdbc/2.1");
            ServiceRegistration reg21 = context.registerService(NamespaceHandler.class.getName(), (Object)nsh21, props21);
            return new ServiceRegistration[]{reg20, reg21};
        }
    }
}

