/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.Map;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.IoOperationCompleteListener;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.util.trace.ITracer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class TracedIOOperation
implements ILSMIOOperation {
    static final Logger LOGGER = LogManager.getLogger();
    protected final ILSMIOOperation ioOp;
    private final ILSMIOOperation.LSMIOOperationType ioOpType;
    private final ITracer tracer;
    private final long traceCategory;

    protected TracedIOOperation(ILSMIOOperation ioOp, ITracer tracer, long traceCategory) {
        this.ioOp = ioOp;
        this.tracer = tracer;
        this.ioOpType = ioOp.getIOOpertionType();
        this.traceCategory = traceCategory;
    }

    public static ILSMIOOperation wrap(ILSMIOOperation ioOp, ITracer tracer) {
        String ioOpName = ioOp.getIOOpertionType().name().toLowerCase();
        long traceCategory = tracer.getRegistry().get("IndexIoOperations");
        if (tracer.isEnabled(traceCategory)) {
            tracer.instant("schedule-" + ioOpName, traceCategory, ITracer.Scope.p, "{\"path\": \"" + ioOp.getTarget().getRelativePath() + "\"}");
            return new TracedIOOperation(ioOp, tracer, traceCategory);
        }
        return ioOp;
    }

    protected ILSMIOOperation getIoOp() {
        return this.ioOp;
    }

    @Override
    public IODeviceHandle getDevice() {
        return this.ioOp.getDevice();
    }

    @Override
    public ILSMIOOperationCallback getCallback() {
        return this.ioOp.getCallback();
    }

    @Override
    public String getIndexIdentifier() {
        return this.ioOp.getIndexIdentifier();
    }

    @Override
    public ILSMIOOperation.LSMIOOperationType getIOOpertionType() {
        return this.ioOpType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILSMIOOperation.LSMIOOperationStatus call() throws HyracksDataException {
        String name = this.getTarget().getRelativePath();
        long tid = this.tracer.durationB(name, this.traceCategory, null);
        try {
            ILSMIOOperation.LSMIOOperationStatus lSMIOOperationStatus = this.ioOp.call();
            return lSMIOOperationStatus;
        }
        finally {
            this.tracer.durationE(this.ioOp.getIOOpertionType().name().toLowerCase(), this.traceCategory, tid, "{\"size\":" + this.getTarget().getFile().length() + ", \"path\": \"" + this.ioOp.getTarget().getRelativePath() + "\"}");
        }
    }

    @Override
    public FileReference getTarget() {
        return this.ioOp.getTarget();
    }

    @Override
    public ILSMIndexAccessor getAccessor() {
        return this.ioOp.getAccessor();
    }

    @Override
    public void cleanup(IBufferCache bufferCache) {
        this.ioOp.cleanup(bufferCache);
    }

    @Override
    public Throwable getFailure() {
        return this.ioOp.getFailure();
    }

    @Override
    public void setFailure(Throwable failure) {
        this.ioOp.setFailure(failure);
    }

    @Override
    public ILSMIOOperation.LSMIOOperationStatus getStatus() {
        return this.ioOp.getStatus();
    }

    @Override
    public void setStatus(ILSMIOOperation.LSMIOOperationStatus status) {
        this.ioOp.setStatus(status);
    }

    @Override
    public ILSMDiskComponent getNewComponent() {
        return this.ioOp.getNewComponent();
    }

    @Override
    public void setNewComponent(ILSMDiskComponent component) {
        this.ioOp.setNewComponent(component);
    }

    @Override
    public void complete() {
        this.ioOp.complete();
    }

    @Override
    public void sync() throws InterruptedException {
        this.ioOp.sync();
    }

    @Override
    public void addCompleteListener(IoOperationCompleteListener listener) {
        this.ioOp.addCompleteListener(listener);
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.ioOp.getParameters();
    }

    public void writeFailed(ICachedPage page, Throwable failure) {
        this.ioOp.writeFailed(page, failure);
    }

    public boolean hasFailed() {
        return this.ioOp.hasFailed();
    }

    @Override
    public long getRemainingPages() {
        return this.ioOp.getRemainingPages();
    }

    @Override
    public void resume() {
        this.ioOp.resume();
    }

    @Override
    public void pause() {
        this.ioOp.pause();
    }

    @Override
    public boolean isActive() {
        return this.ioOp.isActive();
    }

    @Override
    public boolean isCompleted() {
        return this.ioOp.isCompleted();
    }
}

