/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.row.generator;

import com.teradata.tpcds.BusinessKeyGenerator;
import com.teradata.tpcds.Nulls;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.distribution.HoursDistribution;
import com.teradata.tpcds.generator.TimeDimGeneratorColumn;
import com.teradata.tpcds.row.TimeDimRow;
import com.teradata.tpcds.row.generator.AbstractRowGenerator;
import com.teradata.tpcds.row.generator.RowGenerator;
import com.teradata.tpcds.row.generator.RowGeneratorResult;

public class TimeDimRowGenerator
extends AbstractRowGenerator {
    public TimeDimRowGenerator() {
        super(Table.TIME_DIM);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long nullBitMap = Nulls.createNullBitMap(Table.TIME_DIM, this.getRandomNumberStream(TimeDimGeneratorColumn.T_NULLS));
        long tTimeSk = rowNumber - 1L;
        String tTimeId = BusinessKeyGenerator.makeBusinessKey(rowNumber);
        int tTime = (int)(rowNumber - 1L);
        long timeTemp = tTime;
        int tSecond = (int)(timeTemp % 60L);
        int tMinute = (int)((timeTemp /= 60L) % 60L);
        int tHour = (int)((timeTemp /= 60L) % 24L);
        HoursDistribution.HourInfo hourInfo = HoursDistribution.getHourInfoForHour(tHour);
        String tAmPm = hourInfo.getAmPm();
        String tShift = hourInfo.getShift();
        String tSubShift = hourInfo.getSubShift();
        String tMealTime = hourInfo.getMeal();
        return new RowGeneratorResult(new TimeDimRow(nullBitMap, tTimeSk, tTimeId, tTime, tHour, tMinute, tSecond, tAmPm, tShift, tSubShift, tMealTime));
    }
}

