/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.functions;

import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;

public class AlgebricksBuiltinFunctions {
    public static final String ALGEBRICKS_NS = "algebricks";
    public static final FunctionIdentifier EQ = new FunctionIdentifier("algebricks", "eq", 2);
    public static final FunctionIdentifier LE = new FunctionIdentifier("algebricks", "le", 2);
    public static final FunctionIdentifier GE = new FunctionIdentifier("algebricks", "ge", 2);
    public static final FunctionIdentifier LT = new FunctionIdentifier("algebricks", "lt", 2);
    public static final FunctionIdentifier GT = new FunctionIdentifier("algebricks", "gt", 2);
    public static final FunctionIdentifier NEQ = new FunctionIdentifier("algebricks", "neq", 2);
    public static final FunctionIdentifier NOT = new FunctionIdentifier("algebricks", "not", 1);
    public static final FunctionIdentifier AND = new FunctionIdentifier("algebricks", "and", -1);
    public static final FunctionIdentifier OR = new FunctionIdentifier("algebricks", "or", -1);
    public static final FunctionIdentifier NUMERIC_ADD = new FunctionIdentifier("algebricks", "numeric-add", 2);
    public static final FunctionIdentifier IS_MISSING = new FunctionIdentifier("algebricks", "is-missing", 1);
    public static final FunctionIdentifier IS_NULL = new FunctionIdentifier("algebricks", "is-null", 1);
    private static final Map<FunctionIdentifier, ComparisonKind> comparisonFunctions = new HashMap<FunctionIdentifier, ComparisonKind>();

    public static ComparisonKind getComparisonType(FunctionIdentifier fi) {
        return comparisonFunctions.get(fi);
    }

    public static boolean isComparisonFunction(FunctionIdentifier fi) {
        return comparisonFunctions.get(fi) != null;
    }

    static {
        comparisonFunctions.put(EQ, ComparisonKind.EQ);
        comparisonFunctions.put(LE, ComparisonKind.LE);
        comparisonFunctions.put(GE, ComparisonKind.GE);
        comparisonFunctions.put(LT, ComparisonKind.LT);
        comparisonFunctions.put(GT, ComparisonKind.GT);
        comparisonFunctions.put(NEQ, ComparisonKind.NEQ);
    }

    public static enum ComparisonKind {
        EQ,
        LE,
        GE,
        LT,
        GT,
        NEQ;

    }
}

