/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.result;

import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.partitions.ResultSetPartitionId;
import org.apache.hyracks.comm.channels.NetworkOutputChannel;
import org.apache.hyracks.control.nc.result.ResultMemoryManager;
import org.apache.hyracks.control.nc.result.ResultPartitionManager;
import org.apache.hyracks.control.nc.result.ResultState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultPartitionReader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ResultPartitionManager resultPartitionManager;
    private final ResultMemoryManager resultMemoryManager;
    private final Executor executor;
    private final ResultState resultState;

    public ResultPartitionReader(ResultPartitionManager resultPartitionManager, ResultMemoryManager resultMemoryManager, Executor executor, ResultState resultState) {
        this.resultPartitionManager = resultPartitionManager;
        this.resultMemoryManager = resultMemoryManager;
        this.executor = executor;
        this.resultState = resultState;
    }

    public void writeTo(IFrameWriter writer) {
        this.executor.execute(new ResultPartitionSender((NetworkOutputChannel)writer));
    }

    private class ResultPartitionSender
    implements Runnable {
        private final NetworkOutputChannel channel;

        ResultPartitionSender(NetworkOutputChannel channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.channel.setFrameSize(ResultPartitionReader.this.resultState.getFrameSize());
            this.channel.open();
            try {
                ResultPartitionReader.this.resultState.readOpen();
                long offset = 0L;
                ByteBuffer buffer = ByteBuffer.allocate(ResultPartitionReader.this.resultState.getFrameSize());
                while (true) {
                    buffer.clear();
                    long size = this.read(offset, buffer);
                    if (size <= 0L) break;
                    if (size < (long)buffer.limit()) {
                        throw new IllegalStateException("Premature end of file - readSize: " + size + " buffer limit: " + buffer.limit());
                    }
                    offset += size;
                    buffer.flip();
                    this.channel.nextFrame(buffer);
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("result reading successful(" + ResultPartitionReader.this.resultState.getResultSetPartitionId() + ")");
                }
            }
            catch (Exception e) {
                LOGGER.error(() -> "failed to send result partition " + ResultPartitionReader.this.resultState.getResultSetPartitionId(), (Throwable)e);
                this.channel.abort(1);
            }
            finally {
                this.close();
            }
        }

        private long read(long offset, ByteBuffer buffer) throws HyracksDataException {
            return ResultPartitionReader.this.resultMemoryManager != null ? ResultPartitionReader.this.resultState.read(ResultPartitionReader.this.resultMemoryManager, offset, buffer) : ResultPartitionReader.this.resultState.read(offset, buffer);
        }

        private void close() {
            try {
                this.channel.close();
                ResultPartitionReader.this.resultState.readClose();
                if (ResultPartitionReader.this.resultState.isExhausted()) {
                    ResultSetPartitionId partitionId = ResultPartitionReader.this.resultState.getResultSetPartitionId();
                    ResultPartitionReader.this.resultPartitionManager.removePartition(partitionId.getJobId(), partitionId.getResultSetId(), partitionId.getPartition());
                }
            }
            catch (HyracksDataException e) {
                LOGGER.error("unexpected failure in partition reader clean up", (Throwable)e);
            }
        }
    }
}

