/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.task;

import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeartbeatAckTask
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NodeControllerService ncs;
    private final CcId ccId;
    private final HyracksDataException exception;

    public HeartbeatAckTask(NodeControllerService ncs, CcId ccId, HyracksDataException exception) {
        this.ncs = ncs;
        this.ccId = ccId;
        this.exception = exception;
    }

    @Override
    public void run() {
        try {
            this.ncs.getHeartbeatManager(this.ccId).notifyAck(this.exception);
        }
        catch (Exception e) {
            LOGGER.info("failure processing heartbeat ack from {}", (Object)this.ccId, (Object)e);
        }
    }
}

