/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.client.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.client.impl.ActivityClusterGraphBuilder;
import org.apache.hyracks.api.client.impl.IConnectorDescriptorVisitor;
import org.apache.hyracks.api.client.impl.IOperatorDescriptorVisitor;
import org.apache.hyracks.api.client.impl.JobActivityGraphBuilder;
import org.apache.hyracks.api.client.impl.PlanUtils;
import org.apache.hyracks.api.constraints.Constraint;
import org.apache.hyracks.api.constraints.IConstraintAcceptor;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.IActivityClusterGraphGenerator;
import org.apache.hyracks.api.job.IActivityClusterGraphGeneratorFactory;
import org.apache.hyracks.api.job.JobActivityGraph;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.rewriter.ActivityClusterGraphRewriter;

public class JobSpecificationActivityClusterGraphGeneratorFactory
implements IActivityClusterGraphGeneratorFactory {
    private static final long serialVersionUID = 1L;
    private final JobSpecification spec;

    public JobSpecificationActivityClusterGraphGeneratorFactory(JobSpecification jobSpec) {
        this.spec = jobSpec;
    }

    @Override
    public JobSpecification getJobSpecification() {
        return this.spec;
    }

    @Override
    public IActivityClusterGraphGenerator createActivityClusterGraphGenerator(final ICCServiceContext ccServiceCtx, Set<JobFlag> jobFlags) throws HyracksException {
        final JobActivityGraphBuilder builder = new JobActivityGraphBuilder(this.spec, jobFlags);
        PlanUtils.visit(this.spec, builder::addConnector);
        PlanUtils.visit(this.spec, new IOperatorDescriptorVisitor(){

            @Override
            public void visit(IOperatorDescriptor op) {
                op.contributeActivities(builder);
            }
        });
        builder.finish();
        JobActivityGraph jag = builder.getActivityGraph();
        ActivityClusterGraphBuilder acgb = new ActivityClusterGraphBuilder();
        final ActivityClusterGraph acg = acgb.inferActivityClusters(jag);
        acg.setFrameSize(this.spec.getFrameSize());
        acg.setMaxReattempts(this.spec.getMaxReattempts());
        acg.setMaxWarnings(this.spec.getMaxWarnings());
        acg.setJobletEventListenerFactory(this.spec.getJobletEventListenerFactory());
        acg.setGlobalJobDataFactory(this.spec.getGlobalJobDataFactory());
        acg.setConnectorPolicyAssignmentPolicy(this.spec.getConnectorPolicyAssignmentPolicy());
        acg.setUseConnectorPolicyForScheduling(this.spec.isUseConnectorPolicyForScheduling());
        final HashSet<Constraint> constraints = new HashSet<Constraint>();
        final IConstraintAcceptor acceptor = constraints::add;
        PlanUtils.visit(this.spec, new IOperatorDescriptorVisitor(){

            @Override
            public void visit(IOperatorDescriptor op) {
                op.contributeSchedulingConstraints(acceptor, ccServiceCtx);
            }
        });
        PlanUtils.visit(this.spec, new IConnectorDescriptorVisitor(){

            @Override
            public void visit(IConnectorDescriptor conn) {
                conn.contributeSchedulingConstraints(acceptor, acg.getConnectorMap().get(conn.getConnectorId()), ccServiceCtx);
            }
        });
        constraints.addAll(this.spec.getUserConstraints());
        return new IActivityClusterGraphGenerator(){

            @Override
            public ActivityClusterGraph initialize() {
                ActivityClusterGraphRewriter rewriter = new ActivityClusterGraphRewriter();
                rewriter.rewrite(acg);
                return acg;
            }

            @Override
            public Set<Constraint> getConstraints() {
                return constraints;
            }
        };
    }
}

