/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.misc;

import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOpenableDataWriter;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.IOpenableDataWriterOperator;
import org.apache.hyracks.dataflow.std.util.DeserializedOperatorNodePushable;
import org.apache.hyracks.dataflow.std.util.StringSerializationUtils;

public class PrinterOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;

    public PrinterOperatorDescriptor(IOperatorDescriptorRegistry spec) {
        super(spec, 1, 0);
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
        return new DeserializedOperatorNodePushable(ctx, new PrinterOperator(), recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0));
    }

    private class PrinterOperator
    implements IOpenableDataWriterOperator {
        private PrinterOperator() {
        }

        public void open() throws HyracksDataException {
        }

        public void close() throws HyracksDataException {
        }

        public void fail() throws HyracksDataException {
        }

        public void writeData(Object[] data) throws HyracksDataException {
            for (int i = 0; i < data.length; ++i) {
                System.err.print(StringSerializationUtils.toString(data[i]));
                System.err.print(", ");
            }
            System.err.println();
        }

        @Override
        public void setDataWriter(int index, IOpenableDataWriter<Object[]> writer) {
            throw new IllegalArgumentException();
        }

        public void flush() throws HyracksDataException {
            System.err.flush();
        }
    }
}

