/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.structures;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.buffermanager.ISimpleFrameBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.ITuplePointerAccessor;
import org.apache.hyracks.dataflow.std.structures.SimpleSerializableHashTable;
import org.apache.hyracks.dataflow.std.structures.TuplePointer;

public class SerializableHashTable
extends SimpleSerializableHashTable {
    protected double garbageCollectionThreshold;
    protected int wastedIntSpaceCount = 0;
    protected ISimpleFrameBufferManager bufferManager;

    public SerializableHashTable(int tableSize, IHyracksFrameMgrContext ctx, ISimpleFrameBufferManager bufferManager) throws HyracksDataException {
        this(tableSize, ctx, bufferManager, 0.1);
    }

    public SerializableHashTable(int tableSize, IHyracksFrameMgrContext ctx, ISimpleFrameBufferManager bufferManager, double garbageCollectionThreshold) throws HyracksDataException {
        super(tableSize, ctx, false);
        this.bufferManager = bufferManager;
        if (tableSize > 0) {
            ByteBuffer newFrame = this.getFrame(this.frameSize);
            if (newFrame == null) {
                throw new HyracksDataException("Can't allocate a frame for Hash Table. Please allocate more budget.");
            }
            SimpleSerializableHashTable.IntSerDeBuffer frame = new SimpleSerializableHashTable.IntSerDeBuffer(newFrame);
            this.frameCapacity = frame.capacity();
            this.contents.add(frame);
            this.currentOffsetInEachFrameList.add(0);
        }
        this.garbageCollectionThreshold = garbageCollectionThreshold;
    }

    @Override
    ByteBuffer getFrame(int size) throws HyracksDataException {
        ByteBuffer newFrame = this.bufferManager.acquireFrame(size);
        if (newFrame != null) {
            this.currentByteSize += size;
        }
        return newFrame;
    }

    @Override
    void increaseWastedSpaceCount(int size) {
        this.wastedIntSpaceCount += size;
    }

    @Override
    public void reset() {
        super.reset();
        this.currentByteSize = 0;
    }

    @Override
    public void close() {
        int i;
        for (i = 0; i < this.headers.length; ++i) {
            if (this.headers[i] == null) continue;
            this.bufferManager.releaseFrame(this.headers[i].getByteBuffer());
            this.headers[i] = null;
        }
        for (i = 0; i < this.contents.size(); ++i) {
            this.bufferManager.releaseFrame(((SimpleSerializableHashTable.IntSerDeBuffer)this.contents.get(i)).getByteBuffer());
        }
        this.contents.clear();
        this.currentOffsetInEachFrameList.clear();
        this.tupleCount = 0;
        this.currentByteSize = 0;
        this.currentLargestFrameNumber = 0;
    }

    @Override
    public boolean isGarbageCollectionNeeded() {
        return (double)this.wastedIntSpaceCount > (double)(this.frameCapacity * (this.currentLargestFrameNumber + 1)) * this.garbageCollectionThreshold;
    }

    @Override
    public int collectGarbage(ITuplePointerAccessor bufferAccessor, ITuplePartitionComputer tpc) throws HyracksDataException {
        int numberOfFramesToBeDeallocated;
        GarbageCollectionInfo gcInfo = new GarbageCollectionInfo();
        SimpleSerializableHashTable.IntSerDeBuffer currentWriteContentFrameForGC = (SimpleSerializableHashTable.IntSerDeBuffer)this.contents.get(gcInfo.currentGCWritePageForGC);
        int lastOffsetInLastFrame = (Integer)this.currentOffsetInEachFrameList.get(this.contents.size() - 1);
        while (gcInfo.currentReadPageForGC <= this.currentLargestFrameNumber) {
            int nextSlotIntPosInPageForGC;
            gcInfo.currentReadIntOffsetInPageForGC = 0;
            SimpleSerializableHashTable.IntSerDeBuffer currentReadContentFrameForGC = (SimpleSerializableHashTable.IntSerDeBuffer)this.contents.get(gcInfo.currentReadPageForGC);
            while (gcInfo.currentReadIntOffsetInPageForGC < this.frameCapacity && (nextSlotIntPosInPageForGC = this.findNextSlotInPage(currentReadContentFrameForGC, gcInfo.currentReadIntOffsetInPageForGC)) != -1) {
                boolean currentPageChanged;
                int slotCapacity = currentReadContentFrameForGC.getInt(nextSlotIntPosInPageForGC);
                int slotUsedCount = currentReadContentFrameForGC.getInt(nextSlotIntPosInPageForGC + 1);
                int capacityInIntCount = (slotCapacity + 1) * 2;
                if (slotUsedCount != -1) {
                    this.tempTuplePointer.reset(currentReadContentFrameForGC.getInt(nextSlotIntPosInPageForGC + 2), currentReadContentFrameForGC.getInt(nextSlotIntPosInPageForGC + 3));
                    if (gcInfo.currentWriteIntOffsetInPageForGC + 4 > this.frameCapacity && gcInfo.currentGCWritePageForGC < this.currentLargestFrameNumber) {
                        currentWriteContentFrameForGC.writeInvalidVal(gcInfo.currentWriteIntOffsetInPageForGC, this.frameCapacity - gcInfo.currentWriteIntOffsetInPageForGC);
                        ++gcInfo.currentGCWritePageForGC;
                        currentWriteContentFrameForGC = (SimpleSerializableHashTable.IntSerDeBuffer)this.contents.get(gcInfo.currentGCWritePageForGC);
                        gcInfo.currentWriteIntOffsetInPageForGC = 0;
                    }
                    if (!(currentPageChanged = this.MigrateSlot(gcInfo, bufferAccessor, tpc, capacityInIntCount, nextSlotIntPosInPageForGC))) continue;
                    currentReadContentFrameForGC = (SimpleSerializableHashTable.IntSerDeBuffer)this.contents.get(gcInfo.currentReadPageForGC);
                    currentWriteContentFrameForGC = (SimpleSerializableHashTable.IntSerDeBuffer)this.contents.get(gcInfo.currentGCWritePageForGC);
                    continue;
                }
                currentPageChanged = this.resetSlotSpace(gcInfo, nextSlotIntPosInPageForGC, capacityInIntCount);
                if (!currentPageChanged) continue;
                currentReadContentFrameForGC = (SimpleSerializableHashTable.IntSerDeBuffer)this.contents.get(gcInfo.currentReadPageForGC);
            }
            if (gcInfo.currentReadPageForGC == this.currentLargestFrameNumber) break;
            ++gcInfo.currentReadPageForGC;
        }
        int extraFrames = 0;
        if (this.contents.size() > this.currentLargestFrameNumber + 1) {
            extraFrames = this.contents.size() - (this.currentLargestFrameNumber + 1);
        }
        if ((numberOfFramesToBeDeallocated = gcInfo.currentReadPageForGC + extraFrames - gcInfo.currentGCWritePageForGC) >= 1) {
            for (int i = 0; i < numberOfFramesToBeDeallocated; ++i) {
                this.currentByteSize -= ((SimpleSerializableHashTable.IntSerDeBuffer)this.contents.get(gcInfo.currentGCWritePageForGC + 1)).getByteCapacity();
                this.bufferManager.releaseFrame(((SimpleSerializableHashTable.IntSerDeBuffer)this.contents.get(gcInfo.currentGCWritePageForGC + 1)).getByteBuffer());
                this.contents.remove(gcInfo.currentGCWritePageForGC + 1);
                this.currentOffsetInEachFrameList.remove(gcInfo.currentGCWritePageForGC + 1);
            }
        } else {
            int afterLastOffsetInLastFrame = (Integer)this.currentOffsetInEachFrameList.get(gcInfo.currentGCWritePageForGC);
            if (lastOffsetInLastFrame == afterLastOffsetInLastFrame) {
                numberOfFramesToBeDeallocated = -1;
            }
        }
        this.currentLargestFrameNumber = gcInfo.currentGCWritePageForGC;
        this.currentOffsetInEachFrameList.set(gcInfo.currentGCWritePageForGC, gcInfo.currentWriteIntOffsetInPageForGC);
        this.wastedIntSpaceCount = 0;
        this.tempTuplePointer.reset(-1, -1);
        return numberOfFramesToBeDeallocated;
    }

    private boolean MigrateSlot(GarbageCollectionInfo gcInfo, ITuplePointerAccessor bufferAccessor, ITuplePartitionComputer tpc, int capacityInIntCount, int nextSlotIntPosInPageForGC) throws HyracksDataException {
        int chunksToMoveAtThisTime;
        boolean currentPageChanged = false;
        if (gcInfo.isReaderWriterAtTheSamePos()) {
            int intReadAtThisTime;
            gcInfo.currentReadIntOffsetInPageForGC = nextSlotIntPosInPageForGC;
            for (int intToRead = capacityInIntCount; intToRead > 0; intToRead -= intReadAtThisTime) {
                intReadAtThisTime = Math.min(intToRead, this.frameCapacity - gcInfo.currentReadIntOffsetInPageForGC);
                gcInfo.currentReadIntOffsetInPageForGC += intReadAtThisTime;
                if (gcInfo.currentReadIntOffsetInPageForGC < this.frameCapacity || gcInfo.currentReadPageForGC >= this.currentLargestFrameNumber) continue;
                ++gcInfo.currentReadPageForGC;
                gcInfo.currentReadIntOffsetInPageForGC = 0;
                currentPageChanged = true;
            }
            gcInfo.currentGCWritePageForGC = gcInfo.currentReadPageForGC;
            gcInfo.currentWriteIntOffsetInPageForGC = gcInfo.currentReadIntOffsetInPageForGC;
            return currentPageChanged;
        }
        int tempWriteIntPosInPage = gcInfo.currentWriteIntOffsetInPageForGC;
        int tempReadIntPosInPage = nextSlotIntPosInPageForGC;
        int tempWritePage = gcInfo.currentGCWritePageForGC;
        SimpleSerializableHashTable.IntSerDeBuffer currentReadContentFrameForGC = (SimpleSerializableHashTable.IntSerDeBuffer)this.contents.get(gcInfo.currentReadPageForGC);
        SimpleSerializableHashTable.IntSerDeBuffer currentWriteContentFrameForGC = (SimpleSerializableHashTable.IntSerDeBuffer)this.contents.get(gcInfo.currentGCWritePageForGC);
        for (int chunksToMove = capacityInIntCount; chunksToMove > 0; chunksToMove -= chunksToMoveAtThisTime) {
            int oneTimeIntCapacityForWriter = Math.min(chunksToMove, this.frameCapacity - tempWriteIntPosInPage);
            int oneTimeIntCapacityForReader = Math.min(chunksToMove, this.frameCapacity - tempReadIntPosInPage);
            chunksToMoveAtThisTime = Math.min(oneTimeIntCapacityForWriter, oneTimeIntCapacityForReader);
            System.arraycopy(currentReadContentFrameForGC.bytes, tempReadIntPosInPage * 4, currentWriteContentFrameForGC.bytes, tempWriteIntPosInPage * 4, chunksToMoveAtThisTime * 4);
            for (int i = 0; i < chunksToMoveAtThisTime; ++i) {
                if (gcInfo.currentReadPageForGC == tempWritePage && tempReadIntPosInPage + i < tempWriteIntPosInPage + chunksToMoveAtThisTime) continue;
                currentReadContentFrameForGC.writeInvalidVal(tempReadIntPosInPage + i, chunksToMoveAtThisTime - i);
                break;
            }
            tempReadIntPosInPage += chunksToMoveAtThisTime;
            if ((tempWriteIntPosInPage += chunksToMoveAtThisTime) >= this.frameCapacity && tempWritePage < this.currentLargestFrameNumber) {
                currentPageChanged = true;
                currentWriteContentFrameForGC = (SimpleSerializableHashTable.IntSerDeBuffer)this.contents.get(++tempWritePage);
                tempWriteIntPosInPage = 0;
            }
            if (tempReadIntPosInPage < this.frameCapacity || gcInfo.currentReadPageForGC >= this.currentLargestFrameNumber) continue;
            ++gcInfo.currentReadPageForGC;
            currentPageChanged = true;
            currentReadContentFrameForGC = (SimpleSerializableHashTable.IntSerDeBuffer)this.contents.get(gcInfo.currentReadPageForGC);
            tempReadIntPosInPage = 0;
        }
        this.updateHeaderToContentPointerInHeaderFrame(bufferAccessor, tpc, this.tempTuplePointer, gcInfo.currentGCWritePageForGC, gcInfo.currentWriteIntOffsetInPageForGC);
        gcInfo.currentGCWritePageForGC = tempWritePage;
        gcInfo.currentWriteIntOffsetInPageForGC = tempWriteIntPosInPage;
        gcInfo.currentReadIntOffsetInPageForGC = tempReadIntPosInPage;
        return currentPageChanged;
    }

    private boolean resetSlotSpace(GarbageCollectionInfo gcInfo, int slotIntPos, int capacityInIntCount) {
        int chunksToDeleteAtThisTime;
        boolean currentPageChanged = false;
        int tempReadIntPosInPage = slotIntPos;
        SimpleSerializableHashTable.IntSerDeBuffer currentReadContentFrameForGC = (SimpleSerializableHashTable.IntSerDeBuffer)this.contents.get(gcInfo.currentReadPageForGC);
        for (int chunksToDelete = capacityInIntCount; chunksToDelete > 0; chunksToDelete -= chunksToDeleteAtThisTime) {
            chunksToDeleteAtThisTime = Math.min(chunksToDelete, this.frameCapacity - tempReadIntPosInPage);
            currentReadContentFrameForGC.writeInvalidVal(tempReadIntPosInPage, chunksToDeleteAtThisTime);
            if ((tempReadIntPosInPage += chunksToDeleteAtThisTime) < this.frameCapacity || gcInfo.currentReadPageForGC >= this.currentLargestFrameNumber) continue;
            ++gcInfo.currentReadPageForGC;
            currentPageChanged = true;
            currentReadContentFrameForGC = (SimpleSerializableHashTable.IntSerDeBuffer)this.contents.get(gcInfo.currentReadPageForGC);
            tempReadIntPosInPage = 0;
        }
        gcInfo.currentReadIntOffsetInPageForGC = tempReadIntPosInPage;
        return currentPageChanged;
    }

    private void updateHeaderToContentPointerInHeaderFrame(ITuplePointerAccessor bufferAccessor, ITuplePartitionComputer tpc, TuplePointer hashedTuple, int newContentFrame, int newOffsetInContentFrame) throws HyracksDataException {
        bufferAccessor.reset(hashedTuple);
        int entry = tpc.partition((IFrameTupleAccessor)bufferAccessor, hashedTuple.getTupleIndex(), this.tableSize);
        int headerFrameIndex = this.getHeaderFrameIndex(entry);
        int offsetInHeaderFrame = this.getHeaderFrameOffset(entry);
        SimpleSerializableHashTable.IntSerDeBuffer headerFrame = this.headers[headerFrameIndex];
        headerFrame.writeInt(offsetInHeaderFrame, newContentFrame);
        headerFrame.writeInt(offsetInHeaderFrame + 1, newOffsetInContentFrame);
    }

    private int findNextSlotInPage(SimpleSerializableHashTable.IntSerDeBuffer frame, int readIntPosAtPage) {
        if (readIntPosAtPage >= this.frameCapacity) {
            return -1;
        }
        int intOffset = readIntPosAtPage;
        while (frame.getInt(intOffset) == -1) {
            if (++intOffset < this.frameCapacity) continue;
            return -1;
        }
        return intOffset;
    }

    @Override
    public String printInfo() {
        SlotInfoPair<Integer, Integer> slotInfo = new SlotInfoPair<Integer, Integer>(0, 0);
        int nFrames = this.contents.size();
        int hFrames = 0;
        TreeMap<Integer, Integer> headerSlotUsedCountMap = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Integer> headerSlotCapaCountMap = new TreeMap<Integer, Integer>();
        int headerSlotUsedCount = 0;
        double headerSlotUsedRatio = 0.0;
        for (int i = 0; i < this.headers.length; ++i) {
            if (this.headers[i] == null) continue;
            SimpleSerializableHashTable.IntSerDeBuffer header = this.headers[i];
            for (int j = 0; j < this.frameCapacity; j += 2) {
                if (header.getInt(j) < 0) continue;
                ++headerSlotUsedCount;
                this.getSlotInfo(header.getInt(j), header.getInt(j + 1), slotInfo);
                int capacity = (Integer)slotInfo.first;
                int tupleUsedCount = (Integer)slotInfo.second;
                if (headerSlotUsedCountMap.containsKey(tupleUsedCount)) {
                    int tupleUsedCountFromMap = (Integer)headerSlotUsedCountMap.get(tupleUsedCount);
                    headerSlotUsedCountMap.put(tupleUsedCount, tupleUsedCountFromMap + 1);
                } else {
                    headerSlotUsedCountMap.put(tupleUsedCount, 1);
                }
                if (headerSlotCapaCountMap.containsKey(capacity)) {
                    int capacityFromMap = (Integer)headerSlotCapaCountMap.get(capacity);
                    headerSlotCapaCountMap.put(capacity, capacityFromMap + 1);
                } else {
                    headerSlotCapaCountMap.put(capacity, 1);
                }
                ++headerSlotUsedCount;
            }
            ++hFrames;
        }
        int headerSlotTotalCount = hFrames * this.frameCapacity / 2;
        if (headerSlotTotalCount > 0) {
            headerSlotUsedRatio = (double)headerSlotUsedCount / (double)headerSlotTotalCount;
        }
        int total = hFrames + nFrames;
        StringBuilder buf = new StringBuilder();
        buf.append("\n>>> " + this + " " + Thread.currentThread().getId() + "::printInfo()\n");
        buf.append("(A) hash table cardinality (# of slot):\t" + this.tableSize + "\tExpected Table Size(MB):\t" + (double)SerializableHashTable.getExpectedTableByteSize(this.tableSize, this.frameCapacity * 4) / 1048576.0 + "\twasted size(MB):\t" + (double)this.wastedIntSpaceCount * 4.0 / 1048576.0 + "\n");
        buf.append("(B) # of header frames:\t" + hFrames + "\tsize(MB)\t" + (double)hFrames * (double)this.frameCapacity * 4.0 / 1048576.0 + "\tratio (B/D)\t" + (double)hFrames / (double)total + "\n");
        buf.append("(C) # of content frames:\t" + nFrames + "\tsize(MB)\t" + (double)nFrames * (double)this.frameCapacity * 4.0 / 1048576.0 + "\tratio (C/D)\t" + (double)nFrames / (double)total + "\n");
        buf.append("(D) # of total frames:\t" + total + "\tsize(MB)\t" + (double)total * (double)this.frameCapacity * 4.0 / 1048576.0 + "\n");
        buf.append("(E) # of used header entries:\t" + headerSlotUsedCount + "\n");
        buf.append("(F) # of all possible header entries:\t" + headerSlotTotalCount + "\n");
        buf.append("(G) header entries used ratio (E/F):\t" + headerSlotUsedRatio + "\n");
        buf.append("(H) used count histogram (used count, its frequency):\n");
        int totalContentUsedCount = 0;
        for (Map.Entry entry : headerSlotUsedCountMap.entrySet()) {
            buf.append(entry.getKey() + "\t" + entry.getValue() + "\n");
            totalContentUsedCount += (Integer)entry.getKey() * (Integer)entry.getValue();
        }
        buf.append("(H-1) total used count in content frames:\t" + totalContentUsedCount + "\n");
        int totalContentCapaCount = 0;
        buf.append("(I) capacity count histogram (capacity, its frequency):\n");
        for (Map.Entry entry : headerSlotCapaCountMap.entrySet()) {
            buf.append(entry.getKey() + "\t" + entry.getValue() + "\n");
            totalContentCapaCount += (Integer)entry.getKey() * (Integer)entry.getValue();
        }
        buf.append("(I-1) total capacity in content frames:\t" + totalContentCapaCount + "\n");
        buf.append("(J) ratio of used count in content frames (H-1 / I-1):\t" + (double)totalContentUsedCount / (double)totalContentCapaCount + "\n");
        return buf.toString();
    }

    public void getSlotInfo(int contentFrameIndex, int contentOffsetIndex, SlotInfoPair<Integer, Integer> slotInfo) {
        SimpleSerializableHashTable.IntSerDeBuffer frame = (SimpleSerializableHashTable.IntSerDeBuffer)this.contents.get(contentFrameIndex);
        int entryCapacity = frame.getInt(contentOffsetIndex);
        int entryUsedItems = frame.getInt(contentOffsetIndex + 1);
        slotInfo.reset(entryCapacity, entryUsedItems);
    }

    private static class GarbageCollectionInfo {
        int currentReadPageForGC = 0;
        int currentReadIntOffsetInPageForGC = 0;
        int currentGCWritePageForGC = 0;
        int currentWriteIntOffsetInPageForGC = 0;

        public boolean isReaderWriterAtTheSamePos() {
            return this.currentReadPageForGC == this.currentGCWritePageForGC && this.currentReadIntOffsetInPageForGC == this.currentWriteIntOffsetInPageForGC;
        }
    }

    private static class SlotInfoPair<T1, T2> {
        private T1 first;
        private T2 second;

        public SlotInfoPair(T1 first, T2 second) {
            this.first = first;
            this.second = second;
        }

        public void reset(T1 first, T2 second) {
            this.first = first;
            this.second = second;
        }
    }
}

