/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import java.io.DataOutput;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.util.TreeIndexStats;
import org.apache.hyracks.storage.am.common.util.TreeIndexStatsGatherer;
import org.apache.hyracks.storage.common.IStorageManager;
import org.apache.hyracks.storage.common.LocalResource;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class TreeIndexStatsOperatorNodePushable
extends AbstractUnaryOutputSourceOperatorNodePushable {
    private final IHyracksTaskContext ctx;
    private final IStorageManager storageManager;
    private final IIndexDataflowHelper treeIndexHelper;
    private final UTF8StringSerializerDeserializer utf8SerDer = new UTF8StringSerializerDeserializer();

    public TreeIndexStatsOperatorNodePushable(IHyracksTaskContext ctx, int partition, IIndexDataflowHelperFactory indexHelperFactory, IStorageManager storageManager) throws HyracksDataException {
        this.ctx = ctx;
        this.treeIndexHelper = indexHelperFactory.create(ctx.getJobletContext().getServiceContext(), partition);
        this.storageManager = storageManager;
    }

    public void deinitialize() throws HyracksDataException {
    }

    public IFrameWriter getInputFrameWriter(int index) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws HyracksDataException {
        this.treeIndexHelper.open();
        ITreeIndex treeIndex = (ITreeIndex)this.treeIndexHelper.getIndexInstance();
        try {
            this.writer.open();
            IBufferCache bufferCache = this.storageManager.getBufferCache(this.ctx.getJobletContext().getServiceContext());
            LocalResource resource = this.treeIndexHelper.getResource();
            IIOManager ioManager = this.ctx.getIoManager();
            FileReference fileRef = ioManager.resolve(resource.getPath());
            TreeIndexStatsGatherer statsGatherer = new TreeIndexStatsGatherer(bufferCache, treeIndex.getPageManager(), fileRef, treeIndex.getRootPageId());
            TreeIndexStats stats = statsGatherer.gatherStats(treeIndex.getLeafFrameFactory().createFrame(), treeIndex.getInteriorFrameFactory().createFrame(), treeIndex.getPageManager().createMetadataFrame());
            FrameTupleAppender appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.ctx));
            ArrayTupleBuilder tb = new ArrayTupleBuilder(1);
            DataOutput dos = tb.getDataOutput();
            tb.reset();
            this.utf8SerDer.serialize(stats.toString(), dos);
            tb.addFieldEndOffset();
            if (!appender.append(tb.getFieldEndOffsets(), tb.getByteArray(), 0, tb.getSize())) {
                throw new HyracksDataException("Record size (" + tb.getSize() + ") larger than frame size (" + appender.getBuffer().capacity() + ")");
            }
            appender.write(this.writer, false);
        }
        catch (Exception e) {
            this.writer.fail();
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            try {
                this.writer.close();
            }
            finally {
                this.treeIndexHelper.close();
            }
        }
    }
}

