/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.s3a.CredentialInitializationException;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.auth.NoAuthWithAWSException;
import org.apache.hadoop.fs.s3a.auth.NoAwsCredentialsException;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AWSCredentialProviderList
implements AWSCredentialsProvider,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AWSCredentialProviderList.class);
    public static final String NO_AWS_CREDENTIAL_PROVIDERS = "No AWS Credential Providers";
    static final String CREDENTIALS_REQUESTED_WHEN_CLOSED = "Credentials requested after provider list was closed";
    private final List<AWSCredentialsProvider> providers = new ArrayList<AWSCredentialsProvider>(1);
    private boolean reuseLastProvider = true;
    private AWSCredentialsProvider lastProvider;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private String name = "";

    public AWSCredentialProviderList() {
    }

    public AWSCredentialProviderList(Collection<AWSCredentialsProvider> providers) {
        this.providers.addAll(providers);
    }

    public AWSCredentialProviderList(String name, AWSCredentialsProvider ... providerArgs) {
        this.setName(name);
        Collections.addAll(this.providers, providerArgs);
    }

    public void setName(String name) {
        this.name = !name.isEmpty() && !name.endsWith(": ") ? name + ": " : name;
    }

    public void add(AWSCredentialsProvider p) {
        this.providers.add(p);
    }

    public void addAll(AWSCredentialProviderList other) {
        this.providers.addAll(other.providers);
    }

    public void refresh() {
        if (this.isClosed()) {
            return;
        }
        for (AWSCredentialsProvider provider : this.providers) {
            provider.refresh();
        }
    }

    public AWSCredentials getCredentials() {
        if (this.isClosed()) {
            LOG.warn(CREDENTIALS_REQUESTED_WHEN_CLOSED);
            throw new NoAuthWithAWSException(this.name + CREDENTIALS_REQUESTED_WHEN_CLOSED);
        }
        this.checkNotEmpty();
        if (this.reuseLastProvider && this.lastProvider != null) {
            return this.lastProvider.getCredentials();
        }
        AmazonClientException lastException = null;
        for (AWSCredentialsProvider provider : this.providers) {
            try {
                AWSCredentials credentials = provider.getCredentials();
                Preconditions.checkNotNull((Object)credentials, (String)"Null credentials returned by %s", (Object)provider);
                if ((credentials.getAWSAccessKeyId() == null || credentials.getAWSSecretKey() == null) && !(credentials instanceof AnonymousAWSCredentials)) continue;
                this.lastProvider = provider;
                LOG.debug("Using credentials from {}", (Object)provider);
                return credentials;
            }
            catch (NoAwsCredentialsException e) {
                if (lastException == null) {
                    lastException = e;
                }
                LOG.debug("No credentials from {}: {}", (Object)provider, (Object)e.toString());
            }
            catch (AmazonClientException e) {
                lastException = e;
                LOG.debug("No credentials provided by {}: {}", new Object[]{provider, e.toString(), e});
            }
        }
        String message = this.name + "No AWS Credentials provided by " + this.listProviderNames();
        if (lastException != null) {
            message = message + ": " + (Object)((Object)lastException);
        }
        if (lastException instanceof CredentialInitializationException) {
            throw lastException;
        }
        throw new NoAuthWithAWSException(message, lastException);
    }

    @VisibleForTesting
    List<AWSCredentialsProvider> getProviders() {
        return this.providers;
    }

    public void checkNotEmpty() {
        if (this.providers.isEmpty()) {
            throw new NoAuthWithAWSException(this.name + NO_AWS_CREDENTIAL_PROVIDERS);
        }
    }

    public String listProviderNames() {
        return this.providers.stream().map(provider -> provider.getClass().getSimpleName() + ' ').collect(Collectors.joining());
    }

    public String toString() {
        return "AWSCredentialProviderList[" + this.name + "refcount= " + this.refCount.get() + ": [" + StringUtils.join(this.providers, (String)", ") + ']' + (this.lastProvider != null ? " last provider: " + this.lastProvider : "");
    }

    public synchronized AWSCredentialProviderList share() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"Provider list is closed");
        this.refCount.incrementAndGet();
        return this;
    }

    @VisibleForTesting
    public int getRefCount() {
        return this.refCount.get();
    }

    @VisibleForTesting
    public boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AWSCredentialProviderList aWSCredentialProviderList = this;
        synchronized (aWSCredentialProviderList) {
            if (this.closed.get()) {
                return;
            }
            int remainder = this.refCount.decrementAndGet();
            if (remainder != 0) {
                LOG.debug("Not closing {}", (Object)this);
                return;
            }
            LOG.debug("Closing {}", (Object)this);
            this.closed.set(true);
        }
        for (AWSCredentialsProvider p : this.providers) {
            if (p instanceof Closeable) {
                IOUtils.closeStream((Closeable)((Closeable)p));
                continue;
            }
            if (!(p instanceof AutoCloseable)) continue;
            S3AUtils.closeAutocloseables(LOG, (AutoCloseable)p);
        }
    }

    public int size() {
        return this.providers.size();
    }
}

