/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.internal.IteratorSupport;
import com.amazonaws.services.dynamodbv2.document.spec.GetItemSpec;
import com.amazonaws.services.dynamodbv2.xspec.Condition;
import com.amazonaws.services.dynamodbv2.xspec.ExpressionSpecBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.s3guard.DDBPathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.DynamoDBMetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadataDynamoDBTranslation;
import org.apache.hadoop.fs.s3a.s3guard.S3GuardFsckViolationHandler;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3GuardFsck {
    private static final Logger LOG = LoggerFactory.getLogger(S3GuardFsck.class);
    public static final String ROOT_PATH_STRING = "/";
    private final S3AFileSystem rawFS;
    private final DynamoDBMetadataStore metadataStore;
    private static final long MOD_TIME_RANGE = 2000L;

    public S3GuardFsck(S3AFileSystem fs, MetadataStore ms) throws InvalidParameterException {
        this.rawFS = fs;
        if (ms == null) {
            throw new InvalidParameterException("S3A Bucket " + fs.getBucket() + " should be guarded by a " + DynamoDBMetadataStore.class.getCanonicalName());
        }
        this.metadataStore = (DynamoDBMetadataStore)ms;
        Preconditions.checkArgument((!this.rawFS.hasMetadataStore() ? 1 : 0) != 0, (Object)"Raw fs should not have a metadatastore.");
    }

    public List<ComparePair> compareS3ToMs(Path p) throws IOException {
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        int scannedItems = 0;
        Path rootPath = this.rawFS.qualify(p);
        S3AFileStatus root = (S3AFileStatus)this.rawFS.getFileStatus(rootPath);
        ArrayList<ComparePair> comparePairs = new ArrayList<ComparePair>();
        ArrayDeque<S3AFileStatus> queue = new ArrayDeque<S3AFileStatus>();
        queue.add(root);
        while (!queue.isEmpty()) {
            S3AFileStatus currentDir = (S3AFileStatus)((Object)queue.poll());
            Path currentDirPath = currentDir.getPath();
            try {
                List<FileStatus> s3DirListing = Arrays.asList(this.rawFS.listStatus(currentDirPath));
                this.compareAuthoritativeDirectoryFlag(comparePairs, currentDirPath, s3DirListing);
                s3DirListing.stream().filter(pm -> pm.isDirectory()).map(S3AFileStatus.class::cast).forEach(pm -> queue.add((S3AFileStatus)((Object)pm)));
                List<S3AFileStatus> children = s3DirListing.stream().filter(status -> !status.isDirectory()).map(S3AFileStatus.class::cast).collect(Collectors.toList());
                List<ComparePair> compareResult = this.compareS3DirContentToMs(currentDir, children);
                comparePairs.addAll(compareResult);
                ++scannedItems;
                scannedItems += children.size();
            }
            catch (FileNotFoundException e) {
                LOG.error("The path has been deleted since it was queued: " + currentDirPath, (Throwable)e);
            }
        }
        stopwatch.stop();
        S3GuardFsckViolationHandler handler = new S3GuardFsckViolationHandler(this.rawFS, this.metadataStore);
        for (ComparePair comparePair : comparePairs) {
            handler.logError(comparePair);
        }
        LOG.info("Total scan time: {}s", (Object)stopwatch.now(TimeUnit.SECONDS));
        LOG.info("Scanned entries: {}", (Object)scannedItems);
        return comparePairs;
    }

    private void compareAuthoritativeDirectoryFlag(List<ComparePair> comparePairs, Path currentDirPath, List<FileStatus> s3DirListing) throws IOException {
        DirListingMetadata msDirListing = this.metadataStore.listChildren(currentDirPath);
        if (msDirListing != null && msDirListing.isAuthoritative()) {
            ComparePair cP = new ComparePair(s3DirListing, msDirListing);
            if (s3DirListing.size() != msDirListing.numEntries()) {
                cP.violations.add(Violation.AUTHORITATIVE_DIRECTORY_CONTENT_MISMATCH);
            } else {
                Set msPaths = msDirListing.getListing().stream().map(pm -> pm.getFileStatus().getPath()).collect(Collectors.toSet());
                Set s3Paths = s3DirListing.stream().map(pm -> pm.getPath()).collect(Collectors.toSet());
                if (!s3Paths.equals(msPaths)) {
                    cP.violations.add(Violation.AUTHORITATIVE_DIRECTORY_CONTENT_MISMATCH);
                }
            }
            if (cP.containsViolation()) {
                comparePairs.add(cP);
            }
        }
    }

    protected List<ComparePair> compareS3DirContentToMs(S3AFileStatus s3CurrentDir, List<S3AFileStatus> children) throws IOException {
        Path path = s3CurrentDir.getPath();
        DDBPathMetadata pathMetadata = this.metadataStore.get(path);
        ArrayList<ComparePair> violationComparePairs = new ArrayList<ComparePair>();
        ComparePair rootComparePair = this.compareFileStatusToPathMetadata(s3CurrentDir, pathMetadata);
        if (rootComparePair.containsViolation()) {
            violationComparePairs.add(rootComparePair);
        }
        children.forEach(s3ChildMeta -> {
            try {
                DDBPathMetadata msChildMeta = this.metadataStore.get(s3ChildMeta.getPath());
                ComparePair comparePair = this.compareFileStatusToPathMetadata((S3AFileStatus)((Object)s3ChildMeta), msChildMeta);
                if (comparePair.containsViolation()) {
                    violationComparePairs.add(comparePair);
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        });
        return violationComparePairs;
    }

    protected ComparePair compareFileStatusToPathMetadata(S3AFileStatus s3FileStatus, PathMetadata msPathMetadata) throws IOException {
        long modTimeDiff;
        Path path = s3FileStatus.getPath();
        if (msPathMetadata != null) {
            LOG.info("Path: {} - Length S3: {}, MS: {} - Etag S3: {}, MS: {} ", new Object[]{path, s3FileStatus.getLen(), msPathMetadata.getFileStatus().getLen(), s3FileStatus.getETag(), msPathMetadata.getFileStatus().getETag()});
        } else {
            LOG.info("Path: {} - Length S3: {} - Etag S3: {}, no record in MS.", new Object[]{path, s3FileStatus.getLen(), s3FileStatus.getETag()});
        }
        ComparePair comparePair = new ComparePair(s3FileStatus, msPathMetadata);
        if (!path.equals((Object)this.path(ROOT_PATH_STRING))) {
            Path parentPath = path.getParent();
            DDBPathMetadata parentPm = this.metadataStore.get(parentPath);
            if (parentPm == null) {
                comparePair.violations.add(Violation.NO_PARENT_ENTRY);
            } else {
                if (!parentPm.getFileStatus().isDirectory()) {
                    comparePair.violations.add(Violation.PARENT_IS_A_FILE);
                }
                if (parentPm.isDeleted()) {
                    comparePair.violations.add(Violation.PARENT_TOMBSTONED);
                }
            }
        } else {
            LOG.debug("Entry is in the root directory, so there's no parent");
        }
        if (msPathMetadata == null) {
            comparePair.violations.add(Violation.NO_METADATA_ENTRY);
            return comparePair;
        }
        S3AFileStatus msFileStatus = msPathMetadata.getFileStatus();
        if (s3FileStatus.isDirectory() && !msFileStatus.isDirectory()) {
            comparePair.violations.add(Violation.DIR_IN_S3_FILE_IN_MS);
        }
        if (!s3FileStatus.isDirectory() && msFileStatus.isDirectory()) {
            comparePair.violations.add(Violation.FILE_IN_S3_DIR_IN_MS);
        }
        if (msPathMetadata.isDeleted()) {
            comparePair.violations.add(Violation.TOMBSTONED_IN_MS_NOT_DELETED_IN_S3);
        }
        if (s3FileStatus.getLen() != msFileStatus.getLen()) {
            comparePair.violations.add(Violation.LENGTH_MISMATCH);
        }
        if ((modTimeDiff = Math.abs(s3FileStatus.getModificationTime() - msFileStatus.getModificationTime())) > 2000L) {
            comparePair.violations.add(Violation.MOD_TIME_MISMATCH);
        }
        if (msPathMetadata.getFileStatus().getVersionId() == null || s3FileStatus.getVersionId() == null) {
            LOG.debug("Missing versionIDs skipped. A HEAD request is required for each object to get the versionID.");
        } else if (!s3FileStatus.getVersionId().equals(msFileStatus.getVersionId())) {
            comparePair.violations.add(Violation.VERSIONID_MISMATCH);
        }
        if (!s3FileStatus.isDirectory()) {
            if (msPathMetadata.getFileStatus().getETag() == null) {
                comparePair.violations.add(Violation.NO_ETAG);
            } else if (s3FileStatus.getETag() != null && !s3FileStatus.getETag().equals(msFileStatus.getETag())) {
                comparePair.violations.add(Violation.ETAG_MISMATCH);
            }
        }
        return comparePair;
    }

    private Path path(String s) {
        return this.rawFS.makeQualified(new Path(s));
    }

    public void fixViolations(List<ComparePair> violations) throws IOException {
        S3GuardFsckViolationHandler handler = new S3GuardFsckViolationHandler(this.rawFS, this.metadataStore);
        for (ComparePair v : violations) {
            if (!v.getViolations().contains((Object)Violation.ORPHAN_DDB_ENTRY)) continue;
            try {
                handler.doFix(v);
            }
            catch (IOException e) {
                LOG.error("Error during handling the violation: ", (Throwable)e);
                throw e;
            }
        }
    }

    public List<ComparePair> checkDdbInternalConsistency(Path basePath) throws IOException {
        DDBPathMetadata baseMeta;
        Preconditions.checkArgument((boolean)basePath.isAbsolute(), (Object)"path must be absolute");
        ArrayList<ComparePair> comparePairs = new ArrayList<ComparePair>();
        String rootStr = basePath.toString();
        LOG.info("Root for internal consistency check: {}", (Object)rootStr);
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        Table table = this.metadataStore.getTable();
        String username = this.metadataStore.getUsername();
        DDBTree ddbTree = new DDBTree();
        if (!basePath.isRoot()) {
            PrimaryKey rootKey = PathMetadataDynamoDBTranslation.pathToKey(basePath);
            GetItemSpec spec = new GetItemSpec().withPrimaryKey(rootKey).withConsistentRead(true);
            Item baseItem = table.getItem(spec);
            baseMeta = PathMetadataDynamoDBTranslation.itemToPathMetadata(baseItem, username);
            if (baseMeta == null) {
                throw new FileNotFoundException("Base element metadata is null. This means the base path element is missing, or wrong path was passed as base path to the internal ddb consistency checker.");
            }
        } else {
            baseMeta = new DDBPathMetadata(new S3AFileStatus(Tristate.UNKNOWN, basePath, username));
        }
        DDBTreeNode root = new DDBTreeNode(baseMeta);
        ddbTree.addNode(root);
        ddbTree.setRoot(root);
        ExpressionSpecBuilder builder = new ExpressionSpecBuilder();
        builder.withCondition((Condition)ExpressionSpecBuilder.S((String)"parent").beginsWith(PathMetadataDynamoDBTranslation.pathToParentKey(basePath)));
        IteratorSupport resultIterator = table.scan(builder.buildForScan()).iterator();
        resultIterator.forEachRemaining(item -> {
            DDBPathMetadata pmd = PathMetadataDynamoDBTranslation.itemToPathMetadata(item, username);
            DDBTreeNode ddbTreeNode = new DDBTreeNode(pmd);
            ddbTree.addNode(ddbTreeNode);
        });
        LOG.debug("Root: {}", (Object)ddbTree.getRoot());
        for (Map.Entry<Path, DDBTreeNode> entry : ddbTree.getContentMap().entrySet()) {
            DDBTreeNode node = entry.getValue();
            ComparePair pair = new ComparePair(null, node.val);
            if (node.getVal().getFileStatus().getPath().isRoot()) continue;
            if (node.getVal().getLastUpdated() == 0L) {
                pair.violations.add(Violation.NO_LASTUPDATED_FIELD);
            }
            if (node.equals(ddbTree.getRoot())) continue;
            Path parent = node.getFileStatus().getPath().getParent();
            DDBTreeNode parentNode = ddbTree.getContentMap().get(parent);
            if (parentNode == null) {
                pair.violations.add(Violation.ORPHAN_DDB_ENTRY);
            } else {
                if (!node.isTombstoned() && !parentNode.isDirectory()) {
                    pair.violations.add(Violation.PARENT_IS_A_FILE);
                }
                if (!node.isTombstoned() && parentNode.isTombstoned()) {
                    pair.violations.add(Violation.PARENT_TOMBSTONED);
                }
            }
            if (!pair.violations.isEmpty()) {
                comparePairs.add(pair);
            }
            node.setParent(parentNode);
        }
        S3GuardFsckViolationHandler handler = new S3GuardFsckViolationHandler(this.rawFS, this.metadataStore);
        for (ComparePair comparePair : comparePairs) {
            handler.logError(comparePair);
        }
        stopwatch.stop();
        LOG.info("Total scan time: {}s", (Object)stopwatch.now(TimeUnit.SECONDS));
        LOG.info("Scanned entries: {}", (Object)ddbTree.contentMap.size());
        return comparePairs;
    }

    public static enum Violation {
        NO_METADATA_ENTRY(1, S3GuardFsckViolationHandler.NoMetadataEntry.class),
        NO_PARENT_ENTRY(0, S3GuardFsckViolationHandler.NoParentEntry.class),
        PARENT_IS_A_FILE(0, S3GuardFsckViolationHandler.ParentIsAFile.class),
        PARENT_TOMBSTONED(0, S3GuardFsckViolationHandler.ParentTombstoned.class),
        DIR_IN_S3_FILE_IN_MS(0, S3GuardFsckViolationHandler.DirInS3FileInMs.class),
        FILE_IN_S3_DIR_IN_MS(0, S3GuardFsckViolationHandler.FileInS3DirInMs.class),
        AUTHORITATIVE_DIRECTORY_CONTENT_MISMATCH(1, S3GuardFsckViolationHandler.AuthDirContentMismatch.class),
        TOMBSTONED_IN_MS_NOT_DELETED_IN_S3(0, S3GuardFsckViolationHandler.TombstonedInMsNotDeletedInS3.class),
        LENGTH_MISMATCH(0, S3GuardFsckViolationHandler.LengthMismatch.class),
        MOD_TIME_MISMATCH(2, S3GuardFsckViolationHandler.ModTimeMismatch.class),
        VERSIONID_MISMATCH(0, S3GuardFsckViolationHandler.VersionIdMismatch.class),
        ETAG_MISMATCH(0, S3GuardFsckViolationHandler.EtagMismatch.class),
        NO_ETAG(2, S3GuardFsckViolationHandler.NoEtag.class),
        ORPHAN_DDB_ENTRY(0, S3GuardFsckViolationHandler.OrphanDDBEntry.class),
        NO_LASTUPDATED_FIELD(2, S3GuardFsckViolationHandler.NoLastUpdatedField.class);

        private final int severity;
        private final Class<? extends S3GuardFsckViolationHandler.ViolationHandler> handler;

        private Violation(int s, Class<? extends S3GuardFsckViolationHandler.ViolationHandler> h) {
            this.severity = s;
            this.handler = h;
        }

        public int getSeverity() {
            return this.severity;
        }

        public Class<? extends S3GuardFsckViolationHandler.ViolationHandler> getHandler() {
            return this.handler;
        }
    }

    private static final class DDBTreeNode {
        private final DDBPathMetadata val;
        private DDBTreeNode parent;
        private final List<DDBPathMetadata> children;

        private DDBTreeNode(DDBPathMetadata pm) {
            this.val = pm;
            this.parent = null;
            this.children = new ArrayList<DDBPathMetadata>();
        }

        public DDBPathMetadata getVal() {
            return this.val;
        }

        public DDBTreeNode getParent() {
            return this.parent;
        }

        public void setParent(DDBTreeNode parent) {
            this.parent = parent;
        }

        public List<DDBPathMetadata> getChildren() {
            return this.children;
        }

        public boolean isDirectory() {
            return this.val.getFileStatus().isDirectory();
        }

        public S3AFileStatus getFileStatus() {
            return this.val.getFileStatus();
        }

        public boolean isTombstoned() {
            return this.val.isDeleted();
        }

        public String toString() {
            return "DDBTreeNode{val=" + this.val + ", parent=" + this.parent + ", children=" + this.children + '}';
        }
    }

    public static class DDBTree {
        private final Map<Path, DDBTreeNode> contentMap = new HashMap<Path, DDBTreeNode>();
        private DDBTreeNode root;

        public Map<Path, DDBTreeNode> getContentMap() {
            return this.contentMap;
        }

        public DDBTreeNode getRoot() {
            return this.root;
        }

        public void setRoot(DDBTreeNode root) {
            this.root = root;
        }

        public void addNode(DDBTreeNode pm) {
            this.contentMap.put(pm.getVal().getFileStatus().getPath(), pm);
        }

        public String toString() {
            return "DDBTree{contentMap=" + this.contentMap + ", root=" + this.root + '}';
        }
    }

    public static class ComparePair {
        private final S3AFileStatus s3FileStatus;
        private final PathMetadata msPathMetadata;
        private final List<FileStatus> s3DirListing;
        private final DirListingMetadata msDirListing;
        private final Path path;
        private final Set<Violation> violations = new HashSet<Violation>();

        ComparePair(S3AFileStatus status, PathMetadata pm) {
            this.s3FileStatus = status;
            this.msPathMetadata = pm;
            this.s3DirListing = null;
            this.msDirListing = null;
            this.path = status != null ? status.getPath() : pm.getFileStatus().getPath();
        }

        ComparePair(List<FileStatus> s3DirListing, DirListingMetadata msDirListing) {
            this.s3DirListing = s3DirListing;
            this.msDirListing = msDirListing;
            this.s3FileStatus = null;
            this.msPathMetadata = null;
            this.path = msDirListing.getPath();
        }

        public S3AFileStatus getS3FileStatus() {
            return this.s3FileStatus;
        }

        public PathMetadata getMsPathMetadata() {
            return this.msPathMetadata;
        }

        public Set<Violation> getViolations() {
            return this.violations;
        }

        public boolean containsViolation() {
            return !this.violations.isEmpty();
        }

        public DirListingMetadata getMsDirListing() {
            return this.msDirListing;
        }

        public List<FileStatus> getS3DirListing() {
            return this.s3DirListing;
        }

        public Path getPath() {
            return this.path;
        }

        public String toString() {
            return "ComparePair{s3FileStatus=" + (Object)((Object)this.s3FileStatus) + ", msPathMetadata=" + this.msPathMetadata + ", s3DirListing=" + this.s3DirListing + ", msDirListing=" + this.msDirListing + ", path=" + this.path + ", violations=" + this.violations + '}';
        }
    }
}

