/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.comm.io;

import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;

public class FrameTupleAppenderWrapper {
    private final IFrameTupleAppender frameTupleAppender;
    private final IFrameWriter outputWriter;

    public FrameTupleAppenderWrapper(IFrameTupleAppender frameTupleAppender, IFrameWriter outputWriter) {
        this.frameTupleAppender = frameTupleAppender;
        this.outputWriter = outputWriter;
    }

    public void open() throws HyracksDataException {
        this.outputWriter.open();
    }

    public void write() throws HyracksDataException {
        this.frameTupleAppender.write(this.outputWriter, true);
    }

    public void flush() throws HyracksDataException {
        this.frameTupleAppender.flush(this.outputWriter);
    }

    public void close() throws HyracksDataException {
        this.outputWriter.close();
    }

    public void fail() throws HyracksDataException {
        this.outputWriter.fail();
    }

    public void reset(IFrame buffer, boolean clear) throws HyracksDataException {
        this.frameTupleAppender.reset(buffer, clear);
    }

    public void appendSkipEmptyField(int[] fieldSlots, byte[] bytes, int offset, int length) throws HyracksDataException {
        FrameUtils.appendSkipEmptyFieldToWriter(this.outputWriter, this.frameTupleAppender, fieldSlots, bytes, offset, length);
    }

    public void appendConcat(IFrameTupleAccessor accessor0, int tIndex0, IFrameTupleAccessor accessor1, int tIndex1) throws HyracksDataException {
        FrameUtils.appendConcatToWriter(this.outputWriter, this.frameTupleAppender, accessor0, tIndex0, accessor1, tIndex1);
    }

    public void appendConcat(IFrameTupleAccessor accessor0, int tIndex0, int[] fieldSlots1, byte[] bytes1, int offset1, int dataLen1) throws HyracksDataException {
        FrameUtils.appendConcatToWriter(this.outputWriter, this.frameTupleAppender, accessor0, tIndex0, fieldSlots1, bytes1, offset1, dataLen1);
    }

    public void appendProjection(IFrameTupleAccessor accessor, int tIndex, int[] fields) throws HyracksDataException {
        FrameUtils.appendProjectionToWriter(this.outputWriter, this.frameTupleAppender, accessor, tIndex, fields);
    }
}

