/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushSelectDownRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.SELECT || !OperatorPropertiesUtil.isMovable((ILogicalOperator)op)) {
            return false;
        }
        Mutable opRef2 = (Mutable)op.getInputs().get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (context.checkAndAddToAlreadyCompared((ILogicalOperator)op, (ILogicalOperator)op2)) {
            return false;
        }
        LogicalOperatorTag tag2 = op2.getOperatorTag();
        if (tag2 == LogicalOperatorTag.INNERJOIN || tag2 == LogicalOperatorTag.LEFTOUTERJOIN || tag2 == LogicalOperatorTag.REPLICATE || tag2 == LogicalOperatorTag.SPLIT) {
            return false;
        }
        boolean res = PushSelectDownRule.propagateSelectionRec(opRef, (Mutable<ILogicalOperator>)opRef2);
        if (res) {
            OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
        }
        return res;
    }

    private static boolean propagateSelectionRec(Mutable<ILogicalOperator> sigmaRef, Mutable<ILogicalOperator> opRef2) throws AlgebricksException {
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (op2.getInputs().size() != 1 || op2.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN || !OperatorPropertiesUtil.isMovable((ILogicalOperator)op2)) {
            return false;
        }
        SelectOperator sigma = (SelectOperator)sigmaRef.getValue();
        LinkedList usedInSigma = new LinkedList();
        ((ILogicalExpression)sigma.getCondition().getValue()).getUsedVariables(usedInSigma);
        LinkedList produced2 = new LinkedList();
        VariableUtilities.getProducedVariables((ILogicalOperator)op2, produced2);
        if (OperatorPropertiesUtil.disjoint(produced2, usedInSigma)) {
            opRef2.setValue((Object)sigma);
            sigmaRef.setValue((Object)op2);
            List sigmaInpList = sigma.getInputs();
            sigmaInpList.clear();
            sigmaInpList.addAll(op2.getInputs());
            List op2InpList = op2.getInputs();
            op2InpList.clear();
            op2InpList.add(opRef2);
            PushSelectDownRule.propagateSelectionRec(opRef2, (Mutable<ILogicalOperator>)((Mutable)sigma.getInputs().get(0)));
            return true;
        }
        return false;
    }
}

