/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.distribution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.teradata.tpcds.distribution.DistributionUtils;
import com.teradata.tpcds.random.RandomNumberStream;
import com.teradata.tpcds.type.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CalendarDistribution {
    private static final int NUM_WEIGHT_FIELDS = Weights.values().length;
    private static final String VALUES_AND_WEIGHTS_FILENAME = "calendar.dst";
    private static final int[][] DAYS_BEFORE_MONTH = new int[][]{{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334}, {0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335}};
    private static final CalendarDistribution CALENDAR_DISTRIBUTION = CalendarDistribution.buildCalendarDistribution();
    private final ImmutableList<Integer> daysOfYear;
    private final ImmutableList<Integer> quarters;
    private final ImmutableList<Integer> holidayFlags;
    private final ImmutableList<ImmutableList<Integer>> weightLists;

    private CalendarDistribution(ImmutableList<Integer> daysOfYear, ImmutableList<Integer> quarters, ImmutableList<Integer> holidayFlags, ImmutableList<ImmutableList<Integer>> weightLists) {
        this.daysOfYear = daysOfYear;
        this.quarters = quarters;
        this.holidayFlags = holidayFlags;
        this.weightLists = weightLists;
    }

    private static CalendarDistribution buildCalendarDistribution() {
        ImmutableList.Builder daysOfYearBuilder = ImmutableList.builder();
        ImmutableList.Builder quartersBuilder = ImmutableList.builder();
        ImmutableList.Builder holidayFlagsBuilder = ImmutableList.builder();
        ArrayList<DistributionUtils.WeightsBuilder> weightsBuilders = new ArrayList<DistributionUtils.WeightsBuilder>(NUM_WEIGHT_FIELDS);
        for (int i = 0; i < NUM_WEIGHT_FIELDS; ++i) {
            weightsBuilders.add(new DistributionUtils.WeightsBuilder());
        }
        Iterator<List<String>> iterator = DistributionUtils.getDistributionIterator(VALUES_AND_WEIGHTS_FILENAME);
        while (iterator.hasNext()) {
            List<String> fields = iterator.next();
            Preconditions.checkState((fields.size() == 2 ? 1 : 0) != 0, (String)"Expected line to contain 2 parts but it contains %d: %s", (Object[])new Object[]{fields.size(), fields});
            List<String> values = DistributionUtils.getListFromCommaSeparatedValues(fields.get(0));
            Preconditions.checkState((values.size() == 8 ? 1 : 0) != 0, (String)"Expected line to contain 8 values, but it contained %d, %s", (Object[])new Object[]{values.size(), values});
            daysOfYearBuilder.add((Object)Integer.parseInt(values.get(0)));
            quartersBuilder.add((Object)Integer.parseInt(values.get(5)));
            holidayFlagsBuilder.add((Object)Integer.parseInt(values.get(7)));
            List<String> weights = DistributionUtils.getListFromCommaSeparatedValues(fields.get(1));
            Preconditions.checkState((weights.size() == NUM_WEIGHT_FIELDS ? 1 : 0) != 0, (String)"Expected line to contain %d weights, but it contained %d, %s", (Object[])new Object[]{NUM_WEIGHT_FIELDS, weights.size(), values});
            for (int i = 0; i < weights.size(); ++i) {
                ((DistributionUtils.WeightsBuilder)weightsBuilders.get(i)).computeAndAddNextWeight(Integer.parseInt(weights.get(i)));
            }
        }
        ImmutableList.Builder weightsListBuilder = ImmutableList.builder();
        for (DistributionUtils.WeightsBuilder weightsBuilder : weightsBuilders) {
            weightsListBuilder.add(weightsBuilder.build());
        }
        return new CalendarDistribution((ImmutableList<Integer>)daysOfYearBuilder.build(), (ImmutableList<Integer>)quartersBuilder.build(), (ImmutableList<Integer>)holidayFlagsBuilder.build(), (ImmutableList<ImmutableList<Integer>>)weightsListBuilder.build());
    }

    public static int getIndexForDate(Date date) {
        return DAYS_BEFORE_MONTH[Date.isLeapYear(date.getYear()) ? 1 : 0][date.getMonth() - 1] + date.getDay() - 1;
    }

    public static int getQuarterAtIndex(int index) {
        return (Integer)CalendarDistribution.CALENDAR_DISTRIBUTION.quarters.get(index - 1);
    }

    public static int getIsHolidayFlagAtIndex(int index) {
        return (Integer)CalendarDistribution.CALENDAR_DISTRIBUTION.holidayFlags.get(index - 1);
    }

    public static int getWeightForDayNumber(int dayNumber, Weights weights) {
        return DistributionUtils.getWeightForIndex(dayNumber, CalendarDistribution.getWeights(weights));
    }

    public static int getMaxWeight(Weights weights) {
        ImmutableList<Integer> weightsList = CalendarDistribution.getWeights(weights);
        return (Integer)weightsList.get(weightsList.size() - 1);
    }

    public static int pickRandomDayOfYear(Weights weights, RandomNumberStream stream) {
        return DistributionUtils.pickRandomValue(CalendarDistribution.CALENDAR_DISTRIBUTION.daysOfYear, CalendarDistribution.getWeights(weights), stream);
    }

    private static ImmutableList<Integer> getWeights(Weights weights) {
        return (ImmutableList)CalendarDistribution.CALENDAR_DISTRIBUTION.weightLists.get(weights.ordinal());
    }

    public static enum Weights {
        UNIFORM,
        UNIFORM_LEAP_YEAR,
        SALES,
        SALES_LEAP_YEAR,
        RETURNS,
        RETURNS_LEAP_YEAR,
        COMBINED_SKEW,
        LOW,
        MEDIUM,
        HIGH;

    }
}

