/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.row.generator;

import com.teradata.tpcds.Nulls;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.distribution.DemographicsDistributions;
import com.teradata.tpcds.generator.HouseholdDemographicsGeneratorColumn;
import com.teradata.tpcds.row.HouseholdDemographicsRow;
import com.teradata.tpcds.row.generator.AbstractRowGenerator;
import com.teradata.tpcds.row.generator.RowGenerator;
import com.teradata.tpcds.row.generator.RowGeneratorResult;

public class HouseholdDemographicsRowGenerator
extends AbstractRowGenerator {
    public HouseholdDemographicsRowGenerator() {
        super(Table.HOUSEHOLD_DEMOGRAPHICS);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long hdDemoSk;
        long nullBitMap = Nulls.createNullBitMap(Table.HOUSEHOLD_DEMOGRAPHICS, this.getRandomNumberStream(HouseholdDemographicsGeneratorColumn.HD_NULLS));
        long index = hdDemoSk = rowNumber;
        long hdIncomeBandId = index % (long)DemographicsDistributions.INCOME_BAND_DISTRIBUTION.getSize() + 1L;
        String hdBuyPotential = DemographicsDistributions.getBuyPotentialForIndexModSize(index /= (long)DemographicsDistributions.INCOME_BAND_DISTRIBUTION.getSize());
        int hdDepCount = DemographicsDistributions.getDepCountForIndexModSize(index /= (long)DemographicsDistributions.BUY_POTENTIAL_DISTRIBUTION.getSize());
        int hdVehicleCount = DemographicsDistributions.getVehicleCountForIndexModSize(index /= (long)DemographicsDistributions.DEP_COUNT_DISTRIBUTION.getSize());
        return new RowGeneratorResult(new HouseholdDemographicsRow(nullBitMap, hdDemoSk, hdIncomeBandId, hdBuyPotential, hdDepCount, hdVehicleCount));
    }
}

