/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.INullIntrospector;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListBuilder;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListBuilderFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.fixedsize.FixedSizeElementInvertedListBuilder;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.variablesize.VariableSizeElementInvertedListBuilder;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexUtils;

public class InvertedListBuilderFactory
implements IInvertedListBuilderFactory {
    protected final ITypeTraits[] invListFields;
    protected final ITypeTraits[] tokenTypeTraits;
    private final boolean isFixedSize;
    private final ITypeTraits nullTypeTraits;
    private final INullIntrospector nullIntrospector;

    public InvertedListBuilderFactory(ITypeTraits[] tokenTypeTraits, ITypeTraits[] invListFields, ITypeTraits nullTypeTraits, INullIntrospector nullIntrospector) {
        this.tokenTypeTraits = tokenTypeTraits;
        this.invListFields = invListFields;
        this.nullTypeTraits = nullTypeTraits;
        this.nullIntrospector = nullIntrospector;
        this.isFixedSize = InvertedIndexUtils.checkTypeTraitsAllFixed(invListFields);
    }

    @Override
    public IInvertedListBuilder create() throws HyracksDataException {
        if (this.isFixedSize) {
            return new FixedSizeElementInvertedListBuilder(this.invListFields);
        }
        return new VariableSizeElementInvertedListBuilder(this.tokenTypeTraits, this.invListFields, this.nullTypeTraits, this.nullIntrospector);
    }
}

