/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.impl;

import java.nio.ByteBuffer;
import org.apache.hyracks.ipc.api.IPayloadSerializerDeserializer;
import org.apache.hyracks.ipc.impl.IPCHandle;

public class Message {
    private static final int MSG_SIZE_SIZE = 4;
    public static final int HEADER_SIZE = 17;
    public static final byte INITIAL_REQ = 1;
    public static final byte INITIAL_ACK = 2;
    public static final byte ERROR = 3;
    public static final byte NORMAL = 0;
    private IPCHandle ipcHandle;
    private long messageId;
    private long requestMessageId;
    private byte flag;
    private Object payload;
    private int payloadLen;

    public Message(IPCHandle ipcHandle) {
        this.ipcHandle = ipcHandle;
    }

    IPCHandle getIPCHandle() {
        return this.ipcHandle;
    }

    public void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public void setRequestMessageId(long requestMessageId) {
        this.requestMessageId = requestMessageId;
    }

    public long getRequestMessageId() {
        return this.requestMessageId;
    }

    public void setFlag(byte flag) {
        this.flag = flag;
    }

    public byte getFlag() {
        return this.flag;
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    Object getPayload() {
        return this.payload;
    }

    int getPayloadLen() {
        return this.payloadLen;
    }

    public static boolean hasMessage(ByteBuffer buffer) {
        if (buffer.remaining() < 4) {
            return false;
        }
        int msgSize = buffer.getInt(buffer.position());
        return msgSize > 0 && buffer.remaining() >= msgSize + 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read(ByteBuffer buffer) throws Exception {
        int length;
        assert (Message.hasMessage(buffer));
        int msgSize = buffer.getInt();
        this.messageId = buffer.getLong();
        this.requestMessageId = buffer.getLong();
        this.flag = buffer.get();
        int finalPosition = buffer.position() + msgSize - 17;
        this.payloadLen = length = msgSize - 17;
        try {
            IPayloadSerializerDeserializer serde = this.ipcHandle.getIPCSystem().getSerializerDeserializer();
            switch (this.flag) {
                case 0: 
                case 1: 
                case 2: {
                    this.payload = serde.deserializeObject(buffer, length, this.flag);
                    return;
                }
                case 3: {
                    this.payload = serde.deserializeException(buffer, length);
                    return;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown message flag");
                }
            }
        }
        finally {
            buffer.position(finalPosition);
        }
    }

    public boolean write(ByteBuffer buffer) throws Exception {
        IPayloadSerializerDeserializer serde = this.ipcHandle.getIPCSystem().getSerializerDeserializer();
        return this.write(buffer, serde);
    }

    public boolean write(ByteBuffer buffer, IPayloadSerializerDeserializer serde) throws Exception {
        byte[] bytes;
        byte[] byArray = bytes = this.flag == 3 ? serde.serializeException((Exception)this.payload) : serde.serializeObject(this.payload);
        if (buffer.remaining() >= 21 + bytes.length) {
            Message.writeHeader(buffer, bytes.length, this.messageId, this.requestMessageId, this.flag);
            buffer.put(bytes);
            return true;
        }
        return false;
    }

    public static void writeHeader(ByteBuffer buffer, int dlen, long messageId, long requestMessageId, byte flag) {
        buffer.putInt(17 + dlen);
        buffer.putLong(messageId);
        buffer.putLong(requestMessageId);
        buffer.put(flag);
    }

    public String toString() {
        return "MSG[" + this.messageId + ":" + this.requestMessageId + ":" + this.flag + ":" + this.payload + "]";
    }
}

