/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.comparisons;

import java.io.DataOutput;
import org.apache.asterix.dataflow.data.common.ILogicalBinaryComparator;
import org.apache.asterix.dataflow.data.common.TaggedValueReference;
import org.apache.asterix.dataflow.data.nontagged.comparators.ComparatorUtil;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.AInt16;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.ConstantEvalFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractComparisonEvaluator
implements IScalarEvaluator {
    protected final ISerializerDeserializer<AMissing> missingSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AMISSING);
    protected final ISerializerDeserializer<ANull> nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
    protected final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    protected final DataOutput out = this.resultStorage.getDataOutput();
    protected final TaggedValuePointable argLeft = TaggedValuePointable.FACTORY.createPointable();
    protected final TaggedValuePointable argRight = TaggedValuePointable.FACTORY.createPointable();
    protected final SourceLocation sourceLoc;
    protected final IEvaluatorContext ctx;
    private final TaggedValueReference leftVal = new TaggedValueReference();
    private final TaggedValueReference rightVal = new TaggedValueReference();
    private final IScalarEvaluator evalLeft;
    private final IScalarEvaluator evalRight;
    private final ILogicalBinaryComparator logicalComparator;
    private final IAObject leftConstant;
    private final IAObject rightConstant;

    AbstractComparisonEvaluator(IScalarEvaluatorFactory evalLeftFactory, IAType leftType, IScalarEvaluatorFactory evalRightFactory, IAType rightType, IEvaluatorContext ctx, SourceLocation sourceLoc, boolean isEquality) throws HyracksDataException {
        this.ctx = ctx;
        this.evalLeft = evalLeftFactory.createScalarEvaluator(ctx);
        this.evalRight = evalRightFactory.createScalarEvaluator(ctx);
        this.sourceLoc = sourceLoc;
        this.logicalComparator = ComparatorUtil.createLogicalComparator((IAType)leftType, (IAType)rightType, (boolean)isEquality);
        this.leftConstant = AbstractComparisonEvaluator.getValueOfConstantEval(evalLeftFactory);
        this.rightConstant = AbstractComparisonEvaluator.getValueOfConstantEval(evalRightFactory);
    }

    private static IAObject getValueOfConstantEval(IScalarEvaluatorFactory factory) {
        return factory instanceof ConstantEvalFactory ? AbstractComparisonEvaluator.getConstant(((ConstantEvalFactory)factory).getValue()) : null;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.evalLeft.evaluate(tuple, (IPointable)this.argLeft);
        this.evalRight.evaluate(tuple, (IPointable)this.argRight);
        if (PointableHelper.checkAndSetMissingOrNull(result, (IPointable)this.argLeft, (IPointable)this.argRight)) {
            return;
        }
        this.leftVal.set(this.argLeft.getByteArray(), this.argLeft.getStartOffset() + 1, this.argLeft.getLength() - 1, ATypeTag.VALUE_TYPE_MAPPING[this.argLeft.getTag()]);
        this.rightVal.set(this.argRight.getByteArray(), this.argRight.getStartOffset() + 1, this.argRight.getLength() - 1, ATypeTag.VALUE_TYPE_MAPPING[this.argRight.getTag()]);
        this.evaluateImpl(result);
    }

    protected abstract void evaluateImpl(IPointable var1) throws HyracksDataException;

    final ILogicalBinaryComparator.Result compare() throws HyracksDataException {
        if (this.leftConstant != null) {
            return this.rightConstant != null ? this.logicalComparator.compare(this.leftConstant, this.rightConstant) : this.logicalComparator.compare(this.leftConstant, this.rightVal);
        }
        return this.rightConstant != null ? this.logicalComparator.compare(this.leftVal, this.rightConstant) : this.logicalComparator.compare(this.leftVal, this.rightVal);
    }

    final void writeMissing(IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.missingSerde.serialize((Object)AMissing.MISSING, this.out);
        result.set((IValueReference)this.resultStorage);
    }

    final void writeNull(IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.nullSerde.serialize((Object)ANull.NULL, this.out);
        result.set((IValueReference)this.resultStorage);
    }

    private static IAObject getConstant(byte[] bytes) {
        int start = 0;
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[start]);
        if (typeTag == null) {
            return null;
        }
        ++start;
        switch (typeTag) {
            case TINYINT: {
                return new AInt8(AInt8SerializerDeserializer.getByte((byte[])bytes, (int)start));
            }
            case SMALLINT: {
                return new AInt16(AInt16SerializerDeserializer.getShort((byte[])bytes, (int)start));
            }
            case INTEGER: {
                return new AInt32(AInt32SerializerDeserializer.getInt((byte[])bytes, (int)start));
            }
            case BIGINT: {
                return new AInt64(AInt64SerializerDeserializer.getLong((byte[])bytes, (int)start));
            }
            case FLOAT: {
                return new AFloat(AFloatSerializerDeserializer.getFloat((byte[])bytes, (int)start));
            }
            case DOUBLE: {
                return new ADouble(ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)start));
            }
        }
        return null;
    }
}

