/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.temporal.ADateParserFactory;
import org.apache.asterix.om.base.temporal.ATimeParserFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.constructors.AbstractConstructorEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

public abstract class AbstractDateTimeConstructorEvaluator
extends AbstractConstructorEvaluator {
    private final AMutableDateTime aDateTime = new AMutableDateTime(0L);
    private final ISerializerDeserializer<ADateTime> datetimeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
    private final UTF8StringPointable utf8Ptr = new UTF8StringPointable();

    protected AbstractDateTimeConstructorEvaluator(IEvaluatorContext ctx, IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        super(ctx, inputEval, sourceLoc);
    }

    @Override
    protected void evaluateImpl(IPointable result) throws HyracksDataException {
        byte[] bytes = this.inputArg.getByteArray();
        int startOffset = this.inputArg.getStartOffset();
        int len = this.inputArg.getLength();
        ATypeTag inputType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[startOffset]);
        switch (inputType) {
            case DATETIME: {
                result.set((IValueReference)this.inputArg);
                break;
            }
            case DATE: {
                int chrononInDays = ADateSerializerDeserializer.getChronon((byte[])bytes, (int)(startOffset + 1));
                this.aDateTime.setValue((long)chrononInDays * 86400000L);
                this.resultStorage.reset();
                this.datetimeSerde.serialize((Object)this.aDateTime, this.out);
                result.set((IValueReference)this.resultStorage);
                break;
            }
            case TIME: {
                int chronon = ATimeSerializerDeserializer.getChronon((byte[])bytes, (int)(startOffset + 1));
                this.aDateTime.setValue((long)chronon);
                this.resultStorage.reset();
                this.datetimeSerde.serialize((Object)this.aDateTime, this.out);
                result.set((IValueReference)this.resultStorage);
                break;
            }
            case STRING: {
                this.utf8Ptr.set(bytes, startOffset + 1, len - 1);
                if (this.parseDateTime(this.utf8Ptr, this.aDateTime)) {
                    this.resultStorage.reset();
                    this.datetimeSerde.serialize((Object)this.aDateTime, this.out);
                    result.set((IValueReference)this.resultStorage);
                    break;
                }
                this.handleParseError(this.utf8Ptr, result);
                break;
            }
            default: {
                this.handleUnsupportedType(inputType, result);
            }
        }
    }

    protected boolean parseDateTime(UTF8StringPointable textPtr, AMutableDateTime result) {
        int charStartOffset;
        int stringLength = textPtr.getUTF8Length();
        if (stringLength < 14) {
            return false;
        }
        byte[] bytes = textPtr.getByteArray();
        short timeOffset = (short)(bytes[charStartOffset = textPtr.getCharStartOffset()] == 45 ? 1 : 0);
        timeOffset = (short)(timeOffset + 8);
        if (bytes[charStartOffset + timeOffset] != 84 && bytes[charStartOffset + (timeOffset = (short)(timeOffset + 2))] != 84) {
            return false;
        }
        try {
            long chronon = ADateParserFactory.parseDatePart((byte[])bytes, (int)charStartOffset, (int)timeOffset);
            int timeInMs = ATimeParserFactory.parseTimePart((byte[])bytes, (int)(charStartOffset + timeOffset + 1), (int)(stringLength - timeOffset - 1));
            result.setValue(chronon += (long)timeInMs);
            return true;
        }
        catch (HyracksDataException e) {
            return false;
        }
    }

    @Override
    protected final BuiltinType getTargetType() {
        return BuiltinType.ADATETIME;
    }
}

