/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.io.DataOutput;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADurationSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADuration;
import org.apache.asterix.om.base.AMutableDuration;
import org.apache.asterix.om.base.temporal.DurationArithmeticOperations;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class CalendarDurationFromDateTimeDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final FunctionIdentifier FID = BuiltinFunctions.CALENDAR_DURATION_FROM_DATETIME;
    public static final IFunctionDescriptorFactory FACTORY = CalendarDurationFromDateTimeDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable argPtr0 = new VoidPointable();
                    private IPointable argPtr1 = new VoidPointable();
                    private IScalarEvaluator eval0;
                    private IScalarEvaluator eval1;
                    private ISerializerDeserializer<ADuration> durationSerde;
                    private AMutableDuration aDuration;
                    private GregorianCalendarSystem calInstanct;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.eval1 = args[1].createScalarEvaluator(ctx);
                        this.durationSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADURATION);
                        this.aDuration = new AMutableDuration(0, 0L);
                        this.calInstanct = GregorianCalendarSystem.getInstance();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        long endingTimePoint;
                        this.resultStorage.reset();
                        this.eval0.evaluate(tuple, this.argPtr0);
                        this.eval1.evaluate(tuple, this.argPtr1);
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.argPtr0, this.argPtr1)) {
                            return;
                        }
                        byte[] bytes0 = this.argPtr0.getByteArray();
                        int offset0 = this.argPtr0.getStartOffset();
                        byte[] bytes1 = this.argPtr1.getByteArray();
                        int offset1 = this.argPtr1.getStartOffset();
                        if (bytes0[offset0] != ATypeTag.SERIALIZED_DATETIME_TYPE_TAG) {
                            throw new TypeMismatchException(CalendarDurationFromDateTimeDescriptor.this.sourceLoc, CalendarDurationFromDateTimeDescriptor.this.getIdentifier(), 0, bytes0[offset0], ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
                        }
                        if (bytes1[offset1] != ATypeTag.SERIALIZED_DURATION_TYPE_TAG) {
                            throw new TypeMismatchException(CalendarDurationFromDateTimeDescriptor.this.sourceLoc, CalendarDurationFromDateTimeDescriptor.this.getIdentifier(), 1, bytes1[offset1], ATypeTag.SERIALIZED_DURATION_TYPE_TAG);
                        }
                        int yearMonthDurationInMonths = ADurationSerializerDeserializer.getYearMonth((byte[])bytes1, (int)(offset1 + 1));
                        long dayTimeDurationInMs = ADurationSerializerDeserializer.getDayTime((byte[])bytes1, (int)(offset1 + 1));
                        long startingTimePoint = ADateTimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                        if (startingTimePoint == (endingTimePoint = DurationArithmeticOperations.addDuration((long)startingTimePoint, (int)yearMonthDurationInMonths, (long)dayTimeDurationInMs, (boolean)false))) {
                            this.aDuration.setValue(0, 0L);
                        } else {
                            boolean negative = false;
                            if (endingTimePoint < startingTimePoint) {
                                negative = true;
                                long tmpTime = endingTimePoint;
                                endingTimePoint = startingTimePoint;
                                startingTimePoint = tmpTime;
                            }
                            int year0 = this.calInstanct.getYear(startingTimePoint);
                            int month0 = this.calInstanct.getMonthOfYear(startingTimePoint, year0);
                            int year1 = this.calInstanct.getYear(endingTimePoint);
                            int month1 = this.calInstanct.getMonthOfYear(endingTimePoint, year1);
                            int year = year1 - year0;
                            int month = month1 - month0;
                            int day = this.calInstanct.getDayOfMonthYear(endingTimePoint, year1, month1) - this.calInstanct.getDayOfMonthYear(startingTimePoint, year0, month0);
                            int hour = this.calInstanct.getHourOfDay(endingTimePoint) - this.calInstanct.getHourOfDay(startingTimePoint);
                            int min = this.calInstanct.getMinOfHour(endingTimePoint) - this.calInstanct.getMinOfHour(startingTimePoint);
                            int sec = this.calInstanct.getSecOfMin(endingTimePoint) - this.calInstanct.getSecOfMin(startingTimePoint);
                            int ms = this.calInstanct.getMillisOfSec(endingTimePoint) - this.calInstanct.getMillisOfSec(startingTimePoint);
                            if (ms < 0) {
                                ms = (int)((long)ms + 1000L);
                                --sec;
                            }
                            if (sec < 0) {
                                sec = (int)((long)sec + 60L);
                                --min;
                            }
                            if (min < 0) {
                                min = (int)((long)min + 60L);
                                --hour;
                            }
                            if (hour < 0) {
                                hour = (int)((long)hour + 24L);
                                --day;
                            }
                            if (day < 0) {
                                boolean isLeapYear = this.calInstanct.isLeapYear(year1);
                                day += isLeapYear ? GregorianCalendarSystem.DAYS_OF_MONTH_LEAP[(12 + month1 - 2) % 12] : GregorianCalendarSystem.DAYS_OF_MONTH_ORDI[(12 + month1 - 2) % 12];
                                --month;
                            }
                            if (month < 0) {
                                month += 12;
                                --year;
                            }
                            if (negative) {
                                this.aDuration.setValue(-1 * (year * 12 + month), -1L * ((long)day * 86400000L + (long)hour * 3600000L + (long)min * 60000L + (long)sec * 1000L + (long)ms));
                            } else {
                                this.aDuration.setValue(year * 12 + month, (long)day * 86400000L + (long)hour * 3600000L + (long)min * 60000L + (long)sec * 1000L + (long)ms);
                            }
                        }
                        this.durationSerde.serialize((Object)this.aDuration, this.out);
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return FID;
    }
}

