/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators.joins.interval;

import java.nio.ByteBuffer;
import org.apache.asterix.runtime.operators.joins.interval.IntervalMergeJoiner;
import org.apache.asterix.runtime.operators.joins.interval.utils.IIntervalJoinUtil;
import org.apache.asterix.runtime.operators.joins.interval.utils.IIntervalJoinUtilFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IActivityGraphBuilder;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.std.base.AbstractActivityNode;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractStateObject;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;

public class IntervalMergeJoinOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private static final int JOIN_BUILD_ACTIVITY_ID = 0;
    private static final int JOIN_PROBE_ACTIVITY_ID = 1;
    private final int buildKey;
    private final int probeKey;
    private final int memoryForJoin;
    private final IIntervalJoinUtilFactory imjcf;

    public IntervalMergeJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int memoryForJoin, int[] buildKey, int[] probeKeys, RecordDescriptor recordDescriptor, IIntervalJoinUtilFactory imjcf) {
        super(spec, 2, 1);
        this.outRecDescs[0] = recordDescriptor;
        this.buildKey = buildKey[0];
        this.probeKey = probeKeys[0];
        this.memoryForJoin = memoryForJoin;
        this.imjcf = imjcf;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        ActivityId buildAid = new ActivityId(this.odId, 0);
        ActivityId probeAid = new ActivityId(this.odId, 1);
        JoinProbeActivityNode probeAN = new JoinProbeActivityNode(probeAid);
        JoinBuildActivityNode buildAN = new JoinBuildActivityNode(buildAid, probeAid);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)buildAN);
        builder.addSourceEdge(0, (IActivity)buildAN, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)probeAN);
        builder.addSourceEdge(1, (IActivity)probeAN, 0);
        builder.addTargetEdge(0, (IActivity)probeAN, 0);
        builder.addBlockingEdge((IActivity)buildAN, (IActivity)probeAN);
    }

    private class JoinProbeActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public JoinProbeActivityNode(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            return new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
                private JoinCacheTaskState state;

                public void open() throws HyracksDataException {
                    this.writer.open();
                    this.state = (JoinCacheTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(IntervalMergeJoinOperatorDescriptor.this.getOperatorId(), 0), partition));
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.state.joiner.processProbeFrame(buffer, this.writer);
                }

                public void close() throws HyracksDataException {
                    try {
                        this.state.joiner.processProbeClose(this.writer);
                    }
                    finally {
                        this.writer.close();
                    }
                }

                public void fail() throws HyracksDataException {
                    this.writer.fail();
                }
            };
        }
    }

    private class JoinBuildActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;
        private final ActivityId nljAid;

        public JoinBuildActivityNode(ActivityId id, ActivityId nljAid) {
            super(id);
            this.nljAid = nljAid;
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, final int nPartitions) {
            final RecordDescriptor probeRd = recordDescProvider.getInputRecordDescriptor(this.nljAid, 0);
            final RecordDescriptor buildRd = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
            return new AbstractUnaryInputSinkOperatorNodePushable(){
                private JoinCacheTaskState state;

                public void open() throws HyracksDataException {
                    this.state = new JoinCacheTaskState(ctx.getJobletContext().getJobId(), new TaskId(JoinBuildActivityNode.this.getActivityId(), partition));
                    IIntervalJoinUtil imjc = IntervalMergeJoinOperatorDescriptor.this.imjcf.createIntervalMergeJoinUtil(IntervalMergeJoinOperatorDescriptor.this.buildKey, IntervalMergeJoinOperatorDescriptor.this.probeKey, ctx, nPartitions);
                    this.state.joiner = new IntervalMergeJoiner(ctx, IntervalMergeJoinOperatorDescriptor.this.memoryForJoin, imjc, IntervalMergeJoinOperatorDescriptor.this.buildKey, IntervalMergeJoinOperatorDescriptor.this.probeKey, buildRd, probeRd);
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    ByteBuffer copyBuffer = ctx.allocateFrame(buffer.capacity());
                    FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)copyBuffer);
                    this.state.joiner.processBuildFrame(copyBuffer);
                }

                public void close() throws HyracksDataException {
                    this.state.joiner.processBuildClose();
                    ctx.setStateObject((IStateObject)this.state);
                }

                public void fail() {
                }
            };
        }
    }

    public static class JoinCacheTaskState
    extends AbstractStateObject {
        private IntervalMergeJoiner joiner;

        private JoinCacheTaskState(JobId jobId, TaskId taskId) {
            super(jobId, (Object)taskId);
        }
    }
}

