/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.messaging;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.replication.api.IReplicaTask;
import org.apache.asterix.replication.api.IReplicationWorker;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeletePartitionTask
implements IReplicaTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int partitionId;

    public DeletePartitionTask(int partitionId) {
        this.partitionId = partitionId;
    }

    @Override
    public void perform(INcApplicationContext appCtx, IReplicationWorker worker) {
        try {
            PersistentLocalResourceRepository localResourceRepository = (PersistentLocalResourceRepository)appCtx.getLocalResourceRepository();
            LOGGER.warn("deleting storage partition {}", (Object)this.partitionId);
            localResourceRepository.deletePartition(this.partitionId);
            ReplicationProtocol.sendAck(worker.getChannel(), worker.getReusableBuffer());
        }
        catch (Exception e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    @Override
    public ReplicationProtocol.ReplicationRequestType getMessageType() {
        return ReplicationProtocol.ReplicationRequestType.DELETE_PARTITION;
    }

    @Override
    public void serialize(OutputStream out) throws HyracksDataException {
        try {
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeInt(this.partitionId);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static DeletePartitionTask create(DataInput input) throws IOException {
        return new DeletePartitionTask(input.readInt());
    }
}

