/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.management;

import java.io.Serializable;
import java.util.List;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.commons.lang3.StringUtils;

public class FeedConnectionRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final FeedUtils.FeedRuntimeType connectionLocation;
    private final List<FunctionSignature> functionsToApply;
    private final String policy;
    private final String targetDataset;
    private final EntityId receivingFeedId;

    public FeedConnectionRequest(FeedUtils.FeedRuntimeType connectionLocation, List<FunctionSignature> functionsToApply, String targetDataset, String policy, EntityId receivingFeedId) {
        this.connectionLocation = connectionLocation;
        this.functionsToApply = functionsToApply;
        this.targetDataset = targetDataset;
        this.policy = policy;
        this.receivingFeedId = receivingFeedId;
    }

    public String getPolicy() {
        return this.policy;
    }

    public String getTargetDataset() {
        return this.targetDataset;
    }

    public FeedUtils.FeedRuntimeType getSubscriptionLocation() {
        return this.connectionLocation;
    }

    public EntityId getReceivingFeedId() {
        return this.receivingFeedId;
    }

    public List<FunctionSignature> getFunctionsToApply() {
        return this.functionsToApply;
    }

    public String toString() {
        return "Feed Connection Request " + this.receivingFeedId + " [" + this.connectionLocation + "] Apply (" + StringUtils.join(this.functionsToApply, (String)",") + ")";
    }
}

