/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.msgpack;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class MessagePackUtils {
    public static ATypeTag peekUnknown(IAType type) {
        switch (type.getTypeTag()) {
            case MISSING: 
            case NULL: {
                return type.getTypeTag();
            }
        }
        return ATypeTag.TYPE;
    }

    public static void packFixPos(ByteBuffer buf, byte in) throws HyracksDataException {
        int mask = -128;
        if ((in & mask) != 0) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"fixint7 must be positive"});
        }
        buf.put(in);
    }

    public static void packFixStr(ByteBuffer buf, String in) throws HyracksDataException {
        byte[] strBytes = in.getBytes(StandardCharsets.UTF_8);
        if (strBytes.length > 31) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"fixint7 must be positive"});
        }
        buf.put((byte)(-96 + strBytes.length));
        buf.put(strBytes);
    }

    public static void packStr(ByteBuffer out, String in) {
        out.put((byte)-37);
        byte[] strBytes = in.getBytes(StandardCharsets.UTF_8);
        out.putInt(strBytes.length);
        out.put(strBytes);
    }

    public static void packFixArrayHeader(ByteBuffer buf, byte numObj) {
        buf.put((byte)(-112 + (0xF & numObj)));
    }
}

