/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.context.FunctionSignatures;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.parser.ScopeChecker;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.commons.collections4.iterators.ReverseListIterator;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.SourceLocation;

public final class Scope {
    private final ScopeChecker scopeChecker;
    private final Scope parent;
    private final LinkedHashMap<String, Pair<Identifier, Set<? extends SymbolAnnotation>>> symbols;
    private final boolean maskParentScope;
    private FunctionSignatures functionSignatures;

    public Scope(ScopeChecker scopeChecker) {
        this(scopeChecker, null);
    }

    public Scope(ScopeChecker scopeChecker, Scope parent) {
        this(scopeChecker, parent, false);
    }

    public Scope(ScopeChecker scopeChecker, Scope parent, boolean maskParentScope) {
        this.scopeChecker = scopeChecker;
        this.parent = parent;
        this.maskParentScope = maskParentScope;
        this.symbols = new LinkedHashMap();
    }

    public Pair<Identifier, Set<? extends SymbolAnnotation>> findSymbol(String name) {
        Pair<Identifier, Set<? extends SymbolAnnotation>> symbol = this.symbols.get(name);
        if (symbol == null && !this.maskParentScope && this.parent != null) {
            symbol = this.parent.findSymbol(name);
        }
        return symbol;
    }

    public Pair<Identifier, Set<? extends SymbolAnnotation>> findLocalSymbol(String name) {
        return this.symbols.get(name);
    }

    public void addSymbolToScope(Identifier ident) {
        this.addSymbolToScope(ident, null);
    }

    public void addSymbolToScope(Identifier ident, Set<? extends SymbolAnnotation> annotations) {
        if (annotations == null) {
            annotations = Collections.emptySet();
        }
        this.symbols.put(ident.getValue(), (Pair<Identifier, Set<? extends SymbolAnnotation>>)new Pair((Object)ident, annotations));
    }

    public void addNewVarSymbolToScope(VarIdentifier ident) {
        this.addNewVarSymbolToScope(ident, null);
    }

    public void addNewVarSymbolToScope(VarIdentifier ident, Set<? extends SymbolAnnotation> annotations) {
        this.scopeChecker.incVarCounter();
        ident.setId(this.scopeChecker.getVarCounter());
        this.addSymbolToScope(ident, annotations);
    }

    public void addFunctionDescriptor(FunctionSignature signature, boolean varargs) {
        if (this.functionSignatures == null) {
            this.functionSignatures = new FunctionSignatures();
        }
        this.functionSignatures.put(signature, varargs);
    }

    public FunctionSignature findFunctionSignature(DataverseName dataverseName, String name, int arity) {
        FunctionSignature fd = null;
        if (this.functionSignatures != null) {
            fd = this.functionSignatures.get(dataverseName, name, arity);
        }
        if (fd == null && this.parent != null) {
            fd = this.parent.findFunctionSignature(dataverseName, name, arity);
        }
        return fd;
    }

    public void merge(Scope scope) {
        this.symbols.putAll(scope.symbols);
        if (this.functionSignatures != null && scope.functionSignatures != null) {
            this.functionSignatures.addAll(scope.functionSignatures);
        }
    }

    public Iterator<Pair<Identifier, Set<? extends SymbolAnnotation>>> liveSymbols(Scope stopAtExclusive) {
        ReverseListIterator identifierIterator = new ReverseListIterator(new ArrayList<Pair<Identifier, Set<? extends SymbolAnnotation>>>(this.symbols.values()));
        Iterator<Pair<Identifier, Set<? extends SymbolAnnotation>>> parentIterator = this.parent == null || this.parent == stopAtExclusive ? null : this.parent.liveSymbols(stopAtExclusive);
        return new Iterator<Pair<Identifier, Set<? extends SymbolAnnotation>>>(){
            private Pair<Identifier, Set<? extends SymbolAnnotation>> currentSymbol = null;
            final /* synthetic */ Iterator val$identifierIterator;
            final /* synthetic */ Iterator val$parentIterator;
            {
                this.val$identifierIterator = iterator;
                this.val$parentIterator = iterator2;
            }

            @Override
            public boolean hasNext() {
                this.currentSymbol = null;
                if (this.val$identifierIterator.hasNext()) {
                    this.currentSymbol = (Pair)this.val$identifierIterator.next();
                } else if (!Scope.this.maskParentScope && this.val$parentIterator != null && this.val$parentIterator.hasNext()) {
                    do {
                        Pair symbolFromParent = (Pair)this.val$parentIterator.next();
                        if (Scope.this.symbols.containsKey(((Identifier)symbolFromParent.first).getValue())) continue;
                        this.currentSymbol = symbolFromParent;
                        break;
                    } while (this.val$parentIterator.hasNext());
                }
                return this.currentSymbol != null;
            }

            @Override
            public Pair<Identifier, Set<? extends SymbolAnnotation>> next() {
                if (this.currentSymbol == null) {
                    throw new IllegalStateException("Please make sure that hasNext() returns true before calling next().");
                }
                return this.currentSymbol;
            }
        };
    }

    public Map<VariableExpr, Set<? extends SymbolAnnotation>> getLiveVariables() {
        return this.getLiveVariables(null);
    }

    public Map<VariableExpr, Set<? extends SymbolAnnotation>> getLiveVariables(Scope stopAtExclusive) {
        LinkedHashMap<VariableExpr, Set<? extends SymbolAnnotation>> vars = new LinkedHashMap<VariableExpr, Set<? extends SymbolAnnotation>>();
        Iterator<Pair<Identifier, Set<? extends SymbolAnnotation>>> symbolIterator = this.liveSymbols(stopAtExclusive);
        while (symbolIterator.hasNext()) {
            Pair<Identifier, Set<? extends SymbolAnnotation>> p = symbolIterator.next();
            Identifier identifier = (Identifier)p.first;
            if (!(identifier instanceof VarIdentifier)) continue;
            VarIdentifier varId = (VarIdentifier)identifier;
            vars.put(new VariableExpr(varId), (Set)p.second);
        }
        return vars;
    }

    public static Set<VariableExpr> findVariablesAnnotatedBy(Set<VariableExpr> candidateVars, SymbolAnnotation annotationTest, Map<VariableExpr, Set<? extends SymbolAnnotation>> annotationMap, SourceLocation sourceLoc) throws CompilationException {
        HashSet<VariableExpr> resultVars = new HashSet<VariableExpr>();
        for (VariableExpr var : candidateVars) {
            Set<? extends SymbolAnnotation> varAnnotations = annotationMap.get(var);
            if (varAnnotations == null) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[0]);
            }
            if (!varAnnotations.contains(annotationTest)) continue;
            resultVars.add(var);
        }
        return resultVars;
    }

    public Set<String> getLocalSymbols() {
        return this.symbols.keySet();
    }

    public Scope getParentScope() {
        return this.parent;
    }

    public static interface SymbolAnnotation {
    }
}

