/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.saml;

import javax.security.auth.callback.CallbackHandler;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.TrustException;
import org.apache.rahas.impl.util.SAML2KeyInfo;
import org.apache.rahas.impl.util.SAML2Utils;
import org.apache.rampart.TokenCallbackHandler;
import org.apache.rampart.saml.SAMLAssertionHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.handler.RequestData;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;

public class SAML2AssertionHandler
extends SAMLAssertionHandler {
    private static final Log log = LogFactory.getLog(SAML2AssertionHandler.class);
    private Assertion assertion;

    public SAML2AssertionHandler(Assertion samlAssertion) {
        this.assertion = samlAssertion;
        this.processSAMLAssertion();
    }

    @Override
    public boolean isBearerAssertion() {
        return SAML2Utils.getSAML2SubjectConfirmationMethod((Assertion)this.assertion).equals("urn:oasis:names:tc:SAML:2.0:cm:bearer");
    }

    @Override
    protected void processSAMLAssertion() {
        this.setAssertionId(this.assertion.getID());
        Subject subject = this.assertion.getSubject();
        if (this.assertion.getConditions() != null) {
            Conditions conditions = this.assertion.getConditions();
            if (conditions.getNotBefore() != null) {
                this.setDateNotBefore(conditions.getNotBefore());
            }
            if (conditions.getNotOnOrAfter() != null) {
                this.setDateNotOnOrAfter(conditions.getNotOnOrAfter());
            }
        } else {
            SubjectConfirmationData scData = ((SubjectConfirmation)subject.getSubjectConfirmations().get(0)).getSubjectConfirmationData();
            if (scData.getNotBefore() != null) {
                this.setDateNotBefore(scData.getNotBefore());
            }
            if (scData.getNotOnOrAfter() != null) {
                this.setDateNotOnOrAfter(scData.getNotOnOrAfter());
            }
        }
    }

    @Override
    public byte[] getAssertionKeyInfoSecret(Crypto signatureCrypto, TokenCallbackHandler tokenCallbackHandler, RequestData requestData) throws WSSecurityException {
        SAML2KeyInfo saml2KeyInfo = SAML2Utils.getSAML2KeyInfo((Assertion)this.assertion, (Crypto)signatureCrypto, (CallbackHandler)tokenCallbackHandler, (RequestData)requestData);
        return saml2KeyInfo.getSecret();
    }

    @Override
    public OMElement getAssertionElement() throws TrustException {
        try {
            return (OMElement)SAML2Utils.getElementFromAssertion((XMLObject)this.assertion);
        }
        catch (TrustException e) {
            log.error((Object)"Error getting Axiom representation of SAML2 assertion.", (Throwable)e);
            throw e;
        }
    }
}

