/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.ConfigurationErrorListenerImpl;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationFactory;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.StrictConfigurationComparator;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.apache.commons.configuration.reloading.FileAlwaysReloadingStrategy;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestFileConfiguration {
    private static final String TEST_FILENAME = "test.properties";
    private static final File TEST_FILE = ConfigurationAssert.getTestFile("test.properties");
    private static final File OUT_FILE = new File("target/test-resources/foo/bar/test.properties");
    private static final String RESOURCE_NAME = "config/deep/deeptest.properties";
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        TestFileConfiguration.removeOutFile();
    }

    protected void tearDown() throws Exception {
        TestFileConfiguration.removeOutFile();
    }

    private static void removeFile(File file) {
        if (file.exists()) {
            Assert.assertTrue((String)("Cannot remove file: " + file), (boolean)file.delete());
        }
    }

    private static void removeOutFile() {
        TestFileConfiguration.removeFile(OUT_FILE);
        File parent = OUT_FILE.getParentFile();
        TestFileConfiguration.removeFile(parent);
        parent = parent.getParentFile();
        TestFileConfiguration.removeFile(parent);
    }

    @Test
    public void testSetURL() throws Exception {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setURL(new URL("http://commons.apache.org/configuration/index.html"));
        Assert.assertEquals((String)"base path", (Object)"http://commons.apache.org/configuration/", (Object)config.getBasePath());
        Assert.assertEquals((String)"file name", (Object)"index.html", (Object)config.getFileName());
        config.setURL(new URL("file:/temp/test.properties"));
        Assert.assertEquals((String)"base path", (Object)"file:///temp/", (Object)config.getBasePath());
        Assert.assertEquals((String)"file name", (Object)TEST_FILENAME, (Object)config.getFileName());
    }

    @Test
    public void testSetURLWithParams() throws Exception {
        PropertiesConfiguration config = new PropertiesConfiguration();
        URL url = new URL("http://issues.apache.org/bugzilla/show_bug.cgi?id=37886");
        config.setURL(url);
        Assert.assertEquals((String)"Base path incorrect", (Object)"http://issues.apache.org/bugzilla/", (Object)config.getBasePath());
        Assert.assertEquals((String)"File name incorrect", (Object)"show_bug.cgi", (Object)config.getFileName());
        Assert.assertEquals((String)"URL was not correctly stored", (Object)url, (Object)config.getURL());
    }

    @Test
    public void testLocations() throws Exception {
        PropertiesConfiguration config = new PropertiesConfiguration();
        File directory = ConfigurationAssert.TEST_DIR;
        File file = TEST_FILE;
        config.setFile(file);
        Assert.assertEquals((Object)directory.getAbsolutePath(), (Object)config.getBasePath());
        Assert.assertEquals((Object)TEST_FILENAME, (Object)config.getFileName());
        Assert.assertEquals((Object)file.getAbsolutePath(), (Object)config.getPath());
        config.setPath("target/test-classes" + File.separator + TEST_FILENAME);
        Assert.assertEquals((Object)TEST_FILENAME, (Object)config.getFileName());
        Assert.assertEquals((Object)directory.getAbsolutePath(), (Object)config.getBasePath());
        Assert.assertEquals((Object)file.getAbsolutePath(), (Object)config.getPath());
        Assert.assertEquals((Object)file.toURI().toURL(), (Object)config.getURL());
        config.setBasePath(null);
        config.setFileName(TEST_FILENAME);
        Assert.assertNull((Object)config.getBasePath());
        Assert.assertEquals((Object)TEST_FILENAME, (Object)config.getFileName());
    }

    @Test
    public void testCreateFile1() throws Exception {
        Assert.assertFalse((String)"The file should not exist", (boolean)OUT_FILE.exists());
        PropertiesConfiguration config = new PropertiesConfiguration(OUT_FILE);
        config.save();
        Assert.assertTrue((String)"The file doesn't exist", (boolean)OUT_FILE.exists());
    }

    @Test
    public void testCreateFile2() throws Exception {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setFile(OUT_FILE);
        config.save();
        Assert.assertTrue((String)"The file doesn't exist", (boolean)OUT_FILE.exists());
    }

    @Test
    public void testCreateFile3() throws Exception {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.save(OUT_FILE);
        Assert.assertTrue((String)"The file doesn't exist", (boolean)OUT_FILE.exists());
    }

    @Test
    public void testWithConfigurationFactory() throws Exception {
        File file = this.folder.newFile();
        ConfigurationFactory factory = new ConfigurationFactory();
        factory.setConfigurationURL(ConfigurationAssert.getTestURL("testDigesterConfiguration2.xml"));
        CompositeConfiguration cc = (CompositeConfiguration)factory.getConfiguration();
        PropertiesConfiguration config = null;
        int i = 0;
        while (config == null) {
            if (cc.getConfiguration(i) instanceof PropertiesConfiguration) {
                config = (PropertiesConfiguration)cc.getConfiguration(i);
            }
            ++i;
        }
        config.setProperty("test", (Object)"yes");
        config.save(file);
        Assert.assertTrue((boolean)file.exists());
        config = new PropertiesConfiguration();
        config.setFile(file);
        config.load();
        Assert.assertEquals((Object)"yes", (Object)config.getProperty("test"));
        Assert.assertEquals((Object)"masterOfPost", (Object)config.getProperty("mail.account.user"));
    }

    @Test(expected=ConfigurationException.class)
    public void testSaveInvalidURL() throws Exception {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.save(new URL("http://jakarta.apache.org/test.properties"));
    }

    @Test(expected=ConfigurationException.class)
    public void testSaveInvalidURLString() throws ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.save("http://www.apache.org/test.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileOverwrite() throws Exception {
        FileOutputStream out = null;
        FileInputStream in = null;
        File tempFile = null;
        try {
            tempFile = this.folder.newFile();
            Properties props = new Properties();
            props.setProperty("1", "one");
            out = new FileOutputStream(tempFile);
            props.store(out, "TestFileOverwrite");
            out.close();
            out = null;
            PropertiesConfiguration config = new PropertiesConfiguration(tempFile);
            config.load();
            String value = config.getString("1");
            Assert.assertTrue((boolean)"one".equals(value));
            config.setProperty("1", (Object)"two");
            config.save();
            props = new Properties();
            in = new FileInputStream(tempFile);
            props.load(in);
            String value2 = props.getProperty("1");
            Assert.assertTrue((boolean)"two".equals(value2));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReloadingWithAutoSave() throws Exception {
        File configFile = this.folder.newFile();
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(configFile));
            out.println("a = one");
            out.close();
            out = null;
            PropertiesConfiguration config = new PropertiesConfiguration(configFile);
            config.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
            config.setAutoSave(true);
            Assert.assertEquals((Object)"one", (Object)config.getProperty("a"));
            config.setProperty("b", (Object)"two");
            Assert.assertEquals((Object)"one", (Object)config.getProperty("a"));
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPathWithSpaces() throws Exception {
        File path = this.folder.newFolder("path with spaces");
        File confFile = new File(path, "config-test.properties");
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(confFile));
            out.println("saved = false");
            out.close();
            out = null;
            URL url = confFile.toURI().toURL();
            PropertiesConfiguration config = new PropertiesConfiguration(url);
            config.load();
            Assert.assertFalse((boolean)config.getBoolean("saved"));
            config.setProperty("saved", (Object)Boolean.TRUE);
            config.save();
            config = new PropertiesConfiguration();
            config.setFile(confFile);
            config.load();
            Assert.assertTrue((boolean)config.getBoolean("saved"));
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    @Test
    public void testPathWithPlus() throws ConfigurationException, IOException {
        File saveFile = this.folder.newFile("test+config.properties");
        PropertiesConfiguration config = new PropertiesConfiguration(saveFile);
        config.addProperty("test", (Object)Boolean.TRUE);
        config.save();
        File configFile = config.getFile();
        Assert.assertEquals((String)"Wrong configuration file", (Object)saveFile, (Object)configFile);
    }

    @Test
    public void testGetFile() throws ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Assert.assertNull((Object)config.getFile());
        File file = TEST_FILE.getAbsoluteFile();
        config.setFile(file);
        Assert.assertEquals((Object)file, (Object)config.getFile());
        config.load();
        Assert.assertEquals((Object)file, (Object)config.getFile());
    }

    @Test
    public void testGetFileAfterLoad() throws ConfigurationException, IOException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.load(TEST_FILE.getAbsolutePath());
        Assert.assertNotNull((String)"No source URL set", (Object)config.getURL());
        Assert.assertEquals((String)"Wrong source file", (Object)TEST_FILE.getCanonicalFile(), (Object)config.getFile().getCanonicalFile());
    }

    @Test
    public void testLoadMultiple() throws ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.load(TEST_FILE.getAbsolutePath());
        URL srcUrl = config.getURL();
        File srcFile = config.getFile();
        File file2 = ConfigurationAssert.getTestFile("testEqual.properties");
        config.load(file2.getAbsolutePath());
        Assert.assertEquals((String)"Source URL was changed", (Object)srcUrl, (Object)config.getURL());
        Assert.assertEquals((String)"Source file was changed", (Object)srcFile, (Object)config.getFile());
    }

    @Test(expected=ConfigurationException.class)
    public void testSaveWithoutFileNameFile() throws Exception {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.load(TEST_FILE);
        config.save();
    }

    @Test(expected=ConfigurationException.class)
    public void testSaveWithoutFileNameURL() throws Exception {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.load(TEST_FILE.toURI().toURL());
        config.save();
    }

    @Test(expected=ConfigurationException.class)
    public void testLoadDirectoryString() throws ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.load("target");
    }

    @Test(expected=ConfigurationException.class)
    public void testLoadDirectoryFile() throws ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.load(new File("target"));
    }

    @Test(expected=ConfigurationException.class)
    public void testLoadDirectoryConstrString() throws ConfigurationException {
        new PropertiesConfiguration("target");
    }

    @Test(expected=ConfigurationException.class)
    public void testLoadDirectoryConstrFile() throws ConfigurationException {
        new PropertiesConfiguration(new File("target"));
    }

    @Test
    public void testInitFromClassPath() throws ConfigurationException {
        PropertiesConfiguration config1 = new PropertiesConfiguration();
        config1.setFileName(RESOURCE_NAME);
        config1.load();
        PropertiesConfiguration config2 = new PropertiesConfiguration(RESOURCE_NAME);
        this.compare((Configuration)config1, (Configuration)config2);
    }

    @Test
    public void testLoadFromClassPath() throws ConfigurationException {
        DefaultConfigurationBuilder cf = new DefaultConfigurationBuilder("config/deep/testFileFromClasspath.xml");
        CombinedConfiguration config = cf.getConfiguration(true);
        Configuration config1 = config.getConfiguration("propConf");
        Configuration config2 = config.getConfiguration("propConfDeep");
        this.compare(config1, config2);
    }

    @Test
    public void testClone() throws ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration(RESOURCE_NAME);
        PropertiesConfiguration copy = (PropertiesConfiguration)config.clone();
        this.compare((Configuration)config, (Configuration)copy);
        Assert.assertNull((String)"URL was not reset", (Object)copy.getURL());
        Assert.assertNull((String)"Base path was not reset", (Object)copy.getBasePath());
        Assert.assertNull((String)"File name was not reset", (Object)copy.getFileName());
        Assert.assertNotSame((String)"Reloading strategy was not reset", (Object)config.getReloadingStrategy(), (Object)copy.getReloadingStrategy());
    }

    @Test
    public void testLogErrorListener() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Assert.assertEquals((String)"No error log listener registered", (long)1L, (long)config.getErrorListeners().size());
    }

    @Test
    public void testReloadError() throws ConfigurationException {
        ConfigurationErrorListenerImpl l = new ConfigurationErrorListenerImpl();
        PropertiesConfiguration config = new PropertiesConfiguration(RESOURCE_NAME);
        config.clearErrorListeners();
        config.addErrorListener((ConfigurationErrorListener)l);
        config.setReloadingStrategy((ReloadingStrategy)new FileAlwaysReloadingStrategy());
        config.getString("test");
        config.setFileName("Not existing file");
        config.getString("test");
        l.verify(20, null, null);
        Assert.assertNotNull((String)"Exception is not set", (Object)l.getLastEvent().getCause());
    }

    @Test
    public void testIterationWithReloadFlat() throws ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration(TEST_FILE);
        this.checkIterationWithReload((FileConfiguration)config);
    }

    @Test
    public void testIterationWithReloadHierarchical() throws ConfigurationException {
        XMLConfiguration config = new XMLConfiguration("test.xml");
        this.checkIterationWithReload((FileConfiguration)config);
    }

    @Test
    public void testRefresh() throws ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration(TEST_FILE);
        Assert.assertEquals((String)"Wrong value", (long)10L, (long)config.getInt("test.integer"));
        config.setProperty("test.integer", (Object)new Integer(42));
        Assert.assertEquals((String)"Wrong value after update", (long)42L, (long)config.getInt("test.integer"));
        config.refresh();
        Assert.assertEquals((String)"Wrong value after refresh", (long)10L, (long)config.getInt("test.integer"));
    }

    @Test(expected=ConfigurationException.class)
    public void testRefreshNoFile() throws ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.refresh();
    }

    private void checkIterationWithReload(FileConfiguration config) {
        config.setReloadingStrategy((ReloadingStrategy)new FileAlwaysReloadingStrategy());
        Iterator it = config.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assert.assertNotNull((String)("No value for key " + key), (Object)config.getProperty(key));
        }
    }

    private void compare(Configuration config1, Configuration config2) {
        StrictConfigurationComparator cc = new StrictConfigurationComparator();
        Assert.assertTrue((String)"Configurations are different", (boolean)cc.compare(config1, config2));
    }
}

