/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.RFC2231Utility;
import org.junit.Assert;
import org.junit.Test;

public final class RFC2231UtilityTestCase {
    private static void assertEncoded(String expected, String encoded) throws Exception {
        Assert.assertEquals((Object)expected, (Object)RFC2231Utility.decodeText((String)encoded));
    }

    @Test(expected=UnsupportedEncodingException.class)
    public void decodeInvalidEncoding() throws Exception {
        RFC2231Utility.decodeText((String)"abc'en'hello");
    }

    @Test
    public void decodeIso88591() throws Exception {
        RFC2231UtilityTestCase.assertEncoded("\u00a3 rate", "iso-8859-1'en'%A3%20rate");
    }

    @Test
    public void decodeUtf8() throws Exception {
        RFC2231UtilityTestCase.assertEncoded("\u00a3 and \u20ac rates", "UTF-8''%c2%a3%20and%20%e2%82%ac%20rates");
    }

    @Test
    public void noNeedToDecode() throws Exception {
        RFC2231UtilityTestCase.assertEncoded("abc", "abc");
    }

    @Test
    public void testHasEncodedValue() {
        String nameWithAsteriskAtEnd = "paramname*";
        Assert.assertTrue((boolean)RFC2231Utility.hasEncodedValue((String)"paramname*"));
        String nameWithAsteriskNotAtEnd = "param*name";
        Assert.assertFalse((boolean)RFC2231Utility.hasEncodedValue((String)"param*name"));
        String nameWithoutAsterisk = "paramname";
        Assert.assertFalse((boolean)RFC2231Utility.hasEncodedValue((String)"paramname"));
    }

    @Test
    public void testStripDelimiter() {
        String nameWithAsteriskAtEnd = "paramname*";
        Assert.assertEquals((Object)"paramname", (Object)RFC2231Utility.stripDelimiter((String)"paramname*"));
        String nameWithAsteriskNotAtEnd = "param*name";
        Assert.assertEquals((Object)"param*name", (Object)RFC2231Utility.stripDelimiter((String)"param*name"));
        String nameWithTwoAsterisks = "param*name*";
        Assert.assertEquals((Object)"param*name", (Object)RFC2231Utility.stripDelimiter((String)"param*name*"));
        String nameWithoutAsterisk = "paramname";
        Assert.assertEquals((Object)"paramname", (Object)RFC2231Utility.stripDelimiter((String)"paramname"));
    }
}

