/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.twod;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.AbstractConvexHyperplaneBoundedRegion;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.spherical.twod.BoundarySource2S;
import org.apache.commons.geometry.spherical.twod.GreatArc;
import org.apache.commons.geometry.spherical.twod.GreatArcPath;
import org.apache.commons.geometry.spherical.twod.GreatCircle;
import org.apache.commons.geometry.spherical.twod.GreatCircleSubset;
import org.apache.commons.geometry.spherical.twod.GreatCircles;
import org.apache.commons.geometry.spherical.twod.InteriorAngleGreatArcConnector;
import org.apache.commons.geometry.spherical.twod.Point2S;
import org.apache.commons.geometry.spherical.twod.RegionBSPTree2S;
import org.apache.commons.numbers.core.Precision;

public final class ConvexArea2S
extends AbstractConvexHyperplaneBoundedRegion<Point2S, GreatArc>
implements BoundarySource2S {
    private static final ConvexArea2S FULL = new ConvexArea2S(Collections.emptyList());
    private static final double FULL_SIZE = Math.PI * 4;
    private static final double HALF_SIZE = Math.PI * 2;
    private static final double TRIANGLE_FAN_CENTROID_COMPUTE_THRESHOLD = 0.01;

    private ConvexArea2S(List<GreatArc> boundaries) {
        super(boundaries);
    }

    public Stream<GreatArc> boundaryStream() {
        return this.getBoundaries().stream();
    }

    public GreatArcPath getBoundaryPath() {
        List<GreatArcPath> paths = InteriorAngleGreatArcConnector.connectMinimized(this.getBoundaries());
        if (paths.isEmpty()) {
            return GreatArcPath.empty();
        }
        return paths.get(0);
    }

    public double[] getInteriorAngles() {
        List<GreatArc> arcs = this.getBoundaryPath().getArcs();
        int numSides = arcs.size();
        if (numSides < 2) {
            return new double[0];
        }
        double[] angles = new double[numSides];
        for (int i = 0; i < numSides; ++i) {
            GreatArc current = arcs.get(i);
            GreatArc next = arcs.get((i + 1) % numSides);
            angles[i] = Math.PI - current.getCircle().angle(next.getCircle(), current.getEndPoint());
        }
        return angles;
    }

    public double getSize() {
        int numSides = this.getBoundaries().size();
        if (numSides == 0) {
            return Math.PI * 4;
        }
        if (numSides == 1) {
            return Math.PI * 2;
        }
        double[] angles = this.getInteriorAngles();
        double sum = Arrays.stream(angles).sum();
        return sum - (double)(angles.length - 2) * Math.PI;
    }

    public Point2S getCentroid() {
        Vector3D weighted = this.getWeightedCentroidVector();
        return weighted == null ? null : Point2S.from(weighted);
    }

    Vector3D getWeightedCentroidVector() {
        List arcs = this.getBoundaries();
        int numBoundaries = arcs.size();
        switch (numBoundaries) {
            case 0: {
                return null;
            }
            case 1: {
                return ConvexArea2S.computeHemisphereWeightedCentroidVector((GreatArc)arcs.get(0));
            }
            case 2: {
                return ConvexArea2S.computeLuneWeightedCentroidVector((GreatArc)arcs.get(0), (GreatArc)arcs.get(1));
            }
        }
        if (this.getBoundarySize() < 0.01) {
            return ConvexArea2S.computeTriangleFanWeightedCentroidVector(arcs);
        }
        return ConvexArea2S.computeArcPoleWeightedCentroidVector(arcs);
    }

    public Split<ConvexArea2S> split(Hyperplane<Point2S> splitter) {
        return this.splitInternal(splitter, this, GreatArc.class, ConvexArea2S::new);
    }

    @Override
    public RegionBSPTree2S toTree() {
        return RegionBSPTree2S.from(this.getBoundaries(), true);
    }

    public ConvexArea2S transform(Transform<Point2S> transform) {
        return (ConvexArea2S)this.transformInternal(transform, this, GreatArc.class, ConvexArea2S::new);
    }

    public GreatArc trim(HyperplaneConvexSubset<Point2S> sub) {
        return (GreatArc)super.trim(sub);
    }

    public static ConvexArea2S full() {
        return FULL;
    }

    public static ConvexArea2S fromVertices(Collection<Point2S> vertices, Precision.DoubleEquivalence precision) {
        return ConvexArea2S.fromVertices(vertices, false, precision);
    }

    public static ConvexArea2S fromVertexLoop(Collection<Point2S> vertices, Precision.DoubleEquivalence precision) {
        return ConvexArea2S.fromVertices(vertices, true, precision);
    }

    public static ConvexArea2S fromVertices(Collection<Point2S> vertices, boolean close, Precision.DoubleEquivalence precision) {
        if (vertices.isEmpty()) {
            return ConvexArea2S.full();
        }
        ArrayList<GreatCircle> circles = new ArrayList<GreatCircle>();
        Point2S first = null;
        Point2S prev = null;
        Point2S cur = null;
        Iterator<Point2S> iterator = vertices.iterator();
        while (iterator.hasNext()) {
            Point2S vertex;
            cur = vertex = iterator.next();
            if (first == null) {
                first = cur;
            }
            if (prev != null && !cur.eq(prev, precision)) {
                circles.add(GreatCircles.fromPoints(prev, cur, precision));
            }
            prev = cur;
        }
        if (close && cur != null && !cur.eq(first, precision)) {
            circles.add(GreatCircles.fromPoints(cur, first, precision));
        }
        if (!vertices.isEmpty() && circles.isEmpty()) {
            throw new IllegalStateException("Unable to create convex area: only a single unique vertex provided");
        }
        return ConvexArea2S.fromBounds(circles);
    }

    public static ConvexArea2S fromPath(GreatArcPath path) {
        List<GreatCircle> bounds = path.getArcs().stream().map(GreatCircleSubset::getCircle).collect(Collectors.toList());
        return ConvexArea2S.fromBounds(bounds);
    }

    public static ConvexArea2S fromBounds(GreatCircle ... bounds) {
        return ConvexArea2S.fromBounds(Arrays.asList(bounds));
    }

    public static ConvexArea2S fromBounds(Iterable<GreatCircle> bounds) {
        List arcs = new AbstractConvexHyperplaneBoundedRegion.ConvexRegionBoundaryBuilder(GreatArc.class).build(bounds);
        return arcs.isEmpty() ? ConvexArea2S.full() : new ConvexArea2S(arcs);
    }

    private static Vector3D computeHemisphereWeightedCentroidVector(GreatArc arc) {
        return arc.getCircle().getPole().withNorm(Math.PI * 2);
    }

    private static Vector3D computeLuneWeightedCentroidVector(GreatArc a, GreatArc b) {
        Point2S aMid = a.getCentroid();
        Point2S bMid = b.getCentroid();
        Vector3D.Unit centroid = aMid.slerp(bMid, 0.5).getVector();
        double weight = a.getSize() * centroid.dot((Vector3D)a.getCircle().getPole()) + b.getSize() * centroid.dot((Vector3D)b.getCircle().getPole());
        return centroid.withNorm(weight);
    }

    private static Vector3D computeArcPoleWeightedCentroidVector(List<GreatArc> arcs) {
        Vector3D.Sum centroid = Vector3D.Sum.create();
        for (GreatArc arc : arcs) {
            centroid.addScaled(arc.getSize(), (Vector3D)arc.getCircle().getPole());
        }
        return centroid.get();
    }

    private static Vector3D computeTriangleFanWeightedCentroidVector(List<GreatArc> arcs) {
        Iterator<GreatArc> arcIt = arcs.iterator();
        Point2S p0 = arcIt.next().getStartPoint();
        Vector3D.Unit v0 = p0.getVector();
        Vector3D.Sum areaCentroid = Vector3D.Sum.create();
        while (arcIt.hasNext()) {
            GreatArc arc = arcIt.next();
            if (arc.contains(p0)) continue;
            Point2S p1 = arc.getStartPoint();
            Point2S p2 = arc.getEndPoint();
            Vector3D.Unit v1 = p1.getVector();
            Vector3D.Unit v2 = p2.getVector();
            Vector3D.Unit triangleCentroid = Vector3D.Sum.create().add((Vector3D)v0).add((Vector3D)v1).add((Vector3D)v2).get().normalize();
            double triangleCentroidLen = ConvexArea2S.computeArcCentroidContribution(v0, v1, triangleCentroid) + ConvexArea2S.computeArcCentroidContribution(v1, v2, triangleCentroid) + ConvexArea2S.computeArcCentroidContribution(v2, v0, triangleCentroid);
            areaCentroid.addScaled(triangleCentroidLen, (Vector3D)triangleCentroid);
        }
        return areaCentroid.get();
    }

    private static double computeArcCentroidContribution(Vector3D.Unit a, Vector3D.Unit b, Vector3D.Unit triangleCentroid) {
        double arcLength = a.angle((Vector3D)b);
        Vector3D.Unit planeNormal = a.cross((Vector3D)b).normalize();
        return arcLength * triangleCentroid.dot((Vector3D)planeNormal);
    }
}

