/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed.rotation;

import java.util.Objects;
import java.util.function.DoubleFunction;
import org.apache.commons.geometry.core.internal.GeometryInternalError;
import org.apache.commons.geometry.euclidean.internal.Vectors;
import org.apache.commons.geometry.euclidean.threed.AffineTransformMatrix3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.rotation.AxisAngleSequence;
import org.apache.commons.geometry.euclidean.threed.rotation.AxisReferenceFrame;
import org.apache.commons.geometry.euclidean.threed.rotation.AxisSequence;
import org.apache.commons.geometry.euclidean.threed.rotation.AxisSequenceType;
import org.apache.commons.geometry.euclidean.threed.rotation.Rotation3D;
import org.apache.commons.numbers.quaternion.Quaternion;
import org.apache.commons.numbers.quaternion.Slerp;

public final class QuaternionRotation
implements Rotation3D {
    private static final double ANTIPARALLEL_DOT_THRESHOLD = -0.999999999999998;
    private static final double AXIS_ANGLE_SINGULARITY_THRESHOLD = 0.9999999999;
    private static final QuaternionRotation IDENTITY_INSTANCE = QuaternionRotation.of(Quaternion.ONE);
    private final Quaternion quat;

    private QuaternionRotation(Quaternion quat) {
        this.quat = quat.positivePolarForm();
    }

    public Quaternion getQuaternion() {
        return this.quat;
    }

    @Override
    public Vector3D getAxis() {
        Vector3D.Unit axis = Vector3D.of(this.quat.getX(), this.quat.getY(), this.quat.getZ()).normalizeOrNull();
        return axis != null ? axis : Vector3D.Unit.PLUS_X;
    }

    @Override
    public double getAngle() {
        return 2.0 * Math.acos(this.quat.getW());
    }

    @Override
    public QuaternionRotation inverse() {
        return new QuaternionRotation(this.quat.conjugate());
    }

    @Override
    public Vector3D apply(Vector3D v) {
        double qw = this.quat.getW();
        double qx = this.quat.getX();
        double qy = this.quat.getY();
        double qz = this.quat.getZ();
        double x = v.getX();
        double y = v.getY();
        double z = v.getZ();
        double iw = -(qx * x) - qy * y - qz * z;
        double ix = qw * x + qy * z - qz * y;
        double iy = qw * y + qz * x - qx * z;
        double iz = qw * z + qx * y - qy * x;
        return Vector3D.of(iw * -qx + ix * qw + iy * -qz - iz * -qy, iw * -qy - ix * -qz + iy * qw + iz * -qx, iw * -qz + ix * -qy - iy * -qx + iz * qw);
    }

    @Override
    public Vector3D applyVector(Vector3D vec) {
        return this.apply(vec);
    }

    public boolean preservesOrientation() {
        return true;
    }

    public AffineTransformMatrix3D toMatrix() {
        double qw = this.quat.getW();
        double qx = this.quat.getX();
        double qy = this.quat.getY();
        double qz = this.quat.getZ();
        double xx = qx * qx;
        double xy = qx * qy;
        double xz = qx * qz;
        double xw = qx * qw;
        double yy = qy * qy;
        double yz = qy * qz;
        double yw = qy * qw;
        double zz = qz * qz;
        double zw = qz * qw;
        double m00 = 1.0 - 2.0 * (yy + zz);
        double m01 = 2.0 * (xy - zw);
        double m02 = 2.0 * (xz + yw);
        double m03 = 0.0;
        double m10 = 2.0 * (xy + zw);
        double m11 = 1.0 - 2.0 * (xx + zz);
        double m12 = 2.0 * (yz - xw);
        double m13 = 0.0;
        double m20 = 2.0 * (xz - yw);
        double m21 = 2.0 * (yz + xw);
        double m22 = 1.0 - 2.0 * (xx + yy);
        double m23 = 0.0;
        return AffineTransformMatrix3D.of(m00, m01, m02, 0.0, m10, m11, m12, 0.0, m20, m21, m22, 0.0);
    }

    public QuaternionRotation multiply(QuaternionRotation q) {
        Quaternion product = this.quat.multiply(q.quat);
        return new QuaternionRotation(product);
    }

    public QuaternionRotation premultiply(QuaternionRotation q) {
        return q.multiply(this);
    }

    public DoubleFunction<QuaternionRotation> slerp(QuaternionRotation end) {
        Slerp s = new Slerp(this.getQuaternion(), end.getQuaternion());
        return t -> QuaternionRotation.of(s.apply(t));
    }

    public AxisAngleSequence toAxisAngleSequence(AxisReferenceFrame frame, AxisSequence axes) {
        if (frame == null) {
            throw new IllegalArgumentException("Axis reference frame cannot be null");
        }
        if (axes == null) {
            throw new IllegalArgumentException("Axis sequence cannot be null");
        }
        double[] angles = this.getAngles(frame, axes);
        return new AxisAngleSequence(frame, axes, angles[0], angles[1], angles[2]);
    }

    public AxisAngleSequence toRelativeAxisAngleSequence(AxisSequence axes) {
        return this.toAxisAngleSequence(AxisReferenceFrame.RELATIVE, axes);
    }

    public AxisAngleSequence toAbsoluteAxisAngleSequence(AxisSequence axes) {
        return this.toAxisAngleSequence(AxisReferenceFrame.ABSOLUTE, axes);
    }

    public int hashCode() {
        return this.quat.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QuaternionRotation)) {
            return false;
        }
        QuaternionRotation other = (QuaternionRotation)obj;
        return Objects.equals(this.quat, other.quat);
    }

    public String toString() {
        return this.quat.toString();
    }

    private double[] getAngles(AxisReferenceFrame frame, AxisSequence axes) {
        AxisSequenceType sequenceType = axes.getType();
        Vector3D axis1 = axes.getAxis1();
        Vector3D axis2 = axes.getAxis2();
        Vector3D axis3 = axes.getAxis3();
        if (frame == AxisReferenceFrame.RELATIVE) {
            if (sequenceType == AxisSequenceType.TAIT_BRYAN) {
                return this.getRelativeTaitBryanAngles(axis1, axis2, axis3);
            }
            if (sequenceType == AxisSequenceType.EULER) {
                return this.getRelativeEulerAngles(axis1, axis2);
            }
        } else if (frame == AxisReferenceFrame.ABSOLUTE) {
            if (sequenceType == AxisSequenceType.TAIT_BRYAN) {
                return this.getAbsoluteTaitBryanAngles(axis1, axis2, axis3);
            }
            if (sequenceType == AxisSequenceType.EULER) {
                return this.getAbsoluteEulerAngles(axis1, axis2);
            }
        }
        throw new GeometryInternalError();
    }

    private double[] getRelativeTaitBryanAngles(Vector3D axis1, Vector3D axis2, Vector3D axis3) {
        Vector3D vec3 = this.apply(axis3);
        Vector3D invVec1 = this.inverse().apply(axis1);
        double angle2Sin = vec3.dot(axis2.cross(axis3));
        if (angle2Sin < -0.9999999999 || angle2Sin > 0.9999999999) {
            Vector3D vec2 = this.apply(axis2);
            double angle1TanY = vec2.dot(axis1.cross(axis2));
            double angle1TanX = vec2.dot(axis2);
            double angle2 = angle2Sin > 0.9999999999 ? 1.5707963267948966 : -1.5707963267948966;
            return new double[]{Math.atan2(angle1TanY, angle1TanX), angle2, 0.0};
        }
        Vector3D crossAxis13 = axis1.cross(axis3);
        double angle1TanY = vec3.dot(crossAxis13);
        double angle1TanX = vec3.dot(axis3);
        double angle3TanY = invVec1.dot(crossAxis13);
        double angle3TanX = invVec1.dot(axis1);
        return new double[]{Math.atan2(angle1TanY, angle1TanX), Math.asin(angle2Sin), Math.atan2(angle3TanY, angle3TanX)};
    }

    private double[] getAbsoluteTaitBryanAngles(Vector3D axis1, Vector3D axis2, Vector3D axis3) {
        return QuaternionRotation.reverseArray(this.getRelativeTaitBryanAngles(axis3, axis2, axis1));
    }

    private double[] getRelativeEulerAngles(Vector3D axis1, Vector3D axis2) {
        Vector3D crossAxis = axis1.cross(axis2);
        Vector3D vec1 = this.apply(axis1);
        Vector3D invVec1 = this.inverse().apply(axis1);
        double angle2Cos = vec1.dot(axis1);
        if (angle2Cos < -0.9999999999 || angle2Cos > 0.9999999999) {
            Vector3D vec2 = this.apply(axis2);
            double angle1TanY = vec2.dot(crossAxis);
            double angle1TanX = vec2.dot(axis2);
            double angle2 = angle2Cos > 0.9999999999 ? 0.0 : Math.PI;
            return new double[]{Math.atan2(angle1TanY, angle1TanX), angle2, 0.0};
        }
        double angle1TanY = vec1.dot(axis2);
        double angle1TanX = -vec1.dot(crossAxis);
        double angle3TanY = invVec1.dot(axis2);
        double angle3TanX = invVec1.dot(crossAxis);
        return new double[]{Math.atan2(angle1TanY, angle1TanX), Math.acos(angle2Cos), Math.atan2(angle3TanY, angle3TanX)};
    }

    private double[] getAbsoluteEulerAngles(Vector3D axis1, Vector3D axis2) {
        return QuaternionRotation.reverseArray(this.getRelativeEulerAngles(axis1, axis2));
    }

    public static QuaternionRotation of(Quaternion quat) {
        return new QuaternionRotation(quat);
    }

    public static QuaternionRotation of(double w, double x, double y, double z) {
        return QuaternionRotation.of(Quaternion.of((double)w, (double)x, (double)y, (double)z));
    }

    public static QuaternionRotation identity() {
        return IDENTITY_INSTANCE;
    }

    public static QuaternionRotation fromAxisAngle(Vector3D axis, double angle) {
        Vector3D.Unit normAxis = axis.normalize();
        if (!Double.isFinite(angle)) {
            throw new IllegalArgumentException("Invalid angle: " + angle);
        }
        double halfAngle = 0.5 * angle;
        double sinHalfAngle = Math.sin(halfAngle);
        double w = Math.cos(halfAngle);
        double x = sinHalfAngle * normAxis.getX();
        double y = sinHalfAngle * normAxis.getY();
        double z = sinHalfAngle * normAxis.getZ();
        return QuaternionRotation.of(w, x, y, z);
    }

    public static QuaternionRotation createVectorRotation(Vector3D u, Vector3D v) {
        double normProduct = Vectors.checkedNorm(u) * Vectors.checkedNorm(v);
        double dot = u.dot(v);
        if (dot < -0.999999999999998 * normProduct) {
            Vector3D.Unit axis = u.orthogonal();
            return QuaternionRotation.of(0.0, axis.getX(), axis.getY(), axis.getZ());
        }
        double w = Math.sqrt(0.5 * (1.0 + dot / normProduct));
        double vectorialScaleFactor = 1.0 / (2.0 * w * normProduct);
        Vector3D axis = u.cross(v);
        return QuaternionRotation.of(w, vectorialScaleFactor * axis.getX(), vectorialScaleFactor * axis.getY(), vectorialScaleFactor * axis.getZ());
    }

    public static QuaternionRotation createBasisRotation(Vector3D u1, Vector3D u2, Vector3D v1, Vector3D v2) {
        Vector3D.Unit a = u1.normalize();
        Vector3D.Unit b = a.orthogonal(u2);
        Vector3D c = a.cross(b);
        Vector3D.Unit d = v1.normalize();
        Vector3D.Unit e = d.orthogonal(v2);
        Vector3D f = d.cross(e);
        double m00 = Vectors.linearCombination(d.getX(), a.getX(), e.getX(), b.getX(), f.getX(), c.getX());
        double m01 = Vectors.linearCombination(d.getX(), a.getY(), e.getX(), b.getY(), f.getX(), c.getY());
        double m02 = Vectors.linearCombination(d.getX(), a.getZ(), e.getX(), b.getZ(), f.getX(), c.getZ());
        double m10 = Vectors.linearCombination(d.getY(), a.getX(), e.getY(), b.getX(), f.getY(), c.getX());
        double m11 = Vectors.linearCombination(d.getY(), a.getY(), e.getY(), b.getY(), f.getY(), c.getY());
        double m12 = Vectors.linearCombination(d.getY(), a.getZ(), e.getY(), b.getZ(), f.getY(), c.getZ());
        double m20 = Vectors.linearCombination(d.getZ(), a.getX(), e.getZ(), b.getX(), f.getZ(), c.getX());
        double m21 = Vectors.linearCombination(d.getZ(), a.getY(), e.getZ(), b.getY(), f.getZ(), c.getY());
        double m22 = Vectors.linearCombination(d.getZ(), a.getZ(), e.getZ(), b.getZ(), f.getZ(), c.getZ());
        return QuaternionRotation.orthogonalRotationMatrixToQuaternion(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static QuaternionRotation fromAxisAngleSequence(AxisAngleSequence sequence) {
        AxisSequence axes = sequence.getAxisSequence();
        QuaternionRotation q1 = QuaternionRotation.fromAxisAngle(axes.getAxis1(), sequence.getAngle1());
        QuaternionRotation q2 = QuaternionRotation.fromAxisAngle(axes.getAxis2(), sequence.getAngle2());
        QuaternionRotation q3 = QuaternionRotation.fromAxisAngle(axes.getAxis3(), sequence.getAngle3());
        if (sequence.getReferenceFrame() == AxisReferenceFrame.ABSOLUTE) {
            return q3.multiply(q2).multiply(q1);
        }
        return q1.multiply(q2).multiply(q3);
    }

    private static QuaternionRotation orthogonalRotationMatrixToQuaternion(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double w;
        double z;
        double y;
        double x;
        double trace = m00 + m11 + m22;
        if (trace > 0.0) {
            double s = 2.0 * Math.sqrt(1.0 + trace);
            double sinv = 1.0 / s;
            x = (m21 - m12) * sinv;
            y = (m02 - m20) * sinv;
            z = (m10 - m01) * sinv;
            w = 0.25 * s;
        } else if (m00 > m11 && m00 > m22) {
            double s = 2.0 * Math.sqrt(1.0 + m00 - m11 - m22);
            double sinv = 1.0 / s;
            x = 0.25 * s;
            y = (m01 + m10) * sinv;
            z = (m02 + m20) * sinv;
            w = (m21 - m12) * sinv;
        } else if (m11 > m22) {
            double s = 2.0 * Math.sqrt(1.0 + m11 - m00 - m22);
            double sinv = 1.0 / s;
            x = (m01 + m10) * sinv;
            y = 0.25 * s;
            z = (m21 + m12) * sinv;
            w = (m02 - m20) * sinv;
        } else {
            double s = 2.0 * Math.sqrt(1.0 + m22 - m00 - m11);
            double sinv = 1.0 / s;
            x = (m02 + m20) * sinv;
            y = (m21 + m12) * sinv;
            z = 0.25 * s;
            w = (m10 - m01) * sinv;
        }
        return QuaternionRotation.of(w, x, y, z);
    }

    private static double[] reverseArray(double[] arr) {
        int len = arr.length;
        int i = 0;
        int j = len - 1;
        while (i < len / 2) {
            double temp = arr[i];
            arr[i] = arr[j];
            arr[j] = temp;
            ++i;
            --j;
        }
        return arr;
    }
}

