/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.geometry.core.partitioning.BoundarySource;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.io.core.BoundaryReadHandler;
import org.apache.commons.geometry.io.core.BoundaryWriteHandler;
import org.apache.commons.geometry.io.core.GeometryFormat;
import org.apache.commons.geometry.io.core.input.GeometryInput;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;
import org.apache.commons.geometry.io.core.output.GeometryOutput;
import org.apache.commons.numbers.core.Precision;

public class BoundaryIOManager<H extends HyperplaneConvexSubset<?>, B extends BoundarySource<H>, R extends BoundaryReadHandler<H, B>, W extends BoundaryWriteHandler<H, B>> {
    private static final String HANDLER_NULL_ERR = "Handler cannot be null";
    private static final String FORMAT_NULL_ERR = "Format cannot be null";
    private static final String FORMAT_NAME_NULL_ERR = "Format name cannot be null";
    private final HandlerRegistry<R> readRegistry = new HandlerRegistry();
    private final HandlerRegistry<W> writeRegistry = new HandlerRegistry();

    public void registerReadHandler(R handler) {
        Objects.requireNonNull(handler, HANDLER_NULL_ERR);
        this.readRegistry.register(handler.getFormat(), handler);
    }

    public void unregisterReadHandler(R handler) {
        this.readRegistry.unregister(handler);
    }

    public List<R> getReadHandlers() {
        return this.readRegistry.getHandlers();
    }

    public List<GeometryFormat> getReadFormats() {
        return this.readRegistry.getHandlers().stream().map(BoundaryReadHandler::getFormat).collect(Collectors.toList());
    }

    public R getReadHandlerForFormat(GeometryFormat fmt) {
        return (R)((BoundaryReadHandler)this.readRegistry.getByFormat(fmt));
    }

    public R getReadHandlerForFileExtension(String fileExt) {
        return (R)((BoundaryReadHandler)this.readRegistry.getByFileExtension(fileExt));
    }

    public void registerWriteHandler(W handler) {
        Objects.requireNonNull(handler, HANDLER_NULL_ERR);
        this.writeRegistry.register(handler.getFormat(), handler);
    }

    public void unregisterWriteHandler(W handler) {
        this.writeRegistry.unregister(handler);
    }

    public List<W> getWriteHandlers() {
        return this.writeRegistry.getHandlers();
    }

    public List<GeometryFormat> getWriteFormats() {
        return this.writeRegistry.getHandlers().stream().map(BoundaryWriteHandler::getFormat).collect(Collectors.toList());
    }

    public W getWriteHandlerForFormat(GeometryFormat fmt) {
        return (W)((BoundaryWriteHandler)this.writeRegistry.getByFormat(fmt));
    }

    public W getWriteHandlerForFileExtension(String fileExt) {
        return (W)((BoundaryWriteHandler)this.writeRegistry.getByFileExtension(fileExt));
    }

    public B read(GeometryInput in, GeometryFormat fmt, Precision.DoubleEquivalence precision) {
        return this.requireReadHandler(in, fmt).read(in, precision);
    }

    public Stream<H> boundaries(GeometryInput in, GeometryFormat fmt, Precision.DoubleEquivalence precision) {
        return this.requireReadHandler(in, fmt).boundaries(in, precision);
    }

    public void write(B src, GeometryOutput out, GeometryFormat fmt) {
        this.requireWriteHandler(out, fmt).write(src, out);
    }

    protected R requireReadHandler(GeometryInput in, GeometryFormat fmt) {
        Objects.requireNonNull(in, "Input cannot be null");
        return (R)((BoundaryReadHandler)this.readRegistry.requireHandlerByFormatOrFileName(fmt, in.getFileName()));
    }

    protected W requireWriteHandler(GeometryOutput out, GeometryFormat fmt) {
        Objects.requireNonNull(out, "Output cannot be null");
        return (W)((BoundaryWriteHandler)this.writeRegistry.requireHandlerByFormatOrFileName(fmt, out.getFileName()));
    }

    private static final class HandlerRegistry<T> {
        private final List<T> handlers = new ArrayList<T>();
        private final Map<String, T> handlersByFormatName = new HashMap<String, T>();
        private final Map<String, T> handlersByFileExtension = new HashMap<String, T>();

        private HandlerRegistry() {
        }

        public synchronized void register(GeometryFormat fmt, T handler) {
            Objects.requireNonNull(fmt, BoundaryIOManager.FORMAT_NULL_ERR);
            Objects.requireNonNull(handler, BoundaryIOManager.HANDLER_NULL_ERR);
            if (!this.handlers.contains(handler)) {
                this.unregisterFormat(fmt);
                this.addToFormat(fmt.getFormatName(), handler);
                this.addToFileExtensions(fmt.getFileExtensions(), handler);
                this.handlers.add(handler);
            }
        }

        public synchronized void unregister(T handler) {
            if (handler != null && this.handlers.remove(handler)) {
                HandlerRegistry.removeValue(this.handlersByFormatName, handler);
                HandlerRegistry.removeValue(this.handlersByFileExtension, handler);
            }
        }

        public synchronized T unregisterFormat(GeometryFormat fmt) {
            T handler = this.getByFormat(fmt);
            if (handler != null) {
                this.unregister(handler);
            }
            return handler;
        }

        public synchronized List<T> getHandlers() {
            return Collections.unmodifiableList(new ArrayList<T>(this.handlers));
        }

        public synchronized T getByFormat(GeometryFormat fmt) {
            if (fmt != null) {
                return HandlerRegistry.getByNormalizedKey(this.handlersByFormatName, fmt.getFormatName());
            }
            return null;
        }

        public synchronized T getByFileExtension(String fileExt) {
            return HandlerRegistry.getByNormalizedKey(this.handlersByFileExtension, fileExt);
        }

        public synchronized T requireHandlerByFormatOrFileName(GeometryFormat fmt, String fileName) {
            T handler = null;
            if (fmt != null) {
                handler = this.getByFormat(fmt);
                if (handler == null) {
                    throw new IllegalArgumentException(MessageFormat.format("Failed to find handler for format \"{0}\"", fmt.getFormatName()));
                }
            } else {
                String fileExt = GeometryIOUtils.getFileExtension(fileName);
                if (fileExt != null && !fileExt.isEmpty()) {
                    handler = this.getByFileExtension(fileExt);
                    if (handler == null) {
                        throw new IllegalArgumentException(MessageFormat.format("Failed to find handler for file extension \"{0}\"", fileExt));
                    }
                } else {
                    throw new IllegalArgumentException("Failed to find handler: no format specified and no file extension available");
                }
            }
            return handler;
        }

        private void addToFormat(String fmtName, T handler) {
            Objects.requireNonNull(fmtName, BoundaryIOManager.FORMAT_NAME_NULL_ERR);
            this.handlersByFormatName.put(HandlerRegistry.normalizeString(fmtName), handler);
        }

        private void addToFileExtensions(List<String> fileExts, T handler) {
            if (fileExts != null) {
                for (String fileExt : fileExts) {
                    this.addToFileExtension(fileExt, handler);
                }
            }
        }

        private void addToFileExtension(String fileExt, T handler) {
            if (fileExt != null) {
                this.handlersByFileExtension.put(HandlerRegistry.normalizeString(fileExt), handler);
            }
        }

        private static <V> V getByNormalizedKey(Map<String, V> map, String key) {
            if (key != null) {
                return map.get(HandlerRegistry.normalizeString(key));
            }
            return null;
        }

        private static <V> void removeValue(Map<String, V> map, V value) {
            Iterator<Map.Entry<String, V>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                if (!value.equals(it.next().getValue())) continue;
                it.remove();
            }
        }

        private static String normalizeString(String str) {
            return str.toLowerCase(Locale.ROOT);
        }
    }
}

