/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache.cdi;

import java.io.Serializable;
import javax.annotation.Priority;
import javax.cache.Cache;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.GeneratedCacheKey;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.commons.jcs3.jcache.cdi.CDIJCacheHelper;
import org.apache.commons.jcs3.jcache.cdi.CacheKeyInvocationContextImpl;

@CachePut
@Interceptor
@Priority(value=1000)
public class CachePutInterceptor
implements Serializable {
    private static final long serialVersionUID = -4327240193421847822L;
    @Inject
    private CDIJCacheHelper helper;

    @AroundInvoke
    public Object cache(InvocationContext ic) throws Throwable {
        Object result;
        CDIJCacheHelper.MethodMeta methodMeta = this.helper.findMeta(ic);
        String cacheName = methodMeta.getCachePutCacheName();
        CacheResolverFactory cacheResolverFactory = methodMeta.getCachePutResolverFactory();
        CacheKeyInvocationContextImpl<CachePut> context = new CacheKeyInvocationContextImpl<CachePut>(ic, methodMeta.getCachePut(), cacheName, methodMeta);
        CacheResolver cacheResolver = cacheResolverFactory.getCacheResolver(context);
        Cache cache = cacheResolver.resolveCache(context);
        GeneratedCacheKey cacheKey = methodMeta.getCachePutKeyGenerator().generateCacheKey(context);
        CachePut cachePut = methodMeta.getCachePut();
        boolean afterInvocation = methodMeta.isCachePutAfter();
        if (!afterInvocation) {
            cache.put((Object)cacheKey, (Object)context.getValueParameter());
        }
        try {
            result = ic.proceed();
        }
        catch (Throwable t) {
            if (afterInvocation && this.helper.isIncluded(t.getClass(), cachePut.cacheFor(), cachePut.noCacheFor())) {
                cache.put((Object)cacheKey, (Object)context.getValueParameter());
            }
            throw t;
        }
        if (afterInvocation) {
            cache.put((Object)cacheKey, (Object)context.getValueParameter());
        }
        return result;
    }
}

