/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc.mysql.util;

import java.text.ParseException;
import java.util.Date;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.mysql.util.ScheduleParser;

public class ScheduleParserUtilUnitTest
extends TestCase {
    public void testGetDatesWithNullInput() {
        try {
            ScheduleParser.createDatesForSchedule(null);
            ScheduleParserUtilUnitTest.fail((String)"Should have thrown an exception");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testGetDateWithNullInput() {
        try {
            ScheduleParser.getDateForSchedule(null);
            ScheduleParserUtilUnitTest.fail((String)"Should have thrown an exception");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testGetsDatesSingle() throws ParseException {
        String schedule = "12:34:56";
        Date[] dates = ScheduleParser.createDatesForSchedule((String)"12:34:56");
        ScheduleParserUtilUnitTest.assertEquals((String)"Wrong number of dates returned.", (int)1, (int)dates.length);
    }

    public void testGetsDatesMultiple() throws ParseException {
        String schedule = "12:34:56,03:51:00,12:34:12";
        Date[] dates = ScheduleParser.createDatesForSchedule((String)"12:34:56,03:51:00,12:34:12");
        ScheduleParserUtilUnitTest.assertEquals((String)"Wrong number of dates returned.", (int)3, (int)dates.length);
    }

    public void testGetDatesMalformedNoColon() {
        try {
            String schedule = "12:34:56,03:51:00,123234";
            ScheduleParser.createDatesForSchedule((String)"12:34:56,03:51:00,123234");
            ScheduleParserUtilUnitTest.fail((String)"Should have thrown an exception for a malformed date");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testGetDatesMalformedNan() {
        try {
            String schedule = "12:34:56,03:51:00,aa:12:12";
            ScheduleParser.createDatesForSchedule((String)"12:34:56,03:51:00,aa:12:12");
            ScheduleParserUtilUnitTest.fail((String)"Should have thrown an exception for a malformed date");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }
}

