/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.server;

import java.rmi.server.RMISocketFactory;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.remote.server.MockRMISocketFactory;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServerAttributes;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs3.auxiliary.remote.server.TimeoutConfigurableRMISocketFactory;

public class RemoteCacheServerFactoryUnitTest
extends TestCase {
    public void testConfigureRemoteCacheServerAttributes_eventQueuePoolName() {
        String eventQueuePoolName = "specialName";
        Properties props = new Properties();
        props.put("jcs.remotecache.serverattributes.EventQueuePoolName", "specialName");
        RemoteCacheServerAttributes result = RemoteCacheServerFactory.configureRemoteCacheServerAttributes((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong eventQueuePoolName", (String)"specialName", (String)result.getEventQueuePoolName());
    }

    public void testConfigureRemoteCacheServerAttributes_timeoutNotPresent() {
        Properties props = new Properties();
        RemoteCacheServerAttributes result = RemoteCacheServerFactory.configureRemoteCacheServerAttributes((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong timeout", (int)10000, (int)result.getRmiSocketFactoryTimeoutMillis());
    }

    public void testConfigureRemoteCacheServerAttributes_registryKeepAliveDelayMillisPresent() {
        int registryKeepAliveDelayMillis = 123245;
        Properties props = new Properties();
        props.put("jcs.remotecache.serverattributes.registryKeepAliveDelayMillis", String.valueOf(123245));
        RemoteCacheServerAttributes result = RemoteCacheServerFactory.configureRemoteCacheServerAttributes((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong registryKeepAliveDelayMillis", (long)123245L, (long)result.getRegistryKeepAliveDelayMillis());
    }

    public void testConfigureRemoteCacheServerAttributes_useRegistryKeepAlivePresent() {
        boolean useRegistryKeepAlive = false;
        Properties props = new Properties();
        props.put("jcs.remotecache.serverattributes.useRegistryKeepAlive", String.valueOf(false));
        RemoteCacheServerAttributes result = RemoteCacheServerFactory.configureRemoteCacheServerAttributes((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong useRegistryKeepAlive", (boolean)false, (boolean)result.isUseRegistryKeepAlive());
    }

    public void testConfigureRemoteCacheServerAttributes_startRegistryPresent() {
        boolean startRegistry = false;
        Properties props = new Properties();
        props.put("jcs.remotecache.serverattributes.startRegistry", String.valueOf(false));
        RemoteCacheServerAttributes result = RemoteCacheServerFactory.configureRemoteCacheServerAttributes((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong startRegistry", (boolean)false, (boolean)result.isStartRegistry());
    }

    public void testConfigureRemoteCacheServerAttributes_rmiSocketFactoryTimeoutMillisPresent() {
        int rmiSocketFactoryTimeoutMillis = 123245;
        Properties props = new Properties();
        props.put("jcs.remotecache.serverattributes.rmiSocketFactoryTimeoutMillis", String.valueOf(123245));
        RemoteCacheServerAttributes result = RemoteCacheServerFactory.configureRemoteCacheServerAttributes((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong rmiSocketFactoryTimeoutMillis", (int)123245, (int)result.getRmiSocketFactoryTimeoutMillis());
    }

    public void testConfigureRemoteCacheServerAttributes_allowClusterGetPresent() {
        boolean allowClusterGet = false;
        Properties props = new Properties();
        props.put("jcs.remotecache.serverattributes.allowClusterGet", String.valueOf(false));
        RemoteCacheServerAttributes result = RemoteCacheServerFactory.configureRemoteCacheServerAttributes((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong allowClusterGet", (boolean)false, (boolean)result.isAllowClusterGet());
    }

    public void testConfigureRemoteCacheServerAttributes_localClusterConsistencyPresent() {
        boolean localClusterConsistency = false;
        Properties props = new Properties();
        props.put("jcs.remotecache.serverattributes.localClusterConsistency", String.valueOf(false));
        RemoteCacheServerAttributes result = RemoteCacheServerFactory.configureRemoteCacheServerAttributes((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong localClusterConsistency", (boolean)false, (boolean)result.isLocalClusterConsistency());
    }

    public void testConfigureObjectSpecificCustomFactory_withProperty() {
        String testValue = "123245";
        Properties props = new Properties();
        props.put("jcs.remotecache.customrmisocketfactory", MockRMISocketFactory.class.getName());
        props.put("jcs.remotecache.customrmisocketfactory.testStringProperty", "123245");
        RMISocketFactory result = RemoteCacheServerFactory.configureObjectSpecificCustomFactory((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertNotNull((String)"Should have a custom socket factory.", (Object)result);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong testValue", (String)"123245", (String)((MockRMISocketFactory)result).getTestStringProperty());
    }

    public void testConfigureObjectSpecificCustomFactory_withProperty_TimeoutConfigurableRMIScoketFactory() {
        int readTimeout = 1234;
        int openTimeout = 1234;
        Properties props = new Properties();
        props.put("jcs.remotecache.customrmisocketfactory", TimeoutConfigurableRMISocketFactory.class.getName());
        props.put("jcs.remotecache.customrmisocketfactory.readTimeout", String.valueOf(1234));
        props.put("jcs.remotecache.customrmisocketfactory.openTimeout", String.valueOf(1234));
        RMISocketFactory result = RemoteCacheServerFactory.configureObjectSpecificCustomFactory((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertNotNull((String)"Should have a custom socket factory.", (Object)result);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong readTimeout", (int)1234, (int)((TimeoutConfigurableRMISocketFactory)result).getReadTimeout());
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong readTimeout", (int)1234, (int)((TimeoutConfigurableRMISocketFactory)result).getOpenTimeout());
    }
}

