/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.server;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.MockCacheEventLogger;
import org.apache.commons.jcs3.auxiliary.remote.MockRemoteCacheListener;
import org.apache.commons.jcs3.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServer;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServerAttributes;
import org.apache.commons.jcs3.auxiliary.remote.server.behavior.IRemoteCacheServerAttributes;
import org.apache.commons.jcs3.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.utils.timing.SleepUtil;

public class RemoteCacheServerUnitTest
extends TestCase {
    private static final String expectedIp1 = "adfasdf";
    private static final String expectedIp2 = "adsfadsafaf";
    private RemoteCacheServer<String, String> server;

    protected void setUp() throws Exception {
        super.setUp();
        RemoteCacheServerAttributes rcsa = new RemoteCacheServerAttributes();
        rcsa.setConfigFileName("/TestRemoteCacheServer.ccf");
        Properties config = RemoteUtils.loadProps((String)rcsa.getConfigFileName());
        this.server = new RemoteCacheServer((IRemoteCacheServerAttributes)rcsa, config);
    }

    protected void tearDown() throws Exception {
        this.server.shutdown();
        super.tearDown();
    }

    public void testAddListenerToCache_LOCALtype() throws Exception {
        MockRemoteCacheListener mockListener1 = new MockRemoteCacheListener();
        mockListener1.remoteType = RemoteType.LOCAL;
        mockListener1.localAddress = expectedIp1;
        MockRemoteCacheListener mockListener2 = new MockRemoteCacheListener();
        mockListener1.remoteType = RemoteType.LOCAL;
        mockListener2.localAddress = expectedIp2;
        String cacheName = "testAddListener";
        this.server.addCacheListener("testAddListener", mockListener1);
        this.server.addCacheListener("testAddListener", mockListener2);
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong listener id.", (long)1L, (long)mockListener1.getListenerId());
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong listener id.", (long)2L, (long)mockListener2.getListenerId());
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong ip.", (String)expectedIp1, (String)this.server.getExtraInfoForRequesterId(1L));
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong ip.", (String)expectedIp2, (String)this.server.getExtraInfoForRequesterId(2L));
    }

    public void testAddListenerToCache_CLUSTERtype() throws Exception {
        MockRemoteCacheListener mockListener1 = new MockRemoteCacheListener();
        mockListener1.remoteType = RemoteType.CLUSTER;
        mockListener1.localAddress = expectedIp1;
        MockRemoteCacheListener mockListener2 = new MockRemoteCacheListener();
        mockListener1.remoteType = RemoteType.CLUSTER;
        mockListener2.localAddress = expectedIp2;
        String cacheName = "testAddListener";
        this.server.addCacheListener("testAddListener", mockListener1);
        this.server.addCacheListener("testAddListener", mockListener2);
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong listener id.", (long)1L, (long)mockListener1.getListenerId());
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong listener id.", (long)2L, (long)mockListener2.getListenerId());
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong ip.", (String)expectedIp1, (String)this.server.getExtraInfoForRequesterId(1L));
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong ip.", (String)expectedIp2, (String)this.server.getExtraInfoForRequesterId(2L));
    }

    public void testAddListener_ToAllThenRemove() throws Exception {
        MockRemoteCacheListener mockListener1 = new MockRemoteCacheListener();
        MockRemoteCacheListener mockListener2 = new MockRemoteCacheListener();
        String cacheName = "testAddListenerToAllThenRemove";
        this.server.addCacheListener("testAddListenerToAllThenRemove", mockListener1);
        this.server.addCacheListener("testAddListenerToAllThenRemove", mockListener2);
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong number of listeners.", (int)2, (int)this.server.getCacheListeners((String)"testAddListenerToAllThenRemove").eventQMap.size());
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong listener id.", (long)1L, (long)mockListener1.getListenerId());
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong listener id.", (long)2L, (long)mockListener2.getListenerId());
        this.server.removeCacheListener("testAddListenerToAllThenRemove", mockListener1.getListenerId());
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong number of listeners.", (int)1, (int)this.server.getCacheListeners((String)"testAddListenerToAllThenRemove").eventQMap.size());
    }

    public void testAddListener_ToAllThenRemove_clusterType() throws Exception {
        MockRemoteCacheListener mockListener1 = new MockRemoteCacheListener();
        mockListener1.remoteType = RemoteType.CLUSTER;
        MockRemoteCacheListener mockListener2 = new MockRemoteCacheListener();
        mockListener2.remoteType = RemoteType.CLUSTER;
        String cacheName = "testAddListenerToAllThenRemove";
        this.server.addCacheListener("testAddListenerToAllThenRemove", mockListener1);
        this.server.addCacheListener("testAddListenerToAllThenRemove", mockListener2);
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong number of listeners.", (int)0, (int)this.server.getCacheListeners((String)"testAddListenerToAllThenRemove").eventQMap.size());
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong number of listeners.", (int)2, (int)this.server.getClusterListeners((String)"testAddListenerToAllThenRemove").eventQMap.size());
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong listener id.", (long)1L, (long)mockListener1.getListenerId());
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong listener id.", (long)2L, (long)mockListener2.getListenerId());
        this.server.removeCacheListener("testAddListenerToAllThenRemove", mockListener1.getListenerId());
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong number of listeners.", (int)1, (int)this.server.getClusterListeners((String)"testAddListenerToAllThenRemove").eventQMap.size());
        RemoteCacheServerUnitTest.assertNull((String)"Should be no entry in the ip map.", (Object)this.server.getExtraInfoForRequesterId(1L));
    }

    public void testSimpleRegisterListenerAndPut() throws Exception {
        int i;
        RemoteCacheServerAttributes rcsa = new RemoteCacheServerAttributes();
        rcsa.setConfigFileName("/TestRemoteCacheServer.ccf");
        Properties config = RemoteUtils.loadProps((String)rcsa.getConfigFileName());
        MockRemoteCacheListener mockListener = new MockRemoteCacheListener();
        RemoteCacheServer server = new RemoteCacheServer((IRemoteCacheServerAttributes)rcsa, config);
        String cacheName = "testSimpleRegisterListenerAndPut";
        server.addCacheListener("testSimpleRegisterListenerAndPut", mockListener);
        LinkedList<CacheElement> inputItems = new LinkedList<CacheElement>();
        int numToPut = 10;
        for (i = 0; i < 10; ++i) {
            CacheElement element = new CacheElement("testSimpleRegisterListenerAndPut", (Object)String.valueOf(i), (Object)i);
            inputItems.add(element);
            server.update((ICacheElement)element, 9999L);
        }
        Thread.sleep(100L);
        Thread.yield();
        Thread.sleep(100L);
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong number of items put to listener.", (int)10, (int)mockListener.putItems.size());
        for (i = 0; i < 10; ++i) {
            RemoteCacheServerUnitTest.assertEquals((String)"Wrong item.", inputItems.get(i), mockListener.putItems.get(i));
        }
        server.shutdown();
    }

    public void testSimpleRegisterListenerAndPut_FromClusterWithLCC() throws Exception {
        int i;
        RemoteCacheServerAttributes rcsa = new RemoteCacheServerAttributes();
        rcsa.setLocalClusterConsistency(true);
        rcsa.setConfigFileName("/TestRemoteCacheServer.ccf");
        Properties config = RemoteUtils.loadProps((String)rcsa.getConfigFileName());
        RemoteCacheServer server = new RemoteCacheServer((IRemoteCacheServerAttributes)rcsa, config);
        MockRemoteCacheListener clusterListener = new MockRemoteCacheListener();
        clusterListener.remoteType = RemoteType.CLUSTER;
        MockRemoteCacheListener localListener = new MockRemoteCacheListener();
        localListener.remoteType = RemoteType.LOCAL;
        String cacheName = "testSimpleRegisterListenerAndPut_FromClusterWithLCC";
        server.addCacheListener("testSimpleRegisterListenerAndPut_FromClusterWithLCC", clusterListener);
        server.addCacheListener("testSimpleRegisterListenerAndPut_FromClusterWithLCC", localListener);
        LinkedList<CacheElement> inputItems = new LinkedList<CacheElement>();
        int numToPut = 10;
        for (i = 0; i < 10; ++i) {
            CacheElement element = new CacheElement("testSimpleRegisterListenerAndPut_FromClusterWithLCC", (Object)String.valueOf(i), (Object)i);
            inputItems.add(element);
            server.update((ICacheElement)element, clusterListener.getListenerId());
        }
        SleepUtil.sleepAtLeast(200L);
        Thread.yield();
        SleepUtil.sleepAtLeast(200L);
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong number of items put to listener.", (int)10, (int)localListener.putItems.size());
        for (i = 0; i < 10; ++i) {
            RemoteCacheServerUnitTest.assertEquals((String)"Wrong item.", inputItems.get(i), localListener.putItems.get(i));
        }
        server.shutdown();
    }

    public void testSimpleRegisterListenerAndRemove() throws Exception {
        int i;
        MockRemoteCacheListener mockListener = new MockRemoteCacheListener();
        String cacheName = "testSimpleRegisterListenerAndPut";
        this.server.addCacheListener("testSimpleRegisterListenerAndPut", mockListener);
        int numToPut = 10;
        for (i = 0; i < 10; ++i) {
            this.server.remove("testSimpleRegisterListenerAndPut", (Object)String.valueOf(i), 9999L);
        }
        Thread.sleep(100L);
        Thread.yield();
        Thread.sleep(100L);
        RemoteCacheServerUnitTest.assertEquals((String)"Wrong number of items removed from listener.", (int)10, (int)mockListener.removedKeys.size());
        for (i = 0; i < 10; ++i) {
            RemoteCacheServerUnitTest.assertEquals((String)"Wrong key.", (String)String.valueOf(i), (String)((String)mockListener.removedKeys.get(i)));
        }
    }

    public void testUpdate_simple() throws Exception {
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        this.server.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        CacheElement item = new CacheElement("region", (Object)"key", (Object)"value");
        this.server.update((ICacheElement)item);
        RemoteCacheServerUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteCacheServerUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testGet_simple() throws Exception {
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        this.server.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        this.server.get("region", (Object)"key");
        RemoteCacheServerUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteCacheServerUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testGetMatching_simple() throws Exception {
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        this.server.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        this.server.getMatching("region", "pattern", 0L);
        RemoteCacheServerUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteCacheServerUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testGetMultiple_simple() throws Exception {
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        this.server.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        this.server.getMultiple("region", new HashSet());
        RemoteCacheServerUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteCacheServerUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testRemove_simple() throws Exception {
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        this.server.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        this.server.remove("region", (Object)"key");
        RemoteCacheServerUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteCacheServerUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testRemoveAll_simple() throws Exception {
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        this.server.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        this.server.removeAll("region");
        RemoteCacheServerUnitTest.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        RemoteCacheServerUnitTest.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }
}

