/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.jxpath.util.ValueUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValueUtilsTest {
    @Test
    public void testGetValueFromArray() {
        Object data = new Object();
        Assertions.assertSame((Object)data, (Object)ValueUtils.getValue((Object)new Object[]{data}, (int)0));
    }

    @Test
    public void testGetValueFromArrayNegativeIndex() {
        Object data = new Object();
        Assertions.assertNull((Object)ValueUtils.getValue((Object)new Object[]{data}, (int)-1));
    }

    @Test
    public void testGetValueFromArrayTooSmall() {
        Assertions.assertNull((Object)ValueUtils.getValue((Object)new Object[0], (int)2));
    }

    @Test
    public void testGetValueFromList() {
        Object data = new Object();
        Assertions.assertSame((Object)data, (Object)ValueUtils.getValue(Arrays.asList(data), (int)0));
    }

    @Test
    public void testGetValueFromListNegativeIndex() {
        Object data = new Object();
        Object res = ValueUtils.getValue(Arrays.asList(data), (int)-1);
        Assertions.assertNull((Object)res, (String)("Expected null, is " + res));
    }

    @Test
    public void testGetValueFromListTooSmall() {
        Assertions.assertNull((Object)ValueUtils.getValue((Object)Collections.EMPTY_LIST, (int)2));
    }

    @Test
    public void testGetValueFromSet() {
        Object data = new Object();
        HashSet<Object> dataSet = new HashSet<Object>();
        dataSet.add(data);
        Assertions.assertSame((Object)data, (Object)ValueUtils.getValue(dataSet, (int)0));
    }

    @Test
    public void testGetValueFromSetNegativeIndex() {
        Object data = new Object();
        HashSet<Object> dataSet = new HashSet<Object>();
        dataSet.add(data);
        Assertions.assertNull((Object)ValueUtils.getValue(dataSet, (int)-1));
    }

    @Test
    public void testGetValueFromSetTooSmall() {
        Assertions.assertNull((Object)ValueUtils.getValue((Object)Collections.EMPTY_SET, (int)2));
    }
}

