/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathAbstractFactoryException;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.util.ValueUtils;

public abstract class PropertyPointer
extends NodePointer {
    private static final long serialVersionUID = 1L;
    public static final int UNSPECIFIED_PROPERTY = Integer.MIN_VALUE;
    private static final Object UNINITIALIZED = new Object();
    protected int propertyIndex = Integer.MIN_VALUE;
    protected Object bean;
    private Object value = UNINITIALIZED;

    public PropertyPointer(NodePointer parent) {
        super(parent);
    }

    @Override
    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return this.getValuePointer().compareChildNodePointers(pointer1, pointer2);
    }

    @Override
    public NodePointer createChild(JXPathContext context, QName qName, int index) {
        PropertyPointer prop = (PropertyPointer)this.clone();
        if (qName != null) {
            prop.setPropertyName(qName.toString());
        }
        prop.setIndex(index);
        return prop.createPath(context);
    }

    @Override
    public NodePointer createChild(JXPathContext context, QName qName, int index, Object value) {
        PropertyPointer prop = (PropertyPointer)this.clone();
        if (qName != null) {
            prop.setPropertyName(qName.toString());
        }
        prop.setIndex(index);
        return prop.createPath(context, value);
    }

    @Override
    public NodePointer createPath(JXPathContext context) {
        if (this.getImmediateNode() == null) {
            AbstractFactory factory = this.getAbstractFactory(context);
            int inx = this.index == Integer.MIN_VALUE ? 0 : this.index;
            boolean success = factory.createObject(context, this, this.getBean(), this.getPropertyName(), inx);
            if (!success) {
                throw new JXPathAbstractFactoryException("Factory " + factory + " could not create an object for path: " + this.asPath());
            }
        }
        return this;
    }

    @Override
    public NodePointer createPath(JXPathContext context, Object value) {
        if (this.index != Integer.MIN_VALUE && this.index >= this.getLength()) {
            this.createPath(context);
        }
        this.setValue(value);
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PropertyPointer)) {
            return false;
        }
        PropertyPointer other = (PropertyPointer)object;
        if (!(this.parent == other.parent || this.parent != null && this.parent.equals(other.parent))) {
            return false;
        }
        if (this.getPropertyIndex() != other.getPropertyIndex() || !this.getPropertyName().equals(other.getPropertyName())) {
            return false;
        }
        int iThis = this.index == Integer.MIN_VALUE ? 0 : this.index;
        int iOther = other.index == Integer.MIN_VALUE ? 0 : other.index;
        return iThis == iOther;
    }

    public Object getBean() {
        if (this.bean == null) {
            this.bean = this.getImmediateParentPointer().getNode();
        }
        return this.bean;
    }

    @Override
    public Object getImmediateNode() {
        if (this.value == UNINITIALIZED) {
            this.value = this.index == Integer.MIN_VALUE ? ValueUtils.getValue(this.getBaseValue()) : ValueUtils.getValue(this.getBaseValue(), this.index);
        }
        return this.value;
    }

    @Override
    public NodePointer getImmediateValuePointer() {
        return PropertyPointer.newChildNodePointer((NodePointer)this.clone(), this.getName(), this.getImmediateNode());
    }

    @Override
    public int getLength() {
        Object baseValue = this.getBaseValue();
        return baseValue == null ? 1 : ValueUtils.getLength(baseValue);
    }

    @Override
    public QName getName() {
        return new QName(null, this.getPropertyName());
    }

    public abstract int getPropertyCount();

    public int getPropertyIndex() {
        return this.propertyIndex;
    }

    public abstract String getPropertyName();

    public abstract String[] getPropertyNames();

    public int hashCode() {
        return this.getImmediateParentPointer().hashCode() + this.propertyIndex + this.index;
    }

    @Override
    public boolean isActual() {
        if (!this.isActualProperty()) {
            return false;
        }
        return super.isActual();
    }

    protected abstract boolean isActualProperty();

    @Override
    public boolean isCollection() {
        Object value = this.getBaseValue();
        return value != null && ValueUtils.isCollection(value);
    }

    @Override
    public boolean isLeaf() {
        Object value = this.getNode();
        return value == null || JXPathIntrospector.getBeanInfo(value.getClass()).isAtomic();
    }

    public void setPropertyIndex(int index) {
        if (this.propertyIndex != index) {
            this.propertyIndex = index;
            this.setIndex(Integer.MIN_VALUE);
        }
    }

    public abstract void setPropertyName(String var1);
}

