/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import org.apache.commons.numbers.core.Sum;
import org.apache.commons.statistics.distribution.NormalDistribution;
import org.apache.commons.statistics.inference.AlternativeHypothesis;
import org.apache.commons.statistics.inference.Arguments;
import org.apache.commons.statistics.inference.BaseSignificanceResult;
import org.apache.commons.statistics.inference.ContinuityCorrection;
import org.apache.commons.statistics.inference.InferenceException;
import org.apache.commons.statistics.inference.PValueMethod;
import org.apache.commons.statistics.inference.StatisticUtils;
import org.apache.commons.statistics.ranking.NaNStrategy;
import org.apache.commons.statistics.ranking.NaturalRanking;
import org.apache.commons.statistics.ranking.RankingAlgorithm;
import org.apache.commons.statistics.ranking.TiesStrategy;

public final class WilcoxonSignedRankTest {
    private static final int EXACT_LIMIT = 1023;
    private static final int AUTO_LIMIT = 50;
    private static final RankingAlgorithm RANKING = new NaturalRanking(NaNStrategy.FAILED, TiesStrategy.AVERAGE);
    private static final WilcoxonSignedRankTest DEFAULT = new WilcoxonSignedRankTest(AlternativeHypothesis.TWO_SIDED, PValueMethod.AUTO, true, 0.0);
    private final AlternativeHypothesis alternative;
    private final PValueMethod pValueMethod;
    private final boolean continuityCorrection;
    private final double mu;

    private WilcoxonSignedRankTest(AlternativeHypothesis alternative, PValueMethod method, boolean continuityCorrection, double mu) {
        this.alternative = alternative;
        this.pValueMethod = method;
        this.continuityCorrection = continuityCorrection;
        this.mu = mu;
    }

    public static WilcoxonSignedRankTest withDefaults() {
        return DEFAULT;
    }

    public WilcoxonSignedRankTest with(AlternativeHypothesis v) {
        return new WilcoxonSignedRankTest(Objects.requireNonNull(v), this.pValueMethod, this.continuityCorrection, this.mu);
    }

    public WilcoxonSignedRankTest with(PValueMethod v) {
        return new WilcoxonSignedRankTest(this.alternative, Arguments.checkOption(v, EnumSet.of(PValueMethod.AUTO, PValueMethod.EXACT, PValueMethod.ASYMPTOTIC)), this.continuityCorrection, this.mu);
    }

    public WilcoxonSignedRankTest with(ContinuityCorrection v) {
        return new WilcoxonSignedRankTest(this.alternative, this.pValueMethod, Objects.requireNonNull(v) == ContinuityCorrection.ENABLED, this.mu);
    }

    public WilcoxonSignedRankTest withMu(double v) {
        return new WilcoxonSignedRankTest(this.alternative, this.pValueMethod, this.continuityCorrection, Arguments.checkFinite(v));
    }

    public double statistic(double[] z) {
        return WilcoxonSignedRankTest.computeStatistic(z, this.mu);
    }

    public double statistic(double[] x, double[] y) {
        WilcoxonSignedRankTest.checkSamples(x, y);
        double[] z = WilcoxonSignedRankTest.calculateDifferences(this.mu, x, y);
        return WilcoxonSignedRankTest.computeStatistic(z, 0.0);
    }

    public Result test(double[] z) {
        return this.computeTest(z, this.mu);
    }

    public Result test(double[] x, double[] y) {
        WilcoxonSignedRankTest.checkSamples(x, y);
        double[] z = WilcoxonSignedRankTest.calculateDifferences(this.mu, x, y);
        return this.computeTest(z, 0.0);
    }

    private static double computeStatistic(double[] z, double mu) {
        Arguments.checkValuesRequiredSize(z.length, 1);
        double[] x = StatisticUtils.subtract(z, mu);
        WilcoxonSignedRankTest.countZeros(x);
        double[] zAbs = WilcoxonSignedRankTest.calculateAbsoluteDifferences(x);
        double[] ranks = RANKING.apply(zAbs);
        return WilcoxonSignedRankTest.calculateW(x, ranks);
    }

    private Result computeTest(double[] z, double expectedMu) {
        Arguments.checkValuesRequiredSize(z.length, 1);
        double[] x = StatisticUtils.subtract(z, expectedMu);
        int zeros = WilcoxonSignedRankTest.countZeros(x);
        double[] zAbs = WilcoxonSignedRankTest.calculateAbsoluteDifferences(x);
        double[] ranks = RANKING.apply(zAbs);
        double wPlus = WilcoxonSignedRankTest.calculateW(x, ranks);
        double c = WilcoxonSignedRankTest.calculateTieCorrection(ranks);
        boolean tiedValues = c != 0.0;
        int n = z.length;
        double p = WilcoxonSignedRankTest.selectMethod(this.pValueMethod, n) == PValueMethod.EXACT && n <= 1023 && !tiedValues && zeros == 0 ? WilcoxonSignedRankTest.calculateExactPValue((int)wPlus, n, this.alternative) : WilcoxonSignedRankTest.calculateAsymptoticPValue(wPlus, n, zeros, c, this.alternative, this.continuityCorrection);
        return new Result(wPlus, tiedValues, zeros != 0, p);
    }

    private static void checkSamples(double[] x, double[] y) {
        Arguments.checkValuesRequiredSize(x.length, 1);
        Arguments.checkValuesRequiredSize(y.length, 1);
        Arguments.checkValuesSizeMatch(x.length, y.length);
    }

    private static double[] calculateDifferences(double mu, double[] x, double[] y) {
        double[] z = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            z[i] = x[i] - mu - y[i];
        }
        return z;
    }

    private static double[] calculateAbsoluteDifferences(double[] z) {
        double[] zAbs = new double[z.length];
        for (int i = 0; i < z.length; ++i) {
            zAbs[i] = Math.abs(z[i]);
        }
        return zAbs;
    }

    private static double calculateW(double[] obs, double[] ranks) {
        Sum wPlus = Sum.create();
        for (int i = 0; i < obs.length; ++i) {
            if (!(obs[i] > 0.0)) continue;
            wPlus.add(ranks[i]);
        }
        return wPlus.getAsDouble();
    }

    private static int countZeros(double[] z) {
        int c = 0;
        for (double v : z) {
            if (v != 0.0) continue;
            ++c;
        }
        if (c == z.length) {
            throw new InferenceException("All signed differences are zero");
        }
        return c;
    }

    static double calculateTieCorrection(double[] ranks) {
        double c = 0.0;
        int ties = 1;
        Arrays.sort(ranks);
        double last = Double.NaN;
        for (double rank : ranks) {
            if (last == rank) {
                ++ties;
                continue;
            }
            if (ties != 1) {
                c += Math.pow(ties, 3.0) - (double)ties;
                ties = 1;
            }
            last = rank;
        }
        return c += Math.pow(ties, 3.0) - (double)ties;
    }

    private static PValueMethod selectMethod(PValueMethod method, int n) {
        return method == PValueMethod.AUTO && n <= 50 ? PValueMethod.EXACT : method;
    }

    private static double calculateAsymptoticPValue(double wPlus, int n, double z, double c, AlternativeHypothesis alternative, boolean continuityCorrection) {
        double e = ((double)n * ((double)n + 1.0) - z * (z + 1.0)) * 0.25;
        double variance = ((double)n * ((double)n + 1.0) * ((double)(2 * n) + 1.0) - z * (z + 1.0) * (2.0 * z + 1.0) - c * 0.5) / 24.0;
        double x = wPlus - e;
        if (continuityCorrection) {
            x = alternative == AlternativeHypothesis.GREATER_THAN ? (x -= 0.5) : (alternative == AlternativeHypothesis.LESS_THAN ? (x += 0.5) : (x -= Math.signum(x) * 0.5));
        }
        x /= Math.sqrt(variance);
        NormalDistribution standardNormal = NormalDistribution.of((double)0.0, (double)1.0);
        if (alternative == AlternativeHypothesis.GREATER_THAN) {
            return standardNormal.survivalProbability(x);
        }
        if (alternative == AlternativeHypothesis.LESS_THAN) {
            return standardNormal.cumulativeProbability(x);
        }
        return 2.0 * standardNormal.survivalProbability(Math.abs(x));
    }

    private static double calculateExactPValue(int w1, int n, AlternativeHypothesis alternative) {
        int sum = n * (n + 1) / 2;
        int w2 = sum - w1;
        if (alternative == AlternativeHypothesis.GREATER_THAN) {
            return WilcoxonSignedRankTest.sf(w1 - 1, w2 + 1, n);
        }
        if (alternative == AlternativeHypothesis.LESS_THAN) {
            return WilcoxonSignedRankTest.cdf(w1, w2, n);
        }
        double p = 2.0 * WilcoxonSignedRankTest.computeCdf(Math.min(w1, w2), n);
        return Math.min(1.0, p);
    }

    private static double cdf(int w1, int w2, int n) {
        return w2 > w1 ? WilcoxonSignedRankTest.computeCdf(w1, n) : 1.0 - WilcoxonSignedRankTest.computeCdf(w2 - 1, n);
    }

    private static double sf(int w1, int w2, int n) {
        return w2 > w1 ? 1.0 - WilcoxonSignedRankTest.computeCdf(w1, n) : WilcoxonSignedRankTest.computeCdf(w2 - 1, n);
    }

    private static double computeCdf(int t, int n) {
        if (t <= 0) {
            return t < 0 ? 0.0 : (double)Math.scalb(1.0f, -n);
        }
        double[] u = new double[t + 1];
        u[1] = 1.0;
        u[0] = 1.0;
        for (int nn = 2; nn < n + 1; ++nn) {
            for (int tt = t; tt >= nn; --tt) {
                int n2 = tt;
                u[n2] = u[n2] + u[tt - nn];
            }
        }
        double sum = Arrays.stream(u).sum();
        return Math.scalb(sum, -n);
    }

    public static final class Result
    extends BaseSignificanceResult {
        private final boolean tiedValues;
        private final boolean zeroValues;

        Result(double statistic, boolean tiedValues, boolean zeroValues, double p) {
            super(statistic, p);
            this.tiedValues = tiedValues;
            this.zeroValues = zeroValues;
        }

        public boolean hasTiedValues() {
            return this.tiedValues;
        }

        public boolean hasZeroValues() {
            return this.zeroValues;
        }
    }
}

